/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.wizard.displayer;

import VASSAL.build.GameModule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.api.wizard.WizardResultReceiver;
import org.netbeans.api.wizard.displayer.NavButtonManager;
import org.netbeans.api.wizard.displayer.NavProgress;
import org.netbeans.modules.wizard.InstructionsPanel;
import org.netbeans.modules.wizard.MergeMap;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPanel;

public class WizardDisplayerImpl
extends WizardDisplayer {
    ResultProgressHandle progress = null;
    JLabel ttlLabel = null;
    JPanel ttlPanel = null;
    Wizard wizard = null;
    JPanel outerPanel = null;
    NavButtonManager buttonManager = null;
    InstructionsPanel instructions = null;
    MergeMap settings = null;
    JPanel inner = null;
    JLabel problem = null;
    Object wizardResult = null;
    WizardResultReceiver receiver = null;
    JComponent wizardPanel = null;
    boolean inSummary = false;
    DeferredWizardResult deferredResult = null;

    protected void buildStepTitle() {
        this.ttlLabel = new JLabel(this.wizard.getStepDescription(this.wizard.getAllSteps()[0]));
        this.ttlLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 12, 5), BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("textText"))));
        this.ttlPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void doLayout() {
                Dimension d = WizardDisplayerImpl.this.ttlLabel.getPreferredSize();
                if (WizardDisplayerImpl.this.ttlLabel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                    WizardDisplayerImpl.this.ttlLabel.setBounds(this.getWidth() - d.width, 0, this.getWidth(), d.height);
                } else {
                    WizardDisplayerImpl.this.ttlLabel.setBounds(0, 0, this.getWidth(), d.height);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return WizardDisplayerImpl.this.ttlLabel.getPreferredSize();
            }
        };
        this.ttlPanel.add(this.ttlLabel);
        Font f = this.ttlLabel.getFont();
        if (f == null) {
            f = UIManager.getFont("controlFont");
        }
        if (f != null) {
            f = f.deriveFont(1);
            this.ttlLabel.setFont(f);
        }
    }

    private JPanel createOuterPanel(Wizard awizard, Rectangle bounds, Action helpAction, Map initialProperties) {
        this.wizard = awizard;
        this.outerPanel = new JPanel();
        if (bounds == null) {
            bounds = new Rectangle(0, 0, 600, 400);
        }
        if (this.wizard.getAllSteps().length == 0) {
            throw new IllegalArgumentException("Wizard has no steps");
        }
        this.buildStepTitle();
        this.buttonManager = new NavButtonManager(this);
        this.outerPanel.setLayout(new BorderLayout());
        this.instructions = new InstructionsPanel(this.wizard);
        this.buttonManager.buildButtons(helpAction);
        this.inner = new JPanel();
        this.inner.setLayout(new BorderLayout());
        this.inner.add((Component)this.ttlPanel, "North");
        this.problem = new JLabel("  ");
        Color fg = UIManager.getColor("nb.errorColor");
        this.problem.setForeground(fg == null ? Color.BLUE : fg);
        this.inner.add((Component)this.problem, "South");
        this.problem.setPreferredSize(new Dimension(20, 20));
        this.inner.setPreferredSize(new Dimension(450, 450));
        this.outerPanel.add((Component)this.buttonManager.getButtons(), "South");
        JSplitPane split = new JSplitPane(1);
        split.setLeftComponent(this.instructions);
        split.setRightComponent(this.inner);
        this.outerPanel.add((Component)split, "Center");
        String first = this.wizard.getAllSteps()[0];
        this.settings = new MergeMap(first);
        if (initialProperties != null) {
            this.settings.putAll(initialProperties);
        }
        this.wizardPanel = this.wizard.navigatingTo(first, (Map)this.settings);
        String desc = this.wizard.getLongDescription(first);
        if (desc != null) {
            this.ttlLabel.setText(desc);
        }
        this.inner.add((Component)this.wizardPanel, "Center");
        this.buttonManager.initializeNavigation();
        return this.outerPanel;
    }

    public void install(Container c, Object layoutConstraint, Wizard awizard, Action helpAction, Map initialProperties, WizardResultReceiver receiver) {
        JPanel pnl = this.createOuterPanel(awizard, new Rectangle(), helpAction, initialProperties);
        if (layoutConstraint != null) {
            c.add((Component)pnl, layoutConstraint);
        } else {
            c.add(pnl);
        }
        this.receiver = receiver;
    }

    public Object show(Wizard awizard, Rectangle bounds, Action helpAction, Map initialProperties) {
        this.createOuterPanel(awizard, bounds, helpAction, initialProperties);
        Object result = this.showInDialog(bounds);
        return result;
    }

    protected JDialog createDialog() {
        Window o = this.findLikelyOwnerWindow();
        JDialog dlg = o instanceof Frame ? new JDialog((Frame)o) : (o instanceof Dialog ? new JDialog((Dialog)o) : new JDialog(GameModule.getGameModule().getPlayerWindow()));
        return dlg;
    }

    protected Object showInDialog(Rectangle bounds) {
        JDialog dlg = this.createDialog();
        this.buttonManager.setWindow((Window)dlg);
        dlg.setTitle(this.wizard.getTitle());
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)this.outerPanel, "Center");
        if (bounds != null) {
            dlg.setBounds(bounds);
        } else {
            dlg.pack();
            Rectangle screenBounds = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            GraphicsConfiguration config = dlg.getGraphicsConfiguration();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
            screenBounds.translate(insets.left, insets.top);
            screenBounds.setSize(screenBounds.width - insets.left - insets.right, screenBounds.height - insets.top - insets.bottom);
            if (dlg.getWidth() > screenBounds.width) {
                dlg.setSize(screenBounds.width, dlg.getHeight());
            }
        }
        dlg.setDefaultCloseOperation(0);
        dlg.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                if (!(e.getWindow() instanceof JDialog)) {
                    return;
                }
                JDialog dlg = (JDialog)e.getWindow();
                boolean dontClose = false;
                if (!WizardDisplayerImpl.this.wizard.isBusy()) {
                    try {
                        if (WizardDisplayerImpl.this.deferredResult != null && WizardDisplayerImpl.this.deferredResult.canAbort()) {
                            WizardDisplayerImpl.this.deferredResult.abort();
                        } else if (WizardDisplayerImpl.this.deferredResult != null && !WizardDisplayerImpl.this.deferredResult.canAbort()) {
                            dontClose = true;
                            return;
                        }
                    }
                    finally {
                        if (!dontClose && WizardDisplayerImpl.this.wizard.cancel((Map)WizardDisplayerImpl.this.settings)) {
                            dlg.setVisible(false);
                            dlg.dispose();
                        }
                    }
                }
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (d.width - dlg.getWidth()) / 2;
        int y = (d.height - dlg.getHeight()) / 2;
        dlg.setLocation(x, y);
        dlg.setModal(true);
        dlg.getRootPane().setDefaultButton(this.buttonManager.getNext());
        dlg.setVisible(true);
        return this.wizardResult;
    }

    private Window findLikelyOwnerWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public WizardPanel getCurrentWizardPanel() {
        JComponent comp = this.wizardPanel;
        if (comp instanceof WizardPanel) {
            return (WizardPanel)comp;
        }
        return null;
    }

    public String getCurrentStep() {
        return this.settings.currID();
    }

    static void checkLegalNavMode(int i) {
        switch (i) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new IllegalArgumentException("Illegal forward navigation mode: " + i);
    }

    public void setCurrentWizardPanel(JComponent comp) {
        this.inner.add((Component)comp, "Center");
        this.inner.remove(this.wizardPanel);
        this.wizardPanel = comp;
        this.inner.invalidate();
        this.inner.revalidate();
        this.inner.repaint();
        comp.requestFocus();
        if (!this.inSummary) {
            this.buttonManager.updateButtons();
        }
    }

    void handleSummary(Summary summary) {
        this.inSummary = true;
        JComponent summaryComp = (JComponent)summary.getSummaryComponent();
        if (summaryComp.getBorder() != null) {
            CompoundBorder b = new CompoundBorder(new EmptyBorder(5, 5, 5, 5), summaryComp.getBorder());
            summaryComp.setBorder(b);
        }
        this.setCurrentWizardPanel(summaryComp);
        this.instructions.setInSummaryPage(true);
        this.ttlLabel.setText(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayerImpl.class, "Summary"));
        this.getButtonManager().setSummaryShowingMode();
        summaryComp.requestFocus();
    }

    ResultProgressHandle createProgressDisplay(boolean isUseBusy) {
        return new NavProgress(this, isUseBusy);
    }

    void handleDeferredWizardResult(final DeferredWizardResult r) {
        this.deferredResult = r;
        this.wizardPanel.setEnabled(false);
        this.progress = this.createProgressDisplay(r.isUseBusy());
        this.progress.addProgressComponents((Container)this.instructions);
        this.instructions.invalidate();
        this.instructions.revalidate();
        this.instructions.repaint();
        Runnable run = new Runnable(){
            final /* synthetic */ WizardDisplayerImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    try {
                        this.this$0.instructions.setInSummaryPage(true);
                        this.this$0.buttonManager.getWindow().setCursor(Cursor.getPredefinedCursor(3));
                        r.start((Map)this.this$0.settings, this.this$0.progress);
                        if (!this.this$0.progress.isRunning()) return;
                        this.this$0.progress.failed("Start method did not inidicate failure or finished in " + String.valueOf(r), false);
                        return;
                    }
                    finally {
                        try {
                            EventQueue.invokeAndWait(this);
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            ex.printStackTrace();
                            return;
                        }
                        finally {
                            this.this$0.buttonManager.getWindow().setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                this.this$0.deferredResult = null;
                this.this$0.buttonManager.getCancel().setEnabled(true);
                this.this$0.instructions.removeAll();
                this.this$0.instructions.invalidate();
                this.this$0.instructions.revalidate();
                this.this$0.instructions.repaint();
            }
        };
        Thread runner = new Thread(run, "Wizard Background Result Thread " + String.valueOf(r));
        runner.start();
    }

    public void navigateTo(String id) {
        JComponent comp = this.wizard.navigatingTo(id, (Map)this.getSettings());
        String description = this.wizard.getLongDescription(id);
        if (description == null) {
            description = this.wizard.getStepDescription(id);
        }
        this.getTtlLabel().setText(description);
        this.setCurrentWizardPanel(comp);
    }

    public NavButtonManager getButtonManager() {
        return this.buttonManager;
    }

    public DeferredWizardResult getDeferredResult() {
        return this.deferredResult;
    }

    public InstructionsPanel getInstructions() {
        return this.instructions;
    }

    public boolean isInSummary() {
        return this.inSummary;
    }

    public void setInSummary(boolean state) {
        this.inSummary = state;
    }

    public JPanel getOuterPanel() {
        return this.outerPanel;
    }

    public MergeMap getSettings() {
        return this.settings;
    }

    public JLabel getTtlLabel() {
        return this.ttlLabel;
    }

    public JPanel getTtlPanel() {
        return this.ttlPanel;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public JComponent getWizardPanel() {
        return this.wizardPanel;
    }

    public Object getWizardResult() {
        return this.wizardResult;
    }

    public void setWizardResult(Object wizardResult) {
        this.wizardResult = wizardResult;
        if (this.receiver != null) {
            this.receiver.finished(wizardResult);
        }
    }

    public void setDeferredResult(DeferredWizardResult deferredResult) {
        this.deferredResult = deferredResult;
    }

    boolean cancel() {
        boolean result;
        GameModule.getGameModule().getPlayerRoster().reset();
        boolean bl = result = this.receiver != null;
        if (result) {
            this.receiver.cancelled((Map)this.settings);
        }
        return result;
    }

    void updateProblem() {
        String prob = this.wizard.getProblem();
        this.problem.setText(prob == null ? " " : prob);
        if (prob != null && prob.trim().length() == 0) {
            prob = null;
        }
        Border b = prob == null ? BorderFactory.createEmptyBorder(1, 0, 0, 0) : BorderFactory.createMatteBorder(1, 0, 0, 0, this.problem.getForeground());
        CompoundBorder b1 = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12), b);
        this.problem.setBorder(b1);
    }
}

