/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.AboutScreen;
import VASSAL.build.module.documentation.BrowserHelpFile;
import VASSAL.build.module.documentation.BrowserPDFFile;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.Tutorial;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.MenuManager;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.w3c.dom.Element;

public class Documentation
extends AbstractConfigurable {
    public static final String INTRO_FILE = "/help/Intro.html";
    public static final String INTRO_FILENAME = "Intro.html";

    public JMenu getHelpMenu() {
        JMenuBar mb = MenuManager.getInstance().getMenuBarFor(GameModule.getGameModule().getPlayerWindow());
        return mb.getMenu(mb.getMenuCount() - 1);
    }

    @Override
    public void build(Element el) {
        if (el == null) {
            AboutScreen about = new AboutScreen();
            about.setAttribute("title", Resources.getString("Documentation.about_module"));
            about.setAttribute("fileName", "/images/Splash.png");
            about.addTo(this);
            this.add(about);
            HelpFile intro = new HelpFile();
            intro.setAttribute("title", Resources.getString("Documentation.quick_start"));
            intro.setAttribute("fileName", INTRO_FILE);
            intro.setAttribute("fileType", "resource");
            intro.setAttribute("vassalDoc", "vassal");
            intro.addTo(this);
            this.add(intro);
        } else {
            super.build(el);
        }
    }

    public static File getDocumentationBaseDir() {
        return Info.getDocDir();
    }

    @Override
    public void addTo(Buildable b) {
    }

    @Override
    public void removeFrom(Buildable b) {
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{BrowserPDFFile.class, BrowserHelpFile.class, HelpFile.class, AboutScreen.class, Tutorial.class};
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Documentation.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        File dir = Documentation.getDocumentationBaseDir();
        dir = new File(dir, "ReferenceManual");
        try {
            return new HelpFile(null, new File(dir, "HelpMenu.html"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
            return null;
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public String getAttributeValueString(String name) {
        return null;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }
}

