/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.properties.AbstractScenarioProperty;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.ScenarioPropertiesOptionTab;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class ScenarioOptions
implements GameComponent {
    private static ScenarioOptions instance;
    protected JDialog dialog;
    protected final JTabbedPane optionTabs = new JTabbedPane();
    protected Action openAction;
    protected JButton launch;
    protected GlobalProperties globalProperties;

    public static void setInstance(ScenarioOptions options) {
        instance = options;
    }

    public static ScenarioOptions getInstance() {
        return instance;
    }

    public ScenarioOptions(GlobalProperties props) {
        GameModule gm = GameModule.getGameModule();
        GlobalOptions go = GlobalOptions.getInstance();
        ScenarioOptions.setInstance(this);
        this.globalProperties = props;
        this.getDialog();
        gm.getGameState().addGameComponent(this);
        this.launch = new JButton();
        this.launch.setFocusable(false);
        this.launch.setAlignmentY(0.0f);
        this.launch.setText("ScenarioOptions");
        ActionListener al = evt -> this.toggleVisible();
        this.launch.addActionListener(al);
        NamedKeyStrokeListener l = new NamedKeyStrokeListener(al);
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setEnabled(this.getOpenAction().isEnabled());
        IconConfigurer iconConfig = new IconConfigurer("scenarioPropertiesIcon", Resources.getString("Editor.ScenarioProperties.icon"), "");
        iconConfig.setValue("");
        go.addOption(iconConfig);
        iconConfig.addPropertyChangeListener(evt -> {
            this.launch.setIcon(iconConfig.getIconValue());
            this.launch.setText(this.launch.getText() == null ? " " : null);
            this.launch.setVisible(this.launch.getIcon() != null);
        });
        iconConfig.fireUpdate();
        NamedHotKeyConfigurer keyConfig = new NamedHotKeyConfigurer("scenarioPropertiesHotKey", Resources.getString("Editor.ScenarioProperties.hotkey"), l.getNamedKeyStroke());
        go.addOption(keyConfig);
        keyConfig.addPropertyChangeListener(evt -> {
            l.setKeyStroke(keyConfig.getValueNamedKeyStroke());
            this.launch.setToolTipText(Resources.getString("Editor.ScenarioProperties.hotkey_tooltip", NamedHotKeyConfigurer.getString(l.getKeyStroke())));
        });
        keyConfig.fireUpdate();
        gm.addKeyStrokeListener(l);
        gm.getToolBar().add(this.launch);
        this.launch.setText(this.launch.getIcon() == null ? " " : null);
        this.launch.setVisible(this.launch.getIcon() != null);
    }

    protected void toggleVisible() {
        if (this.getDialog().isVisible()) {
            this.cancel();
        } else if (this.getOpenAction().isEnabled()) {
            this.open();
        }
    }

    public JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)GameModule.getGameModule().getPlayerWindow(), true);
            this.dialog.setTitle(Resources.getString("ScenarioOptions.window_title"));
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    ScenarioOptions.this.cancel();
                }
            });
            JButton ok = new JButton(Resources.getString("General.ok"));
            ok.addActionListener(e -> this.processChanges());
            JButton cancel = new JButton(Resources.getString("General.cancel"));
            cancel.addActionListener(e -> this.cancel());
            this.dialog.setLayout((LayoutManager)new MigLayout("insets dialog", "[push,fill]"));
            JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("insets dialog", "[push,fill]"));
            contentPanel.add((Component)this.optionTabs, "push, grow, wrap unrelated");
            JScrollPane scrollPane = new JScrollPane(contentPanel, 20, 30);
            JPanel scrollPanel = new JPanel(new BorderLayout());
            scrollPanel.add((Component)scrollPane, "Center");
            this.dialog.add((Component)scrollPanel, "grow, push, wrap");
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
            buttonPanel.add((Component)ok, "tag ok, sg 1");
            buttonPanel.add((Component)cancel, "tag cancel, sg 1");
            this.dialog.add((Component)buttonPanel, "grow");
            SwingUtils.setDefaultButtons(this.dialog.getRootPane(), ok, cancel);
            this.openAction = new AbstractAction(Resources.getString("ScenarioOptions.menu_text")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScenarioOptions.this.open();
                }
            };
            MenuManager.getInstance().addAction("ScenarioOptions.menu_text", this.getOpenAction());
            this.getOpenAction().setEnabled(false);
            this.rebuild();
            Dimension d = SwingUtils.getScreenSize();
            this.dialog.setLocation(d.width / 2 - this.dialog.getWidth() / 2, 0);
        }
        return this.dialog;
    }

    public Action getOpenAction() {
        return this.openAction;
    }

    public JButton getLaunchButton() {
        return this.launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChanges() {
        this.getDialog().setVisible(false);
        GameModule gm = GameModule.getGameModule();
        Command c = new NullCommand();
        boolean loggingPaused = gm.pauseLogging();
        try {
            for (ScenarioPropertiesOptionTab sptab : this.globalProperties.getAllDescendantComponentsOf(ScenarioPropertiesOptionTab.class)) {
                sptab.processChanges();
            }
        }
        finally {
            if (loggingPaused) {
                c = c.append(gm.resumeLogging());
            }
        }
        gm.sendAndLog(c);
    }

    protected void cancel() {
        this.getDialog().setVisible(false);
    }

    protected void open() {
        this.rebuild();
        this.getDialog().setVisible(true);
        SwingUtils.repack(this.getDialog());
    }

    @Override
    public void setup(boolean gameStarting) {
        this.getOpenAction().setEnabled(gameStarting && this.hasScenarioOptions());
        this.getLaunchButton().setEnabled(gameStarting && this.hasScenarioOptions());
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    protected boolean hasScenarioOptions() {
        return !this.globalProperties.getAllDescendantComponentsOf(AbstractScenarioProperty.class).isEmpty();
    }

    protected void rebuild() {
        this.optionTabs.removeAll();
        for (ScenarioPropertiesOptionTab sptab : this.globalProperties.getAllDescendantComponentsOf(ScenarioPropertiesOptionTab.class)) {
            String tabName = sptab.getConfigureName();
            if (tabName == null || tabName.isEmpty()) {
                tabName = Resources.getString("ScenarioOptions.general_tab");
            }
            this.optionTabs.add(sptab.getConfigureName(), sptab.getUI());
            this.optionTabs.add(sptab.getConfigureName(), sptab.getUI());
        }
        this.dialog.pack();
    }
}

