/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.ServerAddressBook;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClient
extends HybridClient {
    private static final Logger log = LoggerFactory.getLogger(DynamicClient.class);
    private boolean connecting;

    protected ChatServerConnection buildDelegate() throws IOException {
        Properties p = ServerAddressBook.getInstance().getCurrentServerProperties();
        return ChatServerFactory.build(p);
    }

    @Override
    public void setConnected(final boolean connect) {
        if (connect && !this.isConnected()) {
            if (!this.connecting) {
                this.connecting = true;
                new SwingWorker<ChatServerConnection, Void>(this){
                    final /* synthetic */ DynamicClient this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    protected ChatServerConnection doInBackground() throws Exception {
                        return this.this$0.buildDelegate();
                    }

                    @Override
                    protected void done() {
                        try {
                            this.this$0.setDelegate((ChatServerConnection)this.get());
                            DynamicClient.super.setConnected(connect);
                        }
                        catch (InterruptedException e) {
                            log.error("Error while connecting: interrupted", (Throwable)e);
                        }
                        catch (ExecutionException ex) {
                            Throwable e = ex.getCause();
                            this.this$0.fireStatus(Resources.getString("Server.bad_address3"));
                            ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.network_communication_error", new Object[0]);
                            e.printStackTrace();
                        }
                        this.this$0.connecting = false;
                    }
                }.execute();
            }
        } else {
            super.setConnected(connect);
            if (!this.isConnected()) {
                try {
                    this.setDelegate(this.buildDelegate());
                }
                catch (IOException ex) {
                    log.error("Error while connecting", (Throwable)ex);
                }
            }
        }
    }
}

