/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.MsgSender;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.PlayerNode;
import VASSAL.chat.node.Protocol;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class ServerNode
extends Node {
    private static final Logger logger = Logger.getLogger(ServerNode.class.getName());
    private final SendContentsTask sendContents = new SendContentsTask();

    public ServerNode() {
        super(null, null, null);
        Timer t = new Timer();
        t.schedule((TimerTask)this.sendContents, 0L, 1000L);
    }

    public synchronized void forward(String senderPath, String msg) {
        MsgSender target = this.getMsgSender(senderPath);
        target.send(msg);
    }

    public synchronized MsgSender getMsgSender(String path) {
        Node[] target = new Node[]{this};
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(path, '/');
        while (st.hasMoreTokens()) {
            int i;
            Node node;
            int n;
            String childId = st.nextToken();
            if ("*".equals(childId)) {
                ArrayList<Node> l = new ArrayList<Node>();
                Node[] nodeArray = target;
                int n2 = nodeArray.length;
                for (n = 0; n < n2; ++n) {
                    node = nodeArray[n];
                    l.addAll(Arrays.asList(node.getChildren()));
                }
                target = l.toArray(new Node[0]);
                continue;
            }
            if (childId.startsWith("~")) {
                childId = childId.substring(1);
                ArrayList<Node> l = new ArrayList<Node>();
                Node[] nodeArray = target;
                int n3 = nodeArray.length;
                for (n = 0; n < n3; ++n) {
                    node = nodeArray[n];
                    for (Node child : node.getChildren()) {
                        if (childId.equals(child.getId())) continue;
                        l.add(child);
                    }
                }
                target = l.toArray(new Node[0]);
                continue;
            }
            int n4 = target.length;
            for (i = 0; i < n4; ++i) {
                Node child = target[i].getChild(childId);
                if (child == null) continue;
                target = new Node[]{child};
                break;
            }
            if (i != n4) continue;
            target = new Node[]{};
        }
        MsgSender[] senders = Arrays.copyOf(target, target.length);
        return msg -> {
            for (MsgSender sender : senders) {
                sender.send(msg);
            }
        };
    }

    public synchronized void disconnect(Node target) {
        Node mod = this.getModule(target);
        if (mod != null) {
            Node room = target.getParent();
            room.remove(target);
            if (room.getChildren().length == 0) {
                room.getParent().remove(room);
            }
            if (mod.getChildren().length == 0) {
                this.remove(mod);
            }
            this.sendContents(mod);
        }
    }

    protected synchronized void sendContents(Node module) {
        this.sendContents.markChanged(module);
    }

    public synchronized void registerNode(String parentPath, Node newNode) {
        Node newParent = ServerNode.build(this, parentPath);
        newParent.add(newNode);
        Node module = this.getModule(newParent);
        if (module != null) {
            this.sendContents(module);
        }
    }

    public Node getModule(Node n) {
        Node module;
        for (module = n; module != null && module.getParent() != this; module = module.getParent()) {
        }
        return module;
    }

    public synchronized void move(Node target, String newParentPath) {
        Node oldMod = this.getModule(target);
        Node newParent = ServerNode.build(this, newParentPath);
        newParent.add(target);
        Node mod = this.getModule(newParent);
        if (mod != null) {
            this.sendContents(mod);
        }
        if (oldMod != mod && oldMod != null) {
            this.sendContents(oldMod);
        }
    }

    public synchronized void updateInfo(Node target) {
        Node mod = this.getModule(target);
        if (mod != null) {
            this.sendContents(mod);
        }
    }

    public synchronized void kick(PlayerNode kicker, String kickeeId) {
        String roomOwnerId;
        Node roomNode = kicker.getParent();
        try {
            roomOwnerId = new PropertiesEncoder(roomNode.getInfo()).getProperties().getProperty("owner");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (roomOwnerId == null || !roomOwnerId.equals(kicker.getId())) {
            return;
        }
        Node kickeeNode = roomNode.getChild(kickeeId);
        if (kickeeNode == null) {
            return;
        }
        Node defaultRoomNode = roomNode.getParent().getChildren()[0];
        this.move(kickeeNode, defaultRoomNode.getPath());
    }

    private static class SendContentsTask
    extends TimerTask {
        private final Set<Node> modules = new HashSet<Node>();

        private SendContentsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markChanged(Node module) {
            Set<Node> set = this.modules;
            synchronized (set) {
                this.modules.add(module);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<Node> s = new HashSet<Node>();
            Set<Node> set = this.modules;
            synchronized (set) {
                s.addAll(this.modules);
            }
            for (Node module : s) {
                logger.fine("Sending contents of " + module.getId());
                Node[] players = module.getLeafDescendants();
                Node[] rooms = module.getChildren();
                String listCommand = Protocol.encodeListCommand(players);
                module.send(listCommand);
                logger.finer(listCommand);
                String roomInfo = Protocol.encodeRoomsInfo(rooms);
                module.send(roomInfo);
                logger.finer(roomInfo);
            }
            set = this.modules;
            synchronized (set) {
                this.modules.clear();
            }
        }
    }
}

