/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class StringEnumConfigurer
extends Configurer {
    private String[] validValues;
    private JComboBox<String> box;
    private ConfigurerPanel panel;

    public StringEnumConfigurer(String key, String name, String[] validValues) {
        super(key, name);
        this.validValues = validValues;
    }

    public JComboBox<String> getBox() {
        return this.box;
    }

    public void setBox(JComboBox<String> box) {
        this.box = box;
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new ConfigurerPanel(this.getName(), "[]", "[]rel[]");
            this.box = new JComboBox<String>(this.validValues);
            final Color enabledColor = UIManager.getColor("Combobox.foreground");
            this.box.setRenderer(new DefaultListCellRenderer(this){
                final /* synthetic */ StringEnumConfigurer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void paint(Graphics g) {
                    if (!this.this$0.box.isEnabled()) {
                        this.setForeground(enabledColor);
                    }
                    super.paint(g);
                }
            });
            this.box.setMaximumSize(new Dimension(this.box.getMaximumSize().width, this.box.getPreferredSize().height));
            if (this.isValidValue(this.getValue())) {
                this.box.setSelectedItem(this.getValue());
            } else if (this.validValues.length > 0) {
                this.box.setSelectedIndex(0);
            }
            this.box.addActionListener(e -> {
                this.noUpdate = true;
                this.setValue(this.box.getSelectedItem());
                this.noUpdate = false;
            });
            this.panel.add(this.box);
        }
        return this.panel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
    }

    public void setEditable(boolean enabled) {
        this.box.setEditable(enabled);
    }

    public boolean isValidValue(Object o) {
        for (String validValue : this.validValues) {
            if (!validValue.equals(o)) continue;
            return true;
        }
        return false;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String[] s) {
        this.validValues = s;
        if (this.box == null) {
            this.getControls();
        }
        this.box.setModel(new DefaultComboBoxModel<String>(this.validValues));
    }

    @Override
    public void setValue(Object o) {
        if (this.validValues == null || this.isValidValue(o)) {
            super.setValue(o);
            if (!this.noUpdate && this.box != null) {
                this.box.setSelectedItem(o);
            }
        }
    }

    @Override
    public String getValueString() {
        return this.value == null ? "" : (String)this.value;
    }

    @Override
    public void setValue(String s) {
        this.setValue((Object)s);
    }

    @Override
    public void setLabelVisible(boolean visible) {
        this.panel.setLabelVisibility(visible);
    }
}

