/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.command.Command;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.KeyStroke;

public class GlobalCommandVisitor
implements DeckVisitor {
    protected Command command;
    private final BoundsTracker tracker;
    protected final PieceFilter filter;
    private final KeyStroke stroke;
    protected int selectedCount;
    private Auditable owner;
    protected final AuditTrail auditSoFar;
    private int selectFromDeck;
    private GlobalCommand globalCommand;
    private final Set<String> seen = new HashSet<String>();

    public GlobalCommandVisitor(Command command, PieceFilter filter, KeyStroke stroke) {
        this(command, filter, stroke, null);
    }

    public GlobalCommandVisitor(Command command, PieceFilter filter, KeyStroke stroke, AuditTrail audit) {
        this.command = command;
        this.tracker = new BoundsTracker();
        this.filter = filter;
        this.stroke = stroke;
        this.auditSoFar = audit;
    }

    public GlobalCommandVisitor(Command command, PieceFilter filter, KeyStroke stroke, AuditTrail audit, Auditable owner, int selectFromDeck) {
        this(command, filter, stroke, audit);
        this.owner = owner;
        this.selectFromDeck = selectFromDeck;
    }

    public GlobalCommandVisitor(Command command, PieceFilter filter, KeyStroke stroke, AuditTrail audit, Auditable owner, int selectFromDeck, GlobalCommand globalCommand) {
        this(command, filter, stroke, audit, owner, selectFromDeck);
        this.globalCommand = globalCommand;
    }

    public void setOwner(Auditable val) {
        this.owner = val;
    }

    public void setSelectFromDeck(int val) {
        this.selectFromDeck = val;
    }

    public int getSelectFromDeck() {
        return this.selectFromDeck;
    }

    public void setSelectedCount(int selectedCount) {
        this.selectedCount = selectedCount;
    }

    public int getSelectedCount() {
        return this.selectedCount;
    }

    @Override
    public Object visitDeck(Deck d) {
        if (!d.isAccessible()) {
            return null;
        }
        if (this.getSelectFromDeck() != 0) {
            d.setDragCount(d.getPieceCount());
            this.selectedCount = 0;
            PieceIterator it = d.drawCards();
            while (it.hasMoreElements() && (this.getSelectFromDeck() < 0 || this.getSelectFromDeck() > this.selectedCount)) {
                this.apply(it.nextPiece(), true);
            }
        }
        return null;
    }

    @Override
    public Object visitStack(Stack s) {
        s.asList().forEach(this::apply);
        return null;
    }

    @Override
    public Object visitDefault(GamePiece p) {
        this.apply(p);
        return null;
    }

    protected void apply(GamePiece p) {
        this.apply(p, false);
    }

    protected void apply(GamePiece p, boolean visitingDeck) {
        String uid = (String)p.getProperty("PieceUID");
        if (this.seen.contains(uid)) {
            return;
        }
        this.seen.add(uid);
        AuditTrail audit = null;
        if (this.auditSoFar != null) {
            audit = new AuditTrail(this.auditSoFar);
            audit.addMessage(Resources.getString("Audit.gkc_applied_to", p.getComponentName()));
        }
        if (this.filter == null || this.filter.accept(p, this.owner, audit)) {
            if (visitingDeck) {
                p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
            }
            this.tracker.addPiece(p);
            p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
            this.command = this.command.append(Decorator.setDynamicProperties(this.globalCommand.getParameters(), p, this.globalCommand.getPropertySource(), this.owner, this.auditSoFar));
            this.command = this.command.append(p.keyEvent(this.stroke));
            this.tracker.addPiece(p);
            ++this.selectedCount;
        } else if (visitingDeck) {
            p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
        }
    }

    public Command getCommand() {
        return this.command;
    }

    public BoundsTracker getTracker() {
        return this.tracker;
    }
}

