/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MovementMarkable
extends Decorator
implements TranslatablePiece {
    public static final String ID = "markmoved;";
    private int xOffset = 0;
    private int yOffset = 0;
    private String command;
    private NamedKeyStroke key;
    private String commandTrue;
    private NamedKeyStroke keyTrue;
    private String commandFalse;
    private NamedKeyStroke keyFalse;
    private final IconConfigurer movedIcon = new IconConfigurer("/images/moved.gif");
    private boolean hasMoved = false;
    private String description;
    private boolean ignoreSameLocation = false;
    private KeyCommand[] commands = null;

    public MovementMarkable() {
        this("markmoved;moved.gif;0;0", null);
    }

    public MovementMarkable(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    public boolean isMoved() {
        return this.hasMoved;
    }

    public void setMoved(boolean b) {
        this.hasMoved = b;
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.movedIcon.setValue(st.nextToken());
        this.xOffset = st.nextInt(0);
        this.yOffset = st.nextInt(0);
        this.command = st.nextToken(Resources.getString("Editor.MovementMarkable.default_command"));
        this.key = st.nextNamedKeyStroke('M');
        this.description = st.nextToken("");
        this.ignoreSameLocation = st.nextBoolean(false);
        this.commandTrue = st.nextToken(Resources.getString("Editor.MovementMarkable.default_command_true"));
        try {
            this.keyTrue = st.nextNamedKeyStroke();
        }
        catch (NoSuchElementException e) {
            this.keyTrue = NamedKeyStroke.NULL_KEYSTROKE;
        }
        this.commandFalse = st.nextToken(Resources.getString("Editor.MovementMarkable.default_command_false"));
        try {
            this.keyFalse = st.nextNamedKeyStroke();
        }
        catch (NoSuchElementException e) {
            this.keyFalse = NamedKeyStroke.NULL_KEYSTROKE;
        }
        this.commands = null;
    }

    @Override
    public void mySetState(String newState) {
        this.hasMoved = "true".equals(newState);
        if (this.ignoreSameLocation) {
            GameModule.getGameModule().setTrueMovedSupport(true);
        }
    }

    @Override
    public String myGetState() {
        return String.valueOf(this.hasMoved);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.movedIcon.getValueString()).append(this.xOffset).append(this.yOffset).append(this.command).append(this.key).append(this.description).append(this.ignoreSameLocation).append(this.commandTrue).append(this.keyTrue).append(this.commandFalse).append(this.keyFalse);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> list = new ArrayList<KeyCommand>();
            this.addMenuCommand(list, this.command, this.key);
            this.addMenuCommand(list, this.commandTrue, this.keyTrue);
            this.addMenuCommand(list, this.commandFalse, this.keyFalse);
            this.commands = list.isEmpty() ? KeyCommand.NONE : list.toArray(new KeyCommand[0]);
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        if (stroke == null) {
            return null;
        }
        if (this.key.equals(stroke)) {
            ChangeTracker c = new ChangeTracker(this);
            MovementMarkable.getOutermost(this).setProperty("Moved", !this.hasMoved);
            return c.getChangeCommand();
        }
        if (this.keyTrue.equals(stroke)) {
            ChangeTracker c = new ChangeTracker(this);
            MovementMarkable.getOutermost(this).setProperty("Moved", true);
            return c.getChangeCommand();
        }
        if (this.keyFalse.equals(stroke)) {
            ChangeTracker c = new ChangeTracker(this);
            MovementMarkable.getOutermost(this).setProperty("Moved", false);
            return c.getChangeCommand();
        }
        return null;
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        if (GlobalOptions.getInstance().isShowMarkMoved() && this.hasMoved) {
            Dimension d = this.getImageSize();
            r.add(new Rectangle(this.xOffset, this.yOffset, d.width, d.height));
        }
        return r;
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
        if (!GlobalOptions.getInstance().isShowMarkMoved()) {
            return;
        }
        if (this.hasMoved && this.movedIcon.getIconValue() != null) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform transform = g2d.getTransform();
            g2d.scale(zoom, zoom);
            this.movedIcon.getIconValue().paintIcon(obs, g, (int)Math.round((double)x / zoom) + this.xOffset, (int)Math.round((double)y / zoom) + this.yOffset);
            g2d.setTransform(transform);
        }
    }

    private Dimension getImageSize() {
        Icon icon = this.movedIcon.getIconValue();
        return icon != null ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : new Dimension();
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.MovementMarkable.trait_description", this.description);
        s = (String)s + this.getCommandDesc(this.command, this.key);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.MovementMarkable.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MarkMoved.html");
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("Moved".equals(key)) {
            return this.isMoved() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ("Moved".equals(key)) {
            return this.isMoved() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(key);
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Moved".equals(key)) {
            this.setMoved(Boolean.TRUE.equals(val));
            this.piece.setProperty(key, val);
        } else if ("MaybeMoved".equals(key)) {
            if (!this.ignoreSameLocation) {
                this.setMoved(Boolean.TRUE.equals(val));
            }
            this.piece.setProperty(key, val);
        } else {
            super.setProperty(key, val);
        }
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, Resources.getString("Editor.MovementMarkable.mark_moved_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof MovementMarkable)) {
            return false;
        }
        MovementMarkable c = (MovementMarkable)o;
        if (!Objects.equals(this.movedIcon.getValueString(), c.movedIcon.getValueString())) {
            return false;
        }
        if (!Objects.equals(this.xOffset, c.xOffset)) {
            return false;
        }
        if (!Objects.equals(this.yOffset, c.yOffset)) {
            return false;
        }
        if (!Objects.equals(this.command, c.command)) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.ignoreSameLocation, c.ignoreSameLocation)) {
            return false;
        }
        if (!Objects.equals(this.keyTrue, c.keyTrue)) {
            return false;
        }
        if (!Objects.equals(this.keyFalse, c.keyFalse)) {
            return false;
        }
        if (!Objects.equals(this.commandTrue, c.commandTrue)) {
            return false;
        }
        if (!Objects.equals(this.commandFalse, c.commandFalse)) {
            return false;
        }
        return Objects.equals(this.hasMoved, c.hasMoved);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Moved");
        return l;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return List.of(this.key, this.keyTrue, this.keyFalse);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command, this.commandTrue, this.commandFalse);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        String iconName = this.movedIcon.getValueString();
        if (iconName != null) {
            s.add(iconName);
        }
    }

    private static class Ed
    implements PieceEditor {
        private final IconConfigurer iconConfig;
        private final IntConfigurer xOff;
        private final IntConfigurer yOff;
        private final StringConfigurer command;
        private final NamedHotKeyConfigurer key;
        private final TraitConfigPanel box = new TraitConfigPanel();
        private final StringConfigurer descInput;
        private final BooleanConfigurer sameConfig;
        private final StringConfigurer commandTrue;
        private final NamedHotKeyConfigurer keyTrue;
        private final StringConfigurer commandFalse;
        private final NamedHotKeyConfigurer keyFalse;

        private Ed(MovementMarkable p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descInput);
            this.command = new StringConfigurer(p.command);
            this.command.setHintKey("Editor.menu_command_hint");
            this.box.add("Editor.MovementMarkable.menu_command", (Configurer)this.command);
            this.key = new NamedHotKeyConfigurer(p.key);
            this.box.add("Editor.MovementMarkable.key_command", (Configurer)this.key);
            this.commandTrue = new StringConfigurer(p.commandTrue);
            this.commandTrue.setHintKey("Editor.menu_command_hint");
            this.box.add("Editor.MovementMarkable.menu_command_true", (Configurer)this.commandTrue);
            this.keyTrue = new NamedHotKeyConfigurer(p.keyTrue);
            this.box.add("Editor.MovementMarkable.key_command_true", (Configurer)this.keyTrue);
            this.commandFalse = new StringConfigurer(p.commandFalse);
            this.commandFalse.setHintKey("Editor.menu_command_hint");
            this.box.add("Editor.MovementMarkable.menu_command_false", (Configurer)this.commandFalse);
            this.keyFalse = new NamedHotKeyConfigurer(p.keyFalse);
            this.box.add("Editor.MovementMarkable.key_command_false", (Configurer)this.keyFalse);
            this.sameConfig = new BooleanConfigurer(p.ignoreSameLocation);
            this.box.add("Editor.MovementMarkable.ignore_same_location", (Configurer)this.sameConfig);
            this.iconConfig = p.movedIcon;
            this.box.add("Editor.MovementMarkable.marker_image", (Configurer)this.iconConfig);
            this.xOff = new IntConfigurer(p.xOffset);
            this.box.add("Editor.MovementMarkable.horizontal_offset", (Configurer)this.xOff);
            this.yOff = new IntConfigurer(p.yOffset);
            this.box.add("Editor.MovementMarkable.vertical_offset", (Configurer)this.yOff);
        }

        @Override
        public Component getControls() {
            boolean enabled = false;
            for (Map m : Map.getMapList()) {
                String value = m.getAttributeValueString("markMoved");
                enabled = enabled || "Always".equals(value) || "Use Preferences Setting".equals(value);
            }
            if (!enabled) {
                Runnable runnable = () -> JOptionPane.showMessageDialog(this.box, Resources.getString("Editor.MovementMarkable.enable_text"), Resources.getString("Editor.MovementMarkable.option_not_enabled"), 2);
                SwingUtilities.invokeLater(runnable);
            }
            return this.box;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.iconConfig.getValueString()).append(this.xOff.getValueString()).append(this.yOff.getValueString()).append(this.command.getValueString()).append(this.key.getValueString()).append(this.descInput.getValueString()).append(this.sameConfig.getValueString()).append(this.commandTrue.getValueString()).append(this.keyTrue.getValueString()).append(this.commandFalse.getValueString()).append(this.keyFalse.getValueString());
            return MovementMarkable.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "false";
        }
    }
}

