/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ScaleOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FixedScaleOpBitmapImpl
extends AbstractTiledOpImpl
implements ScaleOp {
    protected final ImageOp sop;
    protected final RenderingHints hints;
    protected final double scale;
    protected final int hash;
    protected static final RenderingHints defaultHints = ImageUtils.getDefaultHints();

    public FixedScaleOpBitmapImpl(ImageOp sop, double scale, int width, int height) {
        this(sop, scale, width, height, defaultHints);
    }

    public FixedScaleOpBitmapImpl(ImageOp sop, double scale, int width, int height, RenderingHints hints) {
        if (sop == null) {
            throw new IllegalArgumentException("Attempt to scale null image");
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Cannot scale image at " + scale);
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Cannot scale image to width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Cannot scale image to height " + height);
        }
        this.sop = sop;
        this.scale = scale;
        this.size = new Dimension(width, height);
        this.hints = hints;
        this.hash = new HashCodeBuilder().append((Object)sop).append(scale).append((Object)this.size).append((Object)hints).toHashCode();
    }

    @Override
    protected void fixSize() {
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        return ImageUtils.transform(this.sop.getImage(null), this.size.width, this.size.height, this.hints);
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new TileOp(this, tileX, tileY);
    }

    @Override
    public RenderingHints getHints() {
        return this.hints;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FixedScaleOpBitmapImpl op = (FixedScaleOpBitmapImpl)o;
        return this.size.equals(op.size) && this.sop.equals(op.sop) && this.hints.equals(op.hints);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[sop=" + String.valueOf(this.sop) + ",size=" + String.valueOf(this.size) + ",hints=" + String.valueOf(this.hints) + "]";
    }

    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp sop;
        private final Rectangle dr;
        private final int dx0;
        private final int dy0;
        private final int dw;
        private final int dh;
        private final RenderingHints hints;
        private final int hash;
        private static final GeneralFilter.Filter downFilter = new GeneralFilter.Lanczos3Filter();
        private static final GeneralFilter.Filter upFilter = new GeneralFilter.MitchellFilter();

        public TileOp(FixedScaleOpBitmapImpl rop, int tileX, int tileY) {
            if (rop == null) {
                throw new IllegalArgumentException();
            }
            if (tileX < 0 || tileX >= rop.getNumXTiles() || tileY < 0 || tileY >= rop.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.sop = rop.sop;
            this.hints = rop.getHints();
            this.dr = new Rectangle(rop.getSize());
            this.dx0 = tileX * rop.getTileWidth();
            this.dy0 = tileY * rop.getTileHeight();
            this.dw = Math.min(rop.getTileWidth(), this.dr.width - this.dx0);
            this.dh = Math.min(rop.getTileHeight(), this.dr.height - this.dy0);
            this.size = new Dimension(this.dw, this.dh);
            this.hash = new HashCodeBuilder().append((Object)this.sop).append(this.dx0).append(this.dy0).append(this.dw).append(this.dh).append((Object)this.dr).toHashCode();
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.singletonList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            if (this.dw < 1 || this.dh < 1) {
                return ImageUtils.NULL_IMAGE;
            }
            BufferedImage src = ImageUtils.coerceToIntType(this.sop.getImage(null));
            WritableRaster dstR = src.getColorModel().createCompatibleWritableRaster(this.dw, this.dh).createWritableTranslatedChild(this.dx0, this.dy0);
            GeneralFilter.zoom(dstR, this.dr, src, this.dr.width < src.getWidth() ? downFilter : upFilter);
            return ImageUtils.toCompatibleImage(new BufferedImage(src.getColorModel(), dstR.createWritableTranslatedChild(0, 0), src.isAlphaPremultiplied(), null));
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            TileOp op = (TileOp)o;
            return this.dx0 == op.dx0 && this.dy0 == op.dy0 && this.dw == op.dw && this.dh == op.dh && this.dr.equals(op.dr) && this.sop.equals(op.sop);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[sop=" + String.valueOf(this.sop) + ",dx0=" + this.dx0 + ",dy0=" + this.dy0 + ",dw=" + this.dw + ",dy=" + this.dh + "]";
        }
    }
}

