/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AbstractFolder;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerHand;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.properties.SumProperties;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.image.LabelUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class CounterDetailViewer
extends AbstractConfigurable
implements Drawable,
DragSourceMotionListener,
MouseMotionListener,
MouseListener,
KeyListener {
    public static final String LATEST_VERSION = "4";
    public static final String USE_KEYBOARD = "ShowCounterDetails";
    public static final String PREFERRED_DELAY = "PreferredDelay";
    public static final String DELAY = "delay";
    public static final String DRAW_PIECES = "showgraph";
    public static final String GRAPH_SINGLE_DEPRECATED = "showgraphsingle";
    public static final String MINIMUM_DISPLAYABLE = "minDisplayPieces";
    public static final String HOTKEY = "hotkey";
    public static final String DESCRIPTION = "description";
    public static final String CENTER_TEXT = "centerText";
    public static final String CENTER_ALL = "centerAll";
    public static final String COMBINE_COUNTER_SUMMARY = "combineCounterSummary";
    public static final String ONLY_SHOW_FIRST_SUMMARY = "onlyShowFirstSummary";
    public static final String VERTICAL_OFFSET = "verticalOffset";
    public static final String VERTICAL_TOP_TEXT = "verticalTopText";
    public static final String VERTICAL_BOTTOM_TEXT = "verticalBottomText";
    public static final String STRETCH_WIDTH_SUMMARY = "stretchWidthSummary";
    public static final String STRETCH_WIDTH_PIECES = "stretchWidthPieces";
    public static final String SHOW_TEXT = "showtext";
    public static final String ENABLE_HTML = "enableHTML";
    public static final String SHOW_TEXT_SINGLE_DEPRECATED = "showtextsingle";
    public static final String ZOOM_LEVEL = "zoomlevel";
    public static final String CENTER_PIECES_VERTICALLY = "centerPiecesVertically";
    public static final String DRAW_PIECES_AT_ZOOM = "graphicsZoom";
    public static final String BORDER_WIDTH = "borderWidth";
    public static final String SHOW_ONLY_TOP_OF_STACK = "showOnlyTopOfStack";
    public static final String BORDER_THICKNESS = "borderThickness";
    public static final String BORDER_INNER_THICKNESS = "borderInnerThickness";
    public static final String SHOW_NOSTACK = "showNoStack";
    public static final String SHOW_MOVE_SELECTED = "showMoveSelectde";
    public static final String SHOW_NON_MOVABLE = "showNonMovable";
    public static final String SHOW_DECK = "showDeck";
    public static final String SHOW_DECK_DEPTH = "showDeckDepth";
    public static final String SHOW_DECK_MASKED = "showDeckMasked";
    public static final String SHOW_OVERLAP = "showOverlap";
    public static final String UNROTATE_PIECES = "unrotatePieces";
    public static final String DISPLAY = "display";
    public static final String LAYER_LIST = "layerList";
    public static final String SUMMARY_REPORT_FORMAT = "summaryReportFormat";
    public static final String COUNTER_REPORT_FORMAT = "counterReportFormat";
    public static final String EMPTY_HEX_REPORT_FORMAT = "emptyHexReportForma";
    public static final String VERSION = "version";
    public static final String FG_COLOR = "fgColor";
    public static final String BG_COLOR = "bgColor";
    public static final String BORDER_COLOR = "borderColor";
    public static final String FONT_SIZE = "fontSize";
    public static final String EXTRA_TEXT_PADDING = "extraTextPadding";
    public static final String PROPERTY_FILTER = "propertyFilter";
    public static final String STOP_AFTER_SHOWING = "stopAfterShowing";
    public static final String SHOW_TERRAIN_BENEATH = "showTerrainBeneath";
    public static final String SHOW_TERRAIN_SNAPPY = "showTerrainSnappy";
    public static final String SHOW_TERRAIN_WIDTH = "showTerrainWidth";
    public static final String SHOW_TERRAIN_HEIGHT = "showTerrainHeight";
    public static final String SHOW_TERRAIN_ZOOM = "showTerrainZoom";
    public static final String SHOW_TERRAIN_TEXT = "showTerrainText";
    public static final String NEVER = "never";
    public static final String IF_ONE = "ifOne";
    public static final String ALWAYS = "always";
    public static final String TOP_LAYER = "from top-most layer only";
    public static final String ALL_LAYERS = "from all layers";
    public static final String INC_LAYERS = "from listed layers only";
    public static final String EXC_LAYERS = "from layers other than those listed";
    public static final String FILTER = "by using a property filter";
    public static final String SUM = "sum(propertyName)";
    protected KeyStroke hotkey = KeyStroke.getKeyStroke(32, 128);
    protected Map map;
    protected int delay = 700;
    protected Timer delayTimer;
    protected boolean graphicsVisible = false;
    protected boolean textVisible = false;
    protected MouseEvent currentMousePosition;
    protected String desc = "";
    protected int minimumDisplayablePieces = 2;
    protected boolean drawPieces = true;
    protected boolean centerPiecesVertically = false;
    protected boolean drawSingleDeprecated = false;
    protected boolean showText = false;
    protected boolean showTextSingleDeprecated = false;
    protected boolean enableHTML = false;
    protected boolean centerAll = false;
    protected boolean centerText = false;
    protected boolean combineCounterSummary = false;
    protected boolean onlyShowFirstSummary = false;
    protected int verticalOffset = 0;
    protected int verticalTopText = 5;
    protected int verticalBottomText = 10;
    protected boolean stretchWidthSummary = false;
    protected boolean stretchWidthPieces = false;
    protected boolean unrotatePieces = false;
    protected boolean showDeck = false;
    protected boolean stopAfterShowing = false;
    protected String showTerrainBeneath = "never";
    protected int showTerrainWidth = 150;
    protected int showTerrainHeight = 150;
    protected double showTerrainZoom = 1.0;
    protected boolean showTerrainSnappy = true;
    @Deprecated(since="2021-12-01", forRemoval=true)
    protected static int showDeckDepth = 1;
    protected int showNumberFromDeck = 1;
    protected boolean showDeckMasked = false;
    protected boolean showOverlap = false;
    protected double zoomLevel = 1.0;
    protected double graphicsZoomLevel = 1.0;
    private double graphicsZoom = 1.0;
    private double terrainZoom = 1.0;
    protected int borderWidth = 0;
    protected int borderThickness = 2;
    protected int borderInnerThickness = 2;
    protected int extraTextPadding = 0;
    protected boolean showOnlyTopOfStack = false;
    protected boolean showNoStack = false;
    protected boolean showMoveSelected = false;
    protected boolean showNonMovable = false;
    protected String displayWhat = "from top-most layer only";
    protected String[] displayLayers = new String[0];
    protected FormattedString summaryReportFormat = new FormattedString("$LocationName$");
    protected FormattedString counterReportFormat = new FormattedString("");
    protected FormattedString emptyHexReportFormat = new FormattedString("$LocationName$");
    protected FormattedString showTerrainText = new FormattedString("$LocationName$");
    protected String version = "";
    protected Color fgColor = Color.black;
    protected Color bgColor;
    protected Color borderColor = Color.black;
    protected int fontSize = 9;
    protected Font font = new Font("Dialog", 0, this.fontSize);
    protected PropertyExpression propertyFilter = new PropertyExpression();
    protected Rectangle bounds = new Rectangle();
    protected Rectangle lastPieceBounds = new Rectangle();
    protected boolean mouseInView = true;
    protected List<GamePiece> displayablePieces = null;
    protected boolean displayableTerrain = false;
    protected JComponent view;
    private int excessWidth = 0;
    boolean useInnerTop = false;
    boolean useInnerBottom = false;
    String topText = "";
    String terrainText = "";

    @Deprecated(since="2023-02-15", forRemoval=true)
    public static boolean isDrawingMouseOver() {
        return Map.getMapList().stream().anyMatch(Map::isDrawingMouseOver);
    }

    public boolean isStopAfterShowing() {
        return this.stopAfterShowing;
    }

    public CounterDetailViewer() {
        this.delayTimer = new Timer(this.delay, e -> {
            if (this.mouseInView) {
                this.showDetails();
            }
        });
        this.delayTimer.setRepeats(false);
    }

    public Map getMap() {
        return this.map;
    }

    @Override
    public void addTo(Buildable b) {
        this.checkUpgrade();
        if (b instanceof AbstractFolder) {
            b = ((AbstractFolder)b).getNonFolderAncestor();
        }
        if (!(b instanceof Map)) {
            return;
        }
        this.map = (Map)b;
        this.view = this.map.getView();
        this.map.addDrawComponent(this);
        String keyDesc = this.hotkey == null ? "" : "(" + HotKeyConfigurer.getString(this.hotkey) + ")";
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.general_tab"), new BooleanConfigurer(USE_KEYBOARD, Resources.getString("CounterDetailViewer.use_prompt", keyDesc), Boolean.FALSE));
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.general_tab"), new IntConfigurer(PREFERRED_DELAY, Resources.getString("CounterDetailViewer.delay_prompt"), (Integer)this.delay));
        this.view.addMouseMotionListener(this);
        this.view.addMouseListener(this);
        this.view.addKeyListener(this);
        DragSource.getDefaultDragSource().addDragSourceMotionListener(this);
        this.setAttributeTranslatable(VERSION, false);
        this.setAttributeTranslatable(SUMMARY_REPORT_FORMAT, true);
        this.setAttributeTranslatable(COUNTER_REPORT_FORMAT, true);
    }

    @Override
    public void draw(Graphics g, Map map) {
        if (this.currentMousePosition != null && this.view.getVisibleRect().contains(this.currentMousePosition.getPoint())) {
            this.draw(g, this.currentMousePosition.getPoint(), this.view);
        }
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    public void draw(Graphics g, Point pt, JComponent comp) {
        if (!this.graphicsVisible && !this.textVisible) {
            return;
        }
        if (this.map.isAnyMouseoverDrawn()) {
            return;
        }
        this.bounds.x = pt.x;
        this.bounds.y = pt.y;
        this.bounds.width = 0;
        this.bounds.height = 0;
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        g2d.setFont(this.font.deriveFont((float)((double)this.fontSize * os_scale)));
        this.map.setDrawingMouseOver(true);
        if (this.textVisible) {
            this.prepareText();
        }
        if (this.graphicsVisible) {
            this.drawGraphics(g, pt, comp, this.displayablePieces);
        }
        if (this.textVisible) {
            this.drawText(g, pt, comp, this.displayablePieces);
        }
        this.map.setDrawingMouseOver(false);
    }

    protected void drawGraphics(Graphics g, Point pt, JComponent comp, List<GamePiece> pieces) {
        this.fixBounds(pieces, g);
        if (this.bounds.width <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        Rectangle dbounds = new Rectangle(this.bounds);
        dbounds.x = (int)((double)dbounds.x * os_scale);
        dbounds.y = (int)((double)dbounds.y * os_scale);
        dbounds.width = (int)((double)dbounds.width * os_scale);
        dbounds.height = (int)((double)dbounds.height * os_scale);
        Rectangle visibleRect = comp.getVisibleRect();
        visibleRect.x = (int)((double)visibleRect.x * os_scale);
        visibleRect.y = (int)((double)visibleRect.y * os_scale);
        visibleRect.width = (int)((double)visibleRect.width * os_scale);
        visibleRect.height = (int)((double)visibleRect.height * os_scale);
        int origX = dbounds.x;
        dbounds.x = Math.min(dbounds.x, visibleRect.x + visibleRect.width - dbounds.width);
        dbounds.y = Math.min(dbounds.y, visibleRect.y + visibleRect.height - dbounds.height) - (this.isTextUnderCounters() ? 15 : 0);
        dbounds.y = Math.max(dbounds.y, visibleRect.y + (this.textVisible ? g.getFontMetrics().getHeight() + 6 : 0));
        if (this.centerAll) {
            dbounds.x -= Math.max(0, dbounds.width / 2 - Math.abs(origX - dbounds.x));
        }
        this.lastPieceBounds.x = dbounds.x = Math.max(dbounds.x, visibleRect.x);
        this.lastPieceBounds.y = dbounds.y;
        this.lastPieceBounds.width = dbounds.width;
        this.lastPieceBounds.height = dbounds.height;
        if (this.borderColor != null && this.borderThickness > 0) {
            g.setColor(this.borderColor);
            int topThickness = this.useInnerTop ? this.borderInnerThickness : this.borderThickness;
            int bottomThickness = this.useInnerBottom ? this.borderInnerThickness : this.borderThickness;
            g.fillRect(dbounds.x - (int)((double)this.borderThickness * os_scale), dbounds.y - (int)((double)topThickness * os_scale), dbounds.width + (int)((double)(this.borderThickness * 2) * os_scale), dbounds.height + (int)((double)(topThickness + bottomThickness) * os_scale));
        }
        if (this.bgColor != null) {
            g.setColor(this.bgColor);
            g.fillRect(dbounds.x, dbounds.y, dbounds.width, dbounds.height);
        }
        dbounds.x += this.excessWidth / 2;
        Shape oldClip = g.getClip();
        int borderOffset = this.borderWidth;
        boolean anyUnderText = false;
        boolean masterBoxDrawn = false;
        if (this.displayableTerrain) {
            Collection<Board> boards = this.map.getBoards();
            if (!boards.isEmpty()) {
                Point ptMap = pieces.isEmpty() ? this.map.snapTo(this.map.componentToMap(this.currentMousePosition.getPoint()), this.showTerrainSnappy, false) : pieces.get(0).getPosition();
                Rectangle vrMap = new Rectangle(ptMap.x - this.showTerrainWidth / 2, ptMap.y - this.showTerrainHeight / 2, this.showTerrainWidth, this.showTerrainHeight);
                double mag = boards.iterator().next().getMagnification();
                double dzoom = this.terrainZoom * os_scale / mag;
                Rectangle drect = new Rectangle((int)((double)vrMap.x * this.terrainZoom * os_scale / mag), (int)((double)vrMap.y * this.terrainZoom * os_scale / mag), (int)((double)vrMap.width * this.terrainZoom * os_scale / mag), (int)((double)vrMap.height * this.terrainZoom * os_scale / mag));
                g2d.setClip(dbounds.x, dbounds.y + (this.centerPiecesVertically ? (dbounds.height - drect.height) / 2 : 0), (int)Math.ceil((double)this.showTerrainWidth * this.terrainZoom * os_scale), (int)Math.ceil((double)this.showTerrainHeight * this.terrainZoom * os_scale));
                AffineTransform orig_t = g2d.getTransform();
                AffineTransform at = new AffineTransform(orig_t);
                at.translate(dbounds.x - drect.x, dbounds.y - drect.y);
                g2d.setTransform(at);
                for (Board b : boards) {
                    b.drawRegion(g2d, this.map.getLocation(b, dzoom), drect, dzoom, null);
                }
                if (this.isStopAfterShowing()) {
                    this.map.setAnyMouseoverDrawn(true);
                }
                g2d.setTransform(orig_t);
                g2d.setClip(oldClip);
            }
            if (this.textVisible && !this.terrainText.isEmpty()) {
                int y = dbounds.y + dbounds.height + (int)((double)(this.verticalBottomText + this.extraTextPadding * 2) * os_scale);
                if ((this.useInnerBottom ? this.borderInnerThickness : this.borderThickness) > 2) {
                    y = (int)((double)y - (double)((this.useInnerBottom ? this.borderInnerThickness : this.borderThickness) - 2) * os_scale);
                }
                if (this.combineCounterSummary && this.stretchWidthSummary) {
                    this.drawLabel(g, new Point(this.lastPieceBounds.x - 1, y), pieces.isEmpty() ? this.terrainText : " ", 0, 0, this.lastPieceBounds.width + 2, this.lastPieceBounds.width + (int)((double)(this.borderThickness * 2) * os_scale), (int)((double)(this.borderThickness - 1) * os_scale), false, (int)((double)((this.useInnerBottom ? this.borderInnerThickness : this.borderThickness) - 1) * os_scale), (int)((double)(this.borderThickness - 1) * os_scale));
                    masterBoxDrawn = true;
                } else {
                    int x = dbounds.x + (int)((double)borderOffset * os_scale);
                    this.drawLabel(g, new Point(x, y), this.terrainText, 0, 0, (int)((double)this.showTerrainWidth * this.graphicsZoom * os_scale), 0, 0, false, 0, 0);
                }
                anyUnderText = true;
            }
            dbounds.translate((int)Math.ceil((double)this.showTerrainWidth * this.terrainZoom * os_scale), 0);
            borderOffset += this.borderWidth;
        }
        Object owner = null;
        for (GamePiece piece : pieces) {
            Rectangle pieceBounds = this.getBounds(piece);
            if (this.unrotatePieces) {
                piece.setProperty("useUnrotatedShape", Boolean.TRUE);
            }
            g.setClip(dbounds.x - 3, dbounds.y - 3, dbounds.width + 5, dbounds.height + 5);
            Stack parent = piece.getParent();
            if (parent instanceof Deck) {
                owner = piece.getProperty("obs;");
                boolean faceDown = ((Deck)parent).isFaceDown();
                piece.setProperty("obs;", faceDown ? "nobody" : null);
            }
            if (this.graphicsZoom > 0.0) {
                int yOffset = (int)((double)pieceBounds.y * this.graphicsZoom * os_scale);
                yOffset = this.centerPiecesVertically ? (yOffset -= dbounds.height / 2 - (int)((double)pieceBounds.height * this.graphicsZoom * os_scale) / 2) : (yOffset -= (int)((double)this.borderWidth * os_scale));
                piece.draw(g, dbounds.x - (int)((double)pieceBounds.x * this.graphicsZoom * os_scale) + (int)((double)borderOffset * os_scale), dbounds.y - yOffset, comp, this.graphicsZoom * os_scale);
                if (this.isStopAfterShowing()) {
                    this.map.setAnyMouseoverDrawn(true);
                }
            }
            if (parent instanceof Deck) {
                piece.setProperty("obs;", owner);
            }
            if (this.unrotatePieces) {
                piece.setProperty("useUnrotatedShape", Boolean.FALSE);
            }
            g.setClip(oldClip);
            if (this.isTextUnderCounters()) {
                String text = this.counterReportFormat.getLocalizedText((PropertySource)piece, (Auditable)this, "Editor.MouseOverStackViewer.text_below");
                int y = dbounds.y + dbounds.height + (int)((double)(this.verticalBottomText + this.extraTextPadding * 2) * os_scale);
                if ((this.useInnerBottom ? this.borderInnerThickness : this.borderThickness) > 2) {
                    y = (int)((double)y + (double)((this.useInnerBottom ? this.borderInnerThickness : this.borderThickness) - 2) * os_scale);
                }
                if (text.length() > 0) {
                    if (this.combineCounterSummary && this.stretchWidthSummary) {
                        if (!anyUnderText) {
                            this.drawLabel(g, new Point(this.lastPieceBounds.x - 1, y), pieces.size() == 1 || this.onlyShowFirstSummary ? text : " ", 0, 0, this.lastPieceBounds.width + 2, this.lastPieceBounds.width + (int)((double)(this.borderThickness * 2) * os_scale), (int)((double)(this.borderThickness - 1) * os_scale), false, (int)((double)((this.useInnerBottom ? this.borderInnerThickness : this.borderThickness) - 1) * os_scale), (int)((double)(this.borderThickness - 1) * os_scale));
                        }
                        y = (int)((double)y - (double)(this.borderThickness - 1) * os_scale);
                    }
                    if (!(this.stretchWidthSummary && this.onlyShowFirstSummary || this.combineCounterSummary && this.stretchWidthSummary && pieces.size() == 1 && !masterBoxDrawn)) {
                        int x = dbounds.x + (int)((double)borderOffset * os_scale);
                        this.drawLabel(g, new Point(x, y), text, 0, 0, (int)((double)pieceBounds.width * this.graphicsZoom * os_scale), 0, 0, this.combineCounterSummary && this.stretchWidthSummary, 0, 0);
                    }
                    anyUnderText = true;
                }
            }
            dbounds.translate((int)Math.ceil((double)pieceBounds.width * this.graphicsZoom * os_scale), 0);
            borderOffset += this.borderWidth;
        }
        this.bounds.x = (int)((double)dbounds.x / os_scale);
        this.bounds.y = (int)((double)dbounds.y / os_scale);
        this.bounds.width = (int)((double)dbounds.width / os_scale);
        this.bounds.height = (int)((double)dbounds.height / os_scale);
    }

    protected void fixBounds(List<GamePiece> pieces) {
        this.fixBounds(pieces, null);
    }

    protected void fixBounds(List<GamePiece> pieces, Graphics g) {
        this.graphicsZoom = this.graphicsZoomLevel;
        this.terrainZoom = this.showTerrainZoom;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double maxWidth = screenSize.getWidth();
        int origWidth = this.bounds.width;
        int origHeight = this.bounds.height;
        do {
            this.bounds.width = origWidth;
            this.bounds.height = origHeight;
            if (this.displayableTerrain) {
                this.bounds.width += (int)Math.ceil((double)this.showTerrainWidth * this.terrainZoom) + this.borderWidth;
                this.bounds.height = Math.max(this.bounds.height, (int)Math.ceil((double)this.showTerrainHeight * this.terrainZoom) + this.borderWidth * 2);
            }
            for (GamePiece piece : pieces) {
                Dimension pieceBounds = this.getBounds(piece).getSize();
                this.bounds.width += (int)Math.ceil((double)pieceBounds.width * this.graphicsZoom) + this.borderWidth;
                this.bounds.height = Math.max(this.bounds.height, (int)Math.ceil((double)pieceBounds.height * this.graphicsZoom) + this.borderWidth * 2);
            }
            this.bounds.width += this.borderWidth;
            if (!((double)this.bounds.width > maxWidth)) continue;
            this.graphicsZoom *= 0.66666;
            this.terrainZoom *= 0.66666;
        } while ((double)this.bounds.width > maxWidth);
        this.bounds.y -= this.bounds.height;
        if (this.isTextUnderCounters() || this.displayableTerrain && !this.showTerrainBeneath.isEmpty()) {
            this.bounds.y -= this.fontSize + 2 + this.extraTextPadding * 2;
        }
        this.bounds.y -= this.verticalOffset;
        this.useInnerTop = false;
        this.useInnerBottom = false;
        this.excessWidth = 0;
        if (this.textVisible && this.stretchWidthPieces && (!pieces.isEmpty() || this.displayableTerrain) && g != null) {
            this.useInnerTop = !this.topText.isEmpty();
            int width = this.getTextWidth(this.topText, g);
            if ((width += this.extraTextPadding * 2 + this.borderThickness * 2) > this.bounds.width) {
                this.excessWidth = width - this.bounds.width;
                this.bounds.width = width;
            }
            if (this.stretchWidthSummary) {
                String bottomText = "";
                if (!pieces.isEmpty()) {
                    if (pieces.size() == 1 || this.onlyShowFirstSummary) {
                        bottomText = this.counterReportFormat.getLocalizedText((PropertySource)pieces.get(0), (Auditable)this, "Editor.MouseOverStackViewer.text_below");
                    }
                } else if (this.displayableTerrain && !this.showTerrainText.getFormat().isEmpty()) {
                    bottomText = this.terrainText;
                }
                if (!bottomText.isEmpty()) {
                    this.useInnerBottom = true;
                    width = this.getTextWidth(bottomText, g);
                    if ((width += this.extraTextPadding * 2 + this.borderThickness * 2) > this.bounds.width) {
                        this.excessWidth += width - this.bounds.width;
                        this.bounds.width = width;
                    }
                } else if (this.isTextUnderCounters() && this.combineCounterSummary) {
                    this.useInnerBottom = true;
                }
            }
        }
    }

    int getTextWidth(String text, Graphics g) {
        if (this.enableHTML) {
            if (!((String)text).contains("<html>")) {
                text = "<html>" + (String)text + "</html>";
            }
        } else {
            text = " " + (String)text + " ";
        }
        JLabel j = new JLabel((String)text);
        j.setFont(g.getFont());
        return j.getPreferredSize().width;
    }

    void prepareText() {
        this.topText = this.displayablePieces.isEmpty() ? this.getEmptyText() : this.getSummaryText();
        this.terrainText = "";
        if (this.displayableTerrain && !this.showTerrainText.getFormat().isEmpty()) {
            this.terrainText = this.getTerrainBeneathText();
        }
    }

    String getTerrainBeneathText() {
        Point mapPt = this.map.componentToMap(this.currentMousePosition.getPoint());
        Point snapPt = this.map.snapTo(mapPt, this.showTerrainSnappy, false);
        String locationName = this.map.localizedLocationName(snapPt);
        this.showTerrainText.setProperty("LocationName", locationName.equals(Resources.getString("Map.offboard")) ? "" : locationName);
        this.showTerrainText.setProperty("CurrentMap", this.map.getLocalizedMapName());
        Board b = this.map.findBoard(snapPt);
        String boardName = b == null ? "" : b.getLocalizedName();
        this.showTerrainText.setProperty("CurrentBoard", boardName);
        Zone z = this.map.findZone(snapPt);
        String zone = z == null ? "" : z.getLocalizedName();
        this.showTerrainText.setProperty("CurrentZone", zone);
        return this.showTerrainText.getLocalizedText(this, "Editor.MouseOverStackViewer.text_below");
    }

    String getSummaryText() {
        GamePiece topPiece = this.displayablePieces.get(0);
        String locationName = (String)topPiece.getLocalizedProperty("LocationName");
        this.summaryReportFormat.setProperty("LocationName", locationName.equals(Resources.getString("Map.offboard")) ? "" : locationName);
        return this.summaryReportFormat.getLocalizedText((PropertySource)new SumProperties(this.displayablePieces), (Auditable)this, "Editor.MouseOverStackViewer.summary_text");
    }

    String getEmptyText() {
        Point mapPt = this.map.componentToMap(this.currentMousePosition.getPoint());
        Point snapPt = this.map.snapTo(mapPt, false, true);
        String locationName = this.map.localizedLocationName(snapPt);
        this.emptyHexReportFormat.setProperty("LocationName", locationName.equals(Resources.getString("Map.offboard")) ? "" : locationName);
        this.emptyHexReportFormat.setProperty("CurrentMap", this.map.getLocalizedMapName());
        Board b = this.map.findBoard(snapPt);
        String boardName = b == null ? "" : b.getLocalizedName();
        this.emptyHexReportFormat.setProperty("CurrentBoard", boardName);
        Zone z = this.map.findZone(snapPt);
        String zone = z == null ? "" : z.getLocalizedName();
        this.emptyHexReportFormat.setProperty("CurrentZone", zone);
        return this.emptyHexReportFormat.getLocalizedText(this, "Editor.MouseOverStackViewer.text_empty");
    }

    protected Rectangle getBounds(GamePiece piece) {
        if (this.unrotatePieces) {
            piece.setProperty("useUnrotatedShape", Boolean.TRUE);
        }
        Rectangle pieceBounds = piece.getShape().getBounds();
        if (this.unrotatePieces) {
            piece.setProperty("useUnrotatedShape", Boolean.FALSE);
        }
        return pieceBounds;
    }

    protected boolean isTextUnderCounters() {
        return this.textVisible && this.counterReportFormat.getFormat().length() > 0;
    }

    protected void drawText(Graphics g, Point pt, JComponent comp, List<GamePiece> pieces) {
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        if (this.topText.isEmpty()) {
            return;
        }
        int y = (int)((double)(this.bounds.y - this.verticalTopText) * os_scale);
        if (this.displayablePieces.isEmpty() && !this.displayableTerrain) {
            int x = (int)((double)(this.bounds.x - this.bounds.width) * os_scale);
            y = (int)((double)(this.bounds.y - this.verticalTopText) * os_scale);
            if (this.centerAll) {
                x -= g.getFontMetrics().stringWidth(this.topText) / 2;
            }
            this.drawLabel(g, new Point(x, y), this.topText, 1, 4, 0, 0, this.borderThickness - 1, false);
        } else if (this.graphicsVisible) {
            int x = this.lastPieceBounds.x - 1;
            if ((this.useInnerTop ? this.borderInnerThickness : this.borderThickness) > 2) {
                y = (int)((double)y + (double)((this.useInnerTop ? this.borderInnerThickness : this.borderThickness) - 2) * os_scale);
            }
            this.drawLabel(g, new Point(x, y), this.topText, this.centerText ? 0 : 1, 4, this.lastPieceBounds.width + 2, this.stretchWidthSummary ? this.lastPieceBounds.width + (int)((double)(this.borderThickness * 2) * os_scale) : 0, this.stretchWidthSummary ? (int)((double)(this.borderThickness - 1) * os_scale) : 0, false, this.stretchWidthSummary ? (int)((double)(this.borderThickness - 1) * os_scale) : 0, this.stretchWidthSummary ? (int)((double)((this.useInnerTop ? this.borderInnerThickness : this.borderThickness) - 1) * os_scale) : 0);
        } else {
            int x = (int)((double)(this.bounds.x - this.bounds.width) * os_scale);
            this.drawLabel(g, new Point(x, y), this.topText, this.centerText ? 0 : 1, 4, 0, 0, (int)((double)(this.borderThickness - 1) * os_scale), false);
        }
    }

    protected void drawLabel(Graphics g, Point pt, String label, int hAlign, int vAlign) {
        this.drawLabel(g, pt, label, hAlign, vAlign, 0, 0, 0, false);
    }

    protected void drawLabel(Graphics g, Point pt, String label, int hAlign, int vAlign, int objectWidth, int minWidth, int extraBorder, boolean skipBox) {
        this.drawLabel(g, pt, label, hAlign, vAlign, objectWidth, minWidth, extraBorder, skipBox, extraBorder, extraBorder);
    }

    protected void drawLabel(Graphics g, Point pt, String label, int hAlign, int vAlign, int objectWidth, int minWidth, int extraBorder, boolean skipBox, int extraTop, int extraBottom) {
        if (label != null && this.fgColor != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.addRenderingHints(SwingUtils.FONT_HINTS);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            boolean useHTML = label.length() > 0 && (this.enableHTML || label.length() > 6 && "<html>".equalsIgnoreCase(label.substring(0, 6)));
            LabelUtils.drawHTMLLabel(g, label, pt.x, pt.y, g.getFont(), hAlign, vAlign, this.fgColor, skipBox ? null : this.bgColor, skipBox ? null : this.borderColor, this.map.getComponent(), objectWidth, this.extraTextPadding, minWidth, extraBorder, extraTop, extraBottom, useHTML);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.isStopAfterShowing()) {
                this.map.setAnyMouseoverDrawn(true);
            }
        }
    }

    protected void showDetails() {
        boolean anyPieces;
        double zoom = this.getZoom();
        this.displayablePieces = this.getDisplayablePieces();
        int eligiblePieces = this.displayablePieces.size();
        boolean bl = anyPieces = eligiblePieces > 0 && (eligiblePieces >= this.minimumDisplayablePieces || zoom < this.zoomLevel);
        this.displayableTerrain = ALWAYS.equals(this.showTerrainBeneath) ? true : (IF_ONE.equals(this.showTerrainBeneath) ? anyPieces : false);
        if (anyPieces || this.displayableTerrain) {
            this.graphicsVisible = this.drawPieces;
            this.textVisible = this.showText && (anyPieces && (this.summaryReportFormat.getFormat().length() > 0 || this.counterReportFormat.getFormat().length() > 0) || this.displayableTerrain && this.showTerrainText.getFormat().length() > 0);
        } else {
            this.textVisible = this.minimumDisplayablePieces == 0 && this.emptyHexReportFormat.getFormat().length() > 0;
            this.graphicsVisible = false;
        }
        this.map.repaint();
    }

    protected double getZoom() {
        return this.map.getZoom();
    }

    protected List<GamePiece> getDisplayablePieces() {
        GamePiece[] allPieces = this.map.getPieces();
        Visitor visitor = new Visitor(new Filter(), this.map, this.map.componentToMap(this.currentMousePosition.getPoint()), this.showOverlap, this.showNumberFromDeck, this.showDeckMasked, this.showOnlyTopOfStack);
        DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(visitor);
        for (int i = allPieces.length - 1; i >= 0; --i) {
            dispatcher.accept(allPieces[i]);
        }
        if (GlobalOptions.getInstance().isReverseStackViewerOrder()) {
            List<GamePiece> list = visitor.getPieces();
            Collections.reverse(list);
            return list;
        }
        return visitor.getPieces();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.graphicsVisible || this.textVisible) {
            this.hideDetails();
        } else {
            this.currentMousePosition = e;
            if (Boolean.FALSE.equals(GameModule.getGameModule().getPrefs().getValue(USE_KEYBOARD))) {
                if (this.delayTimer.isRunning()) {
                    this.delayTimer.stop();
                }
                this.delayTimer.setInitialDelay(this.getPreferredDelay());
                this.delayTimer.start();
            }
        }
    }

    protected int getPreferredDelay() {
        return (Integer)GameModule.getGameModule().getPrefs().getValue(PREFERRED_DELAY);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseInView = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInView = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.delayTimer.isRunning()) {
            this.delayTimer.stop();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseInView = true;
        if (this.delayTimer.isRunning()) {
            this.delayTimer.stop();
        }
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent e) {
        if (this.delayTimer.isRunning()) {
            this.delayTimer.stop();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.hotkey != null && Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(USE_KEYBOARD))) {
            if (this.hotkey.equals(SwingUtils.getKeyStrokeForEvent(e))) {
                this.showDetails();
            } else {
                this.hideDetails();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected void hideDetails() {
        this.graphicsVisible = false;
        this.textVisible = false;
        this.map.repaint();
    }

    protected void checkUpgrade() {
        if (!this.version.equals(LATEST_VERSION)) {
            this.upgrade();
        }
    }

    @Override
    public Configurer getConfigurer() {
        if (this.map == null) {
            this.version = LATEST_VERSION;
        } else {
            this.checkUpgrade();
        }
        return super.getConfigurer();
    }

    protected void upgrade() {
        if ("1".equals(this.version)) {
            this.minimumDisplayablePieces = !this.drawPieces && !this.showText ? Integer.MAX_VALUE : (this.drawSingleDeprecated ? 1 : 2);
            this.fgColor = this.map.getHighlighter() instanceof ColoredBorder ? ((ColoredBorder)this.map.getHighlighter()).getColor() : Color.black;
            this.bgColor = new Color(255 - this.fgColor.getRed(), 255 - this.fgColor.getGreen(), 255 - this.fgColor.getBlue());
            this.version = "2";
        }
        if ("2".equals(this.version)) {
            if (FILTER.equals(this.displayWhat)) {
                this.displayWhat = ALL_LAYERS;
            } else {
                this.propertyFilter.setExpression("");
            }
            this.version = "3";
        }
        if ("3".equals(this.version)) {
            this.borderColor = this.fgColor;
        }
        this.version = LATEST_VERSION;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{VERSION, DESCRIPTION, DELAY, HOTKEY, BG_COLOR, FG_COLOR, BORDER_COLOR, MINIMUM_DISPLAYABLE, ZOOM_LEVEL, CENTER_ALL, BORDER_THICKNESS, BORDER_INNER_THICKNESS, DRAW_PIECES, CENTER_PIECES_VERTICALLY, DRAW_PIECES_AT_ZOOM, GRAPH_SINGLE_DEPRECATED, BORDER_WIDTH, VERTICAL_OFFSET, SHOW_TEXT, ENABLE_HTML, CENTER_TEXT, STRETCH_WIDTH_SUMMARY, STRETCH_WIDTH_PIECES, COMBINE_COUNTER_SUMMARY, ONLY_SHOW_FIRST_SUMMARY, EXTRA_TEXT_PADDING, VERTICAL_TOP_TEXT, VERTICAL_BOTTOM_TEXT, SHOW_TEXT_SINGLE_DEPRECATED, FONT_SIZE, SUMMARY_REPORT_FORMAT, COUNTER_REPORT_FORMAT, EMPTY_HEX_REPORT_FORMAT, DISPLAY, LAYER_LIST, PROPERTY_FILTER, SHOW_TERRAIN_BENEATH, SHOW_TERRAIN_SNAPPY, SHOW_TERRAIN_WIDTH, SHOW_TERRAIN_HEIGHT, SHOW_TERRAIN_ZOOM, SHOW_TERRAIN_TEXT, SHOW_ONLY_TOP_OF_STACK, SHOW_NOSTACK, SHOW_MOVE_SELECTED, SHOW_NON_MOVABLE, UNROTATE_PIECES, SHOW_DECK, SHOW_DECK_MASKED, SHOW_DECK_DEPTH, SHOW_OVERLAP, STOP_AFTER_SHOWING};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.MouseOverStackViewer.version"), Resources.getString("Editor.description_label"), Resources.getString("Editor.MouseOverStackViewer.recommend_delay"), Resources.getString("Editor.MouseOverStackViewer.keyboard_shortcut"), Resources.getString("Editor.MouseOverStackViewer.bg_color"), Resources.getString("Editor.MouseOverStackViewer.text_color"), Resources.getString("Editor.MouseOverStackViewer.border_color"), Resources.getString("Editor.MouseOverStackViewer.display_pieces"), Resources.getString("Editor.MouseOverStackViewer.display_zoom"), Resources.getString("Editor.MouseOverStackViewer.center_all"), Resources.getString("Editor.MouseOverStackViewer.border_thickness"), Resources.getString("Editor.MouseOverStackViewer.border_inner_thickness"), Resources.getString("Editor.MouseOverStackViewer.draw_pieces"), Resources.getString("Editor.MouseOverStackViewer.center_pieces_vertically"), Resources.getString("Editor.MouseOverStackViewer.draw_zoom"), Resources.getString("Editor.MouseOverStackViewer.display_graphics_obselete"), Resources.getString("Editor.MouseOverStackViewer.piece_gap"), Resources.getString("Editor.MouseOverStackViewer.vertical_offset"), Resources.getString("Editor.MouseOverStackViewer.display_text"), Resources.getString("Editor.MouseOverStackViewer.enable_html"), Resources.getString("Editor.MouseOverStackViewer.center_text"), Resources.getString("Editor.MouseOverStackViewer.stretch_width_summary"), Resources.getString("Editor.MouseOverStackViewer.stretch_width_pieces"), Resources.getString("Editor.MouseOverStackViewer.combine_counter_summary"), Resources.getString("Editor.MouseOverStackViewer.only_show_first_summary"), Resources.getString("Editor.MouseOverStackViewer.extra_text_padding"), Resources.getString("Editor.MouseOverStackViewer.vertical_top_text"), Resources.getString("Editor.MouseOverStackViewer.vertical_bottom_text"), Resources.getString("Editor.MouseOverStackViewer.display_text_obsolete"), Resources.getString("Editor.font_size"), Resources.getString("Editor.MouseOverStackViewer.summary_text"), Resources.getString("Editor.MouseOverStackViewer.text_below"), Resources.getString("Editor.MouseOverStackViewer.text_empty"), Resources.getString("Editor.MouseOverStackViewer.include_pieces"), Resources.getString("Editor.MouseOverStackViewer.listed_layers"), Resources.getString("Editor.MouseOverStackViewer.piece_filter"), Resources.getString("Editor.MouseOverStackViewer.show_terrain_beneath"), Resources.getString("Editor.MouseOverStackViewer.show_terrain_snappy"), Resources.getString("Editor.MouseOverStackViewer.show_terrain_x"), Resources.getString("Editor.MouseOverStackViewer.show_terrain_y"), Resources.getString("Editor.MouseOverStackViewer.show_terrain_zoom"), Resources.getString("Editor.MouseOverStackViewer.show_terrain_text"), Resources.getString("Editor.MouseOverStackViewer.show_only_top_of_stack"), Resources.getString("Editor.MouseOverStackViewer.non_stacking"), Resources.getString("Editor.MouseOverStackViewer.move_selected"), Resources.getString("Editor.MouseOverStackViewer.non_moveable"), Resources.getString("Editor.MouseOverStackViewer.unrotated_state"), Resources.getString("Editor.MouseOverStackViewer.show_deck"), Resources.getString("Editor.MouseOverStackViewer.show_deck_masked"), Resources.getString("Editor.MouseOverStackViewer.show_deck_depth"), Resources.getString("Editor.MouseOverStackViewer.show_overlap"), Resources.getString("Editor.MouseOverStackViewer.stop_after_showing")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, Integer.class, KeyStroke.class, Color.class, Color.class, Color.class, MinConfig.class, Double.class, Boolean.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Double.class, Boolean.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, Integer.class, Integer.class, Boolean.class, Integer.class, ReportFormatConfig.class, CounterFormatConfig.class, EmptyFormatConfig.class, DisplayConfig.class, String[].class, PropertyExpression.class, TerrainConfig.class, Boolean.class, Integer.class, Integer.class, Double.class, EmptyFormatConfig.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, Boolean.class, Boolean.class};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MouseOver.html");
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.map.removeDrawComponent(this);
        this.view.removeMouseMotionListener(this);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (DELAY.equals(name)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            if (value != null) {
                this.delay = (Integer)value;
            }
        } else if (DESCRIPTION.equals(name)) {
            this.desc = (String)value;
        } else if (ENABLE_HTML.equals(name)) {
            this.enableHTML = value instanceof String ? "true".equals(value) : ((Boolean)value).booleanValue();
        } else if (CENTER_TEXT.equals(name)) {
            this.centerText = value instanceof String ? "true".equals(value) : ((Boolean)value).booleanValue();
        } else if (CENTER_ALL.equals(name)) {
            this.centerAll = value instanceof String ? "true".equals(value) : ((Boolean)value).booleanValue();
        } else if (BORDER_THICKNESS.equals(name)) {
            this.borderThickness = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (BORDER_INNER_THICKNESS.equals(name)) {
            this.borderInnerThickness = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (COMBINE_COUNTER_SUMMARY.equals(name)) {
            this.combineCounterSummary = value instanceof String ? "true".equals(value) : ((Boolean)value).booleanValue();
        } else if (ONLY_SHOW_FIRST_SUMMARY.equals(name)) {
            this.onlyShowFirstSummary = value instanceof String ? "true".equals(value) : ((Boolean)value).booleanValue();
        } else if (EXTRA_TEXT_PADDING.equals(name)) {
            this.extraTextPadding = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (VERTICAL_OFFSET.equals(name)) {
            this.verticalOffset = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (VERTICAL_TOP_TEXT.equals(name)) {
            this.verticalTopText = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (VERTICAL_BOTTOM_TEXT.equals(name)) {
            this.verticalBottomText = value instanceof String ? Integer.parseInt((String)value) : (Integer)value;
        } else if (STRETCH_WIDTH_SUMMARY.equals(name)) {
            if (value instanceof Boolean) {
                this.stretchWidthSummary = (Boolean)value;
            } else if (value instanceof String) {
                this.stretchWidthSummary = "true".equals(value);
            }
        } else if (STRETCH_WIDTH_PIECES.equals(name)) {
            if (value instanceof Boolean) {
                this.stretchWidthPieces = (Boolean)value;
            } else if (value instanceof String) {
                this.stretchWidthPieces = "true".equals(value);
            }
        } else if (HOTKEY.equals(name)) {
            this.hotkey = value instanceof String ? HotKeyConfigurer.decode((String)value) : (KeyStroke)value;
        } else if (DRAW_PIECES.equals(name)) {
            if (value instanceof Boolean) {
                this.drawPieces = (Boolean)value;
            } else if (value instanceof String) {
                this.drawPieces = "true".equals(value);
            }
        } else if (CENTER_PIECES_VERTICALLY.equals(name)) {
            if (value instanceof Boolean) {
                this.centerPiecesVertically = (Boolean)value;
            } else if (value instanceof String) {
                this.centerPiecesVertically = "true".equals(value);
            }
        } else if (GRAPH_SINGLE_DEPRECATED.equals(name)) {
            if (value instanceof Boolean) {
                this.drawSingleDeprecated = (Boolean)value;
            } else if (value instanceof String) {
                this.drawSingleDeprecated = "true".equals(value);
            }
        } else if (SHOW_TEXT.equals(name)) {
            if (value instanceof Boolean) {
                this.showText = (Boolean)value;
            } else if (value instanceof String) {
                this.showText = "true".equals(value);
            }
        } else if (SHOW_TEXT_SINGLE_DEPRECATED.equals(name)) {
            if (value instanceof Boolean) {
                this.showTextSingleDeprecated = (Boolean)value;
            } else if (value instanceof String) {
                this.showTextSingleDeprecated = "true".equals(value);
            }
        } else if (ZOOM_LEVEL.equals(name)) {
            if (value instanceof String) {
                value = Double.valueOf((String)value);
            }
            this.zoomLevel = (Double)value;
        } else if (DRAW_PIECES_AT_ZOOM.equals(name)) {
            if (value instanceof String) {
                value = Double.valueOf((String)value);
            }
            this.graphicsZoomLevel = (Double)value;
        } else if (BORDER_WIDTH.equals(name)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.borderWidth = (Integer)value;
        } else if (SHOW_ONLY_TOP_OF_STACK.equals(name)) {
            if (value instanceof Boolean) {
                this.showOnlyTopOfStack = (Boolean)value;
            } else if (value instanceof String) {
                this.showOnlyTopOfStack = "true".equals(value);
            }
        } else if (SHOW_NOSTACK.equals(name)) {
            if (value instanceof Boolean) {
                this.showNoStack = (Boolean)value;
            } else if (value instanceof String) {
                this.showNoStack = "true".equals(value);
            }
        } else if (SHOW_MOVE_SELECTED.equals(name)) {
            if (value instanceof Boolean) {
                this.showMoveSelected = (Boolean)value;
            } else if (value instanceof String) {
                this.showMoveSelected = "true".equals(value);
            }
        } else if (SHOW_NON_MOVABLE.equals(name)) {
            if (value instanceof Boolean) {
                this.showNonMovable = (Boolean)value;
            } else if (value instanceof String) {
                this.showNonMovable = "true".equals(value);
            }
        } else if (SHOW_DECK.equals(name)) {
            if (value instanceof Boolean) {
                this.showDeck = (Boolean)value;
            } else if (value instanceof String) {
                this.showDeck = "true".equals(value);
            }
        } else if (SHOW_DECK_MASKED.equals(name)) {
            if (value instanceof Boolean) {
                this.showDeckMasked = (Boolean)value;
            } else if (value instanceof String) {
                this.showDeckMasked = "true".equals(value);
            }
        } else if (SHOW_DECK_DEPTH.equals(name)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            showDeckDepth = (Integer)value;
            this.showNumberFromDeck = (Integer)value;
        } else if (SHOW_OVERLAP.equals(name)) {
            if (value instanceof Boolean) {
                this.showOverlap = (Boolean)value;
            } else if (value instanceof String) {
                this.showOverlap = "true".equals(value);
            }
        } else if (UNROTATE_PIECES.equals(name)) {
            if (value instanceof Boolean) {
                this.unrotatePieces = (Boolean)value;
            } else if (value instanceof String) {
                this.unrotatePieces = "true".equals(value);
            }
        } else if (DISPLAY.equals(name)) {
            this.displayWhat = (String)value;
        } else if (LAYER_LIST.equals(name)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.displayLayers = value;
        } else if (EMPTY_HEX_REPORT_FORMAT.equals(name)) {
            this.emptyHexReportFormat.setFormat((String)value);
        } else if (SUMMARY_REPORT_FORMAT.equals(name)) {
            this.summaryReportFormat.setFormat((String)value);
        } else if (COUNTER_REPORT_FORMAT.equals(name)) {
            this.counterReportFormat.setFormat((String)value);
        } else if (MINIMUM_DISPLAYABLE.equals(name)) {
            try {
                this.minimumDisplayablePieces = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalBuildException(e);
            }
        } else if (VERSION.equals(name)) {
            this.version = (String)value;
        } else if (FG_COLOR.equals(name)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.fgColor = (Color)value;
        } else if (BG_COLOR.equals(name)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.bgColor = (Color)value;
        } else if (BORDER_COLOR.equals(name)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.borderColor = (Color)value;
        } else if (FONT_SIZE.equals(name)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            if (value != null) {
                this.fontSize = (Integer)value;
                this.font = this.font.deriveFont((float)this.fontSize);
            }
        } else if (PROPERTY_FILTER.equals(name)) {
            this.propertyFilter.setExpression((String)value);
        } else if (STOP_AFTER_SHOWING.equals(name)) {
            if (value instanceof Boolean) {
                this.stopAfterShowing = (Boolean)value;
            } else if (value instanceof String) {
                this.stopAfterShowing = "true".equals(value);
            }
        } else if (SHOW_TERRAIN_BENEATH.equals(name)) {
            this.showTerrainBeneath = (String)value;
        } else if (SHOW_TERRAIN_SNAPPY.equals(name)) {
            if (value instanceof Boolean) {
                this.showTerrainSnappy = (Boolean)value;
            } else if (value instanceof String) {
                this.showTerrainSnappy = "true".equals(value);
            }
        } else if (SHOW_TERRAIN_WIDTH.equals(name)) {
            if (value instanceof Integer) {
                this.showTerrainWidth = (Integer)value;
            } else if (value instanceof String) {
                this.showTerrainWidth = Integer.parseInt((String)value);
            }
        } else if (SHOW_TERRAIN_HEIGHT.equals(name)) {
            if (value instanceof Integer) {
                this.showTerrainHeight = (Integer)value;
            } else if (value instanceof String) {
                this.showTerrainHeight = Integer.parseInt((String)value);
            }
        } else if (SHOW_TERRAIN_TEXT.equals(name)) {
            this.showTerrainText.setFormat((String)value);
        } else if (SHOW_TERRAIN_ZOOM.equals(name)) {
            if (value instanceof String) {
                value = Double.valueOf((String)value);
            }
            this.showTerrainZoom = (Double)value;
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if (DELAY.equals(name)) {
            return String.valueOf(this.delay);
        }
        if (DESCRIPTION.equals(name)) {
            return this.desc;
        }
        if (ENABLE_HTML.equals(name)) {
            return String.valueOf(this.enableHTML);
        }
        if (CENTER_TEXT.equals(name)) {
            return String.valueOf(this.centerText);
        }
        if (CENTER_ALL.equals(name)) {
            return String.valueOf(this.centerAll);
        }
        if (BORDER_THICKNESS.equals(name)) {
            return String.valueOf(this.borderThickness);
        }
        if (BORDER_INNER_THICKNESS.equals(name)) {
            return String.valueOf(this.borderInnerThickness);
        }
        if (COMBINE_COUNTER_SUMMARY.equals(name)) {
            return String.valueOf(this.combineCounterSummary);
        }
        if (ONLY_SHOW_FIRST_SUMMARY.equals(name)) {
            return String.valueOf(this.onlyShowFirstSummary);
        }
        if (EXTRA_TEXT_PADDING.equals(name)) {
            return String.valueOf(this.extraTextPadding);
        }
        if (VERTICAL_OFFSET.equals(name)) {
            return String.valueOf(this.verticalOffset);
        }
        if (VERTICAL_TOP_TEXT.equals(name)) {
            return String.valueOf(this.verticalTopText);
        }
        if (VERTICAL_BOTTOM_TEXT.equals(name)) {
            return String.valueOf(this.verticalBottomText);
        }
        if (STRETCH_WIDTH_SUMMARY.equals(name)) {
            return String.valueOf(this.stretchWidthSummary);
        }
        if (STRETCH_WIDTH_PIECES.equals(name)) {
            return String.valueOf(this.stretchWidthPieces);
        }
        if (HOTKEY.equals(name)) {
            return HotKeyConfigurer.encode(this.hotkey);
        }
        if (DRAW_PIECES.equals(name)) {
            return String.valueOf(this.drawPieces);
        }
        if (GRAPH_SINGLE_DEPRECATED.equals(name)) {
            return String.valueOf(this.drawSingleDeprecated);
        }
        if (SHOW_TEXT.equals(name)) {
            return String.valueOf(this.showText);
        }
        if (SHOW_TEXT_SINGLE_DEPRECATED.equals(name)) {
            return String.valueOf(this.showTextSingleDeprecated);
        }
        if (ZOOM_LEVEL.equals(name)) {
            return String.valueOf(this.zoomLevel);
        }
        if (CENTER_PIECES_VERTICALLY.equals(name)) {
            return String.valueOf(this.centerPiecesVertically);
        }
        if (DRAW_PIECES_AT_ZOOM.equals(name)) {
            return String.valueOf(this.graphicsZoomLevel);
        }
        if (BORDER_WIDTH.equals(name)) {
            return String.valueOf(this.borderWidth);
        }
        if (SHOW_ONLY_TOP_OF_STACK.equals(name)) {
            return String.valueOf(this.showOnlyTopOfStack);
        }
        if (SHOW_NOSTACK.equals(name)) {
            return String.valueOf(this.showNoStack);
        }
        if (SHOW_MOVE_SELECTED.equals(name)) {
            return String.valueOf(this.showMoveSelected);
        }
        if (SHOW_NON_MOVABLE.equals(name)) {
            return String.valueOf(this.showNonMovable);
        }
        if (SHOW_DECK.equals(name)) {
            return String.valueOf(this.showDeck);
        }
        if (SHOW_DECK_MASKED.equals(name)) {
            return String.valueOf(this.showDeckMasked);
        }
        if (SHOW_DECK_DEPTH.equals(name)) {
            return String.valueOf(this.showNumberFromDeck);
        }
        if (SHOW_OVERLAP.equals(name)) {
            return String.valueOf(this.showOverlap);
        }
        if (UNROTATE_PIECES.equals(name)) {
            return String.valueOf(this.unrotatePieces);
        }
        if (DISPLAY.equals(name)) {
            return this.displayWhat;
        }
        if (LAYER_LIST.equals(name)) {
            return StringArrayConfigurer.arrayToString(this.displayLayers);
        }
        if (EMPTY_HEX_REPORT_FORMAT.equals(name)) {
            return this.emptyHexReportFormat.getFormat();
        }
        if (SUMMARY_REPORT_FORMAT.equals(name)) {
            return this.summaryReportFormat.getFormat();
        }
        if (COUNTER_REPORT_FORMAT.equals(name)) {
            return this.counterReportFormat.getFormat();
        }
        if (MINIMUM_DISPLAYABLE.equals(name)) {
            return String.valueOf(this.minimumDisplayablePieces);
        }
        if (VERSION.equals(name)) {
            return this.version;
        }
        if (FG_COLOR.equals(name)) {
            return ColorConfigurer.colorToString(this.fgColor);
        }
        if (BG_COLOR.equals(name)) {
            return ColorConfigurer.colorToString(this.bgColor);
        }
        if (BORDER_COLOR.equals(name)) {
            return ColorConfigurer.colorToString(this.borderColor);
        }
        if (FONT_SIZE.equals(name)) {
            return String.valueOf(this.fontSize);
        }
        if (PROPERTY_FILTER.equals(name)) {
            return this.propertyFilter.getExpression();
        }
        if (STOP_AFTER_SHOWING.equals(name)) {
            return String.valueOf(this.stopAfterShowing);
        }
        if (SHOW_TERRAIN_BENEATH.equals(name)) {
            return this.showTerrainBeneath;
        }
        if (SHOW_TERRAIN_SNAPPY.equals(name)) {
            return String.valueOf(this.showTerrainSnappy);
        }
        if (SHOW_TERRAIN_WIDTH.equals(name)) {
            return String.valueOf(this.showTerrainWidth);
        }
        if (SHOW_TERRAIN_HEIGHT.equals(name)) {
            return String.valueOf(this.showTerrainHeight);
        }
        if (SHOW_TERRAIN_TEXT.equals(name)) {
            return this.showTerrainText.getFormat();
        }
        if (SHOW_TERRAIN_ZOOM.equals(name)) {
            return String.valueOf(this.showTerrainZoom);
        }
        return null;
    }

    @Override
    public String getConfigureName() {
        return this.desc;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.MouseOverStackViewer.component_type");
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(CENTER_PIECES_VERTICALLY, BORDER_WIDTH, DRAW_PIECES_AT_ZOOM, VERTICAL_OFFSET).contains(name)) {
            return () -> this.drawPieces;
        }
        if (List.of(FONT_SIZE, SUMMARY_REPORT_FORMAT, COUNTER_REPORT_FORMAT, ENABLE_HTML, CENTER_TEXT, EXTRA_TEXT_PADDING, VERTICAL_TOP_TEXT, VERTICAL_BOTTOM_TEXT, STRETCH_WIDTH_SUMMARY).contains(name)) {
            return () -> this.showText;
        }
        if (STRETCH_WIDTH_PIECES.equals(name)) {
            return () -> this.showText && this.drawPieces;
        }
        if (BORDER_INNER_THICKNESS.equals(name)) {
            return () -> this.showText && this.drawPieces && this.stretchWidthSummary && this.stretchWidthPieces;
        }
        if (List.of(COMBINE_COUNTER_SUMMARY, ONLY_SHOW_FIRST_SUMMARY).contains(name)) {
            return () -> this.showText && this.stretchWidthSummary;
        }
        if (List.of(DRAW_PIECES, SHOW_TEXT, SHOW_NOSTACK, SHOW_DECK, DISPLAY, DESCRIPTION, CENTER_ALL).contains(name)) {
            return () -> true;
        }
        if (List.of(SHOW_DECK_DEPTH, SHOW_DECK_MASKED).contains(name)) {
            return () -> this.showText || this.drawPieces;
        }
        if (LAYER_LIST.equals(name)) {
            return () -> this.displayWhat.equals(INC_LAYERS) || this.displayWhat.equals(EXC_LAYERS);
        }
        if (PROPERTY_FILTER.equals(name)) {
            return () -> true;
        }
        if (EMPTY_HEX_REPORT_FORMAT.equals(name)) {
            return () -> this.showText && this.minimumDisplayablePieces == 0;
        }
        if (List.of(SHOW_TERRAIN_WIDTH, SHOW_TERRAIN_HEIGHT, SHOW_TERRAIN_ZOOM, SHOW_TERRAIN_SNAPPY).contains(name)) {
            return () -> !NEVER.equals(this.showTerrainBeneath);
        }
        if (SHOW_TERRAIN_TEXT.equals(name)) {
            return () -> this.showText && !NEVER.equals(this.showTerrainBeneath);
        }
        if (List.of(VERSION, SHOW_TEXT_SINGLE_DEPRECATED, GRAPH_SINGLE_DEPRECATED).contains(name)) {
            return () -> false;
        }
        return null;
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.propertyFilter.getExpression());
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.summaryReportFormat.getFormat(), this.counterReportFormat.getFormat(), this.emptyHexReportFormat.getFormat(), this.showTerrainText.getFormat());
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(HOTKEY)));
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.summaryReportFormat.getFormat());
        h.addImageNames(s);
        h = new HTMLImageFinder(this.counterReportFormat.getFormat());
        h.addImageNames(s);
        h = new HTMLImageFinder(this.emptyHexReportFormat.getFormat());
        h.addImageNames(s);
        h = new HTMLImageFinder(this.showTerrainText.getFormat());
        h.addImageNames(s);
    }

    protected static class Visitor
    extends PieceFinder.Movable {
        protected List<GamePiece> pieces;
        protected Filter filter;
        protected CompoundPieceCollection collection;
        protected int lastLayer = -1;
        protected int insertPos = 0;
        protected Point foundPieceAt;
        protected boolean showingOverlap;
        protected final int showNumberFromDeck;
        protected final boolean showDeckMasked;
        protected final boolean showOnlyTopOfStack;

        @Deprecated(since="2021-12-01", forRemoval=true)
        public Visitor(Filter filter, Map map, Point pt, boolean showOverlap) {
            this(filter, map, pt, showOverlap, 1, false);
        }

        public Visitor(Filter filter, Map map, Point pt, boolean showOverlap, int showNumberFromDeck, boolean showDeckMasked) {
            this(filter, map, pt, showOverlap, showNumberFromDeck, showDeckMasked, false);
        }

        public Visitor(Filter filter, Map map, Point pt, boolean showOverlap, int showNumberFromDeck, boolean showDeckMasked, boolean showOnlyTopOfStack) {
            super(map, pt);
            if (map.getPieceCollection() instanceof CompoundPieceCollection) {
                this.collection = (CompoundPieceCollection)map.getPieceCollection();
            }
            this.pieces = new ArrayList<GamePiece>();
            this.filter = filter;
            this.showingOverlap = showOverlap;
            this.showNumberFromDeck = showNumberFromDeck;
            this.showDeckMasked = showDeckMasked;
            this.showOnlyTopOfStack = showOnlyTopOfStack;
        }

        @Override
        public Object visitDeck(Deck d) {
            if (this.foundPieceAt == null) {
                GamePiece p = d.topPiece();
                int shownPieces = 0;
                while (p != null && shownPieces < this.showNumberFromDeck) {
                    if (this.showDeckMasked || !Boolean.TRUE.equals(p.getProperty("Obscured")) && !d.isFaceDown()) {
                        Rectangle r = (Rectangle)d.getShape();
                        r.x += d.getPosition().x;
                        r.y += d.getPosition().y;
                        if (r.contains(this.pt)) {
                            this.apply(p);
                            ++shownPieces;
                        }
                    }
                    p = d.getPieceBeneath(p);
                }
            }
            return null;
        }

        @Override
        public Object visitStack(Stack s) {
            boolean addContents;
            boolean bl = this.foundPieceAt == null ? super.visitStack(s) != null : (addContents = this.foundPieceAt.equals(s.getPosition()));
            if (addContents) {
                if (!(this.map instanceof PlayerHand)) {
                    if (this.showOnlyTopOfStack && !s.isEmpty()) {
                        this.apply(s.topPiece());
                    } else {
                        s.asList().forEach(this::apply);
                    }
                } else {
                    for (int i = 0; i < this.shapes.length && i < s.getPieceCount(); ++i) {
                        if (!this.shapes[i].contains(this.pt)) continue;
                        this.apply(s.getPieceAt(i));
                        break;
                    }
                }
            }
            return null;
        }

        @Override
        public Object visitDefault(GamePiece p) {
            if (this.foundPieceAt == null ? super.visitDefault(p) != null : this.foundPieceAt.equals(p.getPosition())) {
                this.apply(p);
            }
            return null;
        }

        protected void apply(GamePiece p) {
            int layer = this.collection.getLayerForPiece(p);
            String layerName = this.collection.getLayerNameForPiece(p);
            if (this.filter == null || this.filter.accept(p, layer, layerName)) {
                if (layer != this.lastLayer) {
                    this.insertPos = 0;
                    this.lastLayer = layer;
                }
                if (!this.showingOverlap && this.foundPieceAt == null) {
                    this.foundPieceAt = p.getPosition();
                }
                this.pieces.add(this.insertPos++, p);
            }
        }

        public List<GamePiece> getPieces() {
            return this.pieces;
        }
    }

    protected class Filter
    implements PieceFilter {
        protected int topLayer = -1;

        public boolean checkFilter(GamePiece piece) {
            String s = CounterDetailViewer.this.propertyFilter.getExpression().trim();
            return s.isEmpty() || CounterDetailViewer.this.propertyFilter.accept(piece);
        }

        @Override
        public boolean accept(GamePiece piece) {
            return this.accept(piece, 0, "");
        }

        public boolean accept(GamePiece piece, int layer, String layerName) {
            if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                return false;
            }
            if (Boolean.TRUE.equals(piece.getProperty("NoStack")) && !CounterDetailViewer.this.showNoStack) {
                return false;
            }
            if (Boolean.TRUE.equals(piece.getProperty("cannotMove")) ? !CounterDetailViewer.this.showNonMovable : Boolean.TRUE.equals(piece.getProperty("Immobile")) && !CounterDetailViewer.this.showMoveSelected) {
                return false;
            }
            if (piece.getParent() instanceof Deck && !CounterDetailViewer.this.showDeck) {
                return false;
            }
            if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.ALL_LAYERS)) {
                return this.checkFilter(piece);
            }
            if (this.topLayer < 0) {
                this.topLayer = layer;
            }
            if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.TOP_LAYER)) {
                return layer == this.topLayer && this.checkFilter(piece);
            }
            if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.INC_LAYERS)) {
                for (String displayLayer : CounterDetailViewer.this.displayLayers) {
                    if (!layerName.equals(displayLayer)) continue;
                    return this.checkFilter(piece);
                }
            } else if (CounterDetailViewer.this.displayWhat.equals(CounterDetailViewer.EXC_LAYERS)) {
                for (String displayLayer : CounterDetailViewer.this.displayLayers) {
                    if (!layerName.equals(displayLayer)) continue;
                    return false;
                }
                return this.checkFilter(piece);
            }
            return false;
        }
    }

    public static class MinConfig
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{"0", "1", "2"};
        }
    }

    public static class ReportFormatConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedExpressionConfigurer(key, name, new String[]{"LocationName", "CurrentMap", "CurrentBoard", "CurrentZone", CounterDetailViewer.SUM});
        }
    }

    public static class CounterFormatConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            FormattedExpressionConfigurer configurer = new FormattedExpressionConfigurer(key, name, new String[]{"PieceName"});
            configurer.setContextLevel(Configurer.ContextLevel.PIECE);
            return configurer;
        }
    }

    public static class EmptyFormatConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedExpressionConfigurer(key, name, new String[]{"LocationName", "CurrentMap", "CurrentBoard", "CurrentZone"});
        }
    }

    public static class DisplayConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{CounterDetailViewer.TOP_LAYER, CounterDetailViewer.ALL_LAYERS, CounterDetailViewer.INC_LAYERS, CounterDetailViewer.EXC_LAYERS};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.CounterDetailViewer.top_layer", "Editor.CounterDetailViewer.all_layers", "Editor.CounterDetailViewer.inc_layers", "Editor.CounterDetailViewer.exc_layers"};
        }
    }

    public static class TerrainConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{CounterDetailViewer.NEVER, CounterDetailViewer.IF_ONE, CounterDetailViewer.ALWAYS};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.CounterDetailViewer.never", "Editor.CounterDetailViewer.if_one", "Editor.CounterDetailViewer.always"};
        }
    }
}

