/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZonedGridHighlighter;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Element;

public class ZonedGrid
extends AbstractConfigurable
implements GeometricGrid,
GridContainer {
    protected List<Zone> zones = new ArrayList<Zone>();
    protected MapGrid background;
    protected GridContainer container;
    protected ZonedGridHighlighter zoneHighlighters;
    protected final java.util.Map<Pair<Point, Double>, Area> clipCache = new ConcurrentHashMap<Pair<Point, Double>, Area>();

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String key) {
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
        this.container = (GridContainer)((Object)parent);
        this.container.setGrid(this);
    }

    public GridContainer getContainer() {
        return this.container;
    }

    @Override
    public Dimension getSize() {
        return this.container.getSize();
    }

    @Override
    public boolean contains(Point p) {
        return this.container.contains(p);
    }

    @Override
    public void removeGrid(MapGrid grid) {
        if (this.background == grid) {
            this.background = null;
        }
    }

    @Override
    public Board getBoard() {
        return this.container != null ? this.container.getBoard() : null;
    }

    public Map getMap() {
        return this.getBoard() == null ? null : this.getBoard().getMap();
    }

    @Override
    public void setGrid(MapGrid grid) {
        this.background = grid;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.background == null) {
            Class[] classArray2 = new Class[4];
            classArray2[0] = Zone.class;
            classArray2[1] = HexGrid.class;
            classArray2[2] = SquareGrid.class;
            classArray = classArray2;
            classArray2[3] = RegionGrid.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = Zone.class;
        }
        return classArray;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.MultiZoneGrid.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ZonedGrid.html");
    }

    @Override
    public void removeFrom(Buildable parent) {
        ((GridContainer)((Object)parent)).removeGrid(this);
    }

    protected Area makeUnscaledUntranslatedClipArea() {
        Area a = new Area();
        for (Zone zone : this.zones) {
            if (zone.isUseParentGrid()) continue;
            a.add(new Area(zone.getShape()));
        }
        return a.isEmpty() ? null : a;
    }

    protected Area makeClipArea(Pair<Point, Double> k) {
        Area a = this.makeUnscaledUntranslatedClipArea();
        if (a != null) {
            Point p = (Point)k.getLeft();
            double s = (Double)k.getRight();
            AffineTransform t = AffineTransform.getScaleInstance(s, s);
            t.translate(p.x, p.y);
            a.transform(t);
        }
        return a;
    }

    @Override
    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        if (this.background != null && this.background.isVisible()) {
            Area translatedZones;
            Graphics2D g2d = (Graphics2D)g;
            Shape oldClip = g2d.getClip();
            if (oldClip != null && (translatedZones = this.clipCache.computeIfAbsent((Pair<Point, Double>)Pair.of((Object)bounds.getLocation(), (Object)scale), this::makeClipArea)) != null) {
                Area clipArea = new Area(oldClip);
                clipArea.subtract(translatedZones);
                g2d.setClip(clipArea);
            }
            this.background.draw(g, bounds, visibleRect, scale, reversed);
            g2d.setClip(oldClip);
        }
        for (Zone zone : this.zones) {
            zone.draw(g, bounds, visibleRect, scale, reversed);
        }
    }

    @Override
    public GridNumbering getGridNumbering() {
        return this.background != null ? this.background.getGridNumbering() : null;
    }

    @Override
    public Point getLocation(String location) throws MapGrid.BadCoords {
        for (Zone zone : this.zones) {
            try {
                Point p = zone.getLocation(location);
                if (p == null || !zone.contains(p)) continue;
                return p;
            }
            catch (MapGrid.BadCoords badCoords) {
            }
        }
        if (this.background != null) {
            return this.background.getLocation(location);
        }
        throw new MapGrid.BadCoords();
    }

    public Point getRegionLocation(String location) {
        for (Zone zone : this.zones) {
            Point p = zone.getRegionLocation(location);
            if (p == null || !zone.contains(p)) continue;
            return p;
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String locationName(Point p) {
        String name = null;
        for (Zone zone : this.zones) {
            if (!zone.contains(p)) continue;
            name = zone.locationName(p);
            break;
        }
        if (name == null && this.background != null) {
            name = this.background.locationName(p);
        }
        return name;
    }

    @Override
    public String localizedLocationName(Point p) {
        String name = null;
        for (Zone zone : this.zones) {
            if (!zone.contains(p)) continue;
            name = zone.localizedLocationName(p);
            break;
        }
        if (name == null && this.background != null) {
            name = this.background.localizedLocationName(p);
        }
        return name;
    }

    @Override
    public int range(Point p1, Point p2) {
        Zone z2;
        MapGrid grid = this.background;
        Zone z1 = this.findZone(p1);
        if (z1 == (z2 = this.findZone(p2)) && z1 != null && z1.getGrid() != null) {
            grid = z1.getGrid();
        }
        return grid != null ? grid.range(p1, p2) : (int)Math.round(p1.distance(p2));
    }

    @Override
    public int getMaxPixelsPerRangeUnit(Point p) {
        MapGrid grid = this.background;
        Zone z = this.findZone(p);
        if (z != null && z.getGrid() != null) {
            grid = z.getGrid();
        }
        return grid != null ? grid.getMaxPixelsPerRangeUnit(p) : GeometricGrid.super.getMaxPixelsPerRangeUnit(p);
    }

    @Override
    public Area getGridShape(Point center, int range) {
        Area a = null;
        Zone z = this.findZone(center);
        if (z != null && z.getGrid() instanceof GeometricGrid) {
            a = ((GeometricGrid)z.getGrid()).getGridShape(center, range);
        }
        if (a == null && this.background instanceof GeometricGrid) {
            a = ((GeometricGrid)this.background).getGridShape(center, range);
        }
        if (a == null) {
            a = new Area(new Ellipse2D.Double(center.x - range, center.y - range, range * 2, range * 2));
        }
        return a;
    }

    public Zone findZone(Point p) {
        for (Zone zone : this.zones) {
            if (!zone.contains(p)) continue;
            return zone;
        }
        return null;
    }

    public Zone findZone(String name) {
        for (Zone zone : this.zones) {
            if (!zone.getName().equals(name)) continue;
            return zone;
        }
        return null;
    }

    @Override
    public Point snapTo(Point p, boolean force, boolean centerOnly) {
        Point snap = null;
        Zone z = this.findZone(p);
        if (z != null) {
            snap = z.snapTo(p, force, centerOnly);
        }
        if (snap == null) {
            snap = this.background != null ? this.background.snapTo(p, force, centerOnly) : p;
        }
        return snap;
    }

    @Override
    public Point snapTo(Point p, boolean force) {
        return this.snapTo(p, force, false);
    }

    @Override
    public Point snapTo(Point p) {
        return this.snapTo(p, false, false);
    }

    @Override
    public boolean isLocationRestricted(Point p) {
        for (Zone zone : this.zones) {
            if (!zone.contains(p)) continue;
            return zone.getGrid() != null && zone.getGrid().isLocationRestricted(p);
        }
        return this.background != null && this.background.isLocationRestricted(p);
    }

    public void addZone(Zone z) {
        this.zones.add(z);
    }

    public void removeZone(Zone z) {
        this.zones.remove(z);
    }

    public Iterator<Zone> getZones() {
        return this.zones.iterator();
    }

    public List<Zone> getZonesList() {
        return new ArrayList<Zone>(this.zones);
    }

    public MapGrid getBackgroundGrid() {
        return this.background;
    }

    public void setBackgroundGrid(MapGrid background) {
        this.background = background;
    }

    @Override
    public void build(Element e) {
        super.build(e);
        if (this.getComponentsOf(ZonedGridHighlighter.class).isEmpty()) {
            this.addChild(new ZonedGridHighlighter());
        }
    }

    private void addChild(Buildable b) {
        this.add(b);
        b.addTo(this);
    }

    public void setZoneHighlighter(ZonedGridHighlighter zh) {
        this.zoneHighlighters = zh;
    }

    public ZoneHighlight getZoneHighlight(String name) {
        if (this.zoneHighlighters != null) {
            return this.zoneHighlighters.getZoneHighlightByName(name);
        }
        return null;
    }
}

