/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.turn.TurnLevel;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import org.apache.commons.lang3.ArrayUtils;

public class CounterTurnLevel
extends TurnLevel {
    protected static final String START = "start";
    protected static final String INCR = "incr";
    protected static final String LOOP = "loop";
    protected static final String LOOP_LIMIT = "loopLimit";
    protected int incr = 1;
    protected boolean loop = false;
    protected int loopLimit = -1;
    private final VisibilityCondition loopCond = () -> this.loop;

    @Override
    protected void reset() {
        super.reset();
        this.setLow();
    }

    @Override
    protected void setLow() {
        this.current = this.start;
        this.rolledOver = false;
        super.setLow();
    }

    @Override
    protected void setHigh() {
        this.current = this.loopLimit;
        this.rolledOver = false;
        super.setHigh();
    }

    @Override
    protected String getState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.current);
        se.append(this.currentSubLevel);
        se.append(this.loop);
        se.append(this.loopLimit);
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            se.append(this.getTurnLevel(i).getState());
        }
        return se.getValue();
    }

    @Override
    protected void setState(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, ';');
        this.current = sd.nextInt(this.start);
        this.currentSubLevel = sd.nextInt(0);
        this.loop = sd.nextBoolean(false);
        this.loopLimit = sd.nextInt(-1);
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).setState(sd.nextToken(""));
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected String getValueString() {
        return String.valueOf(this.current);
    }

    @Override
    protected String getLongestValueName() {
        return this.start < 10000 ? "9999" : String.valueOf(this.start);
    }

    @Override
    protected void advance() {
        super.advance();
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            this.current += this.incr;
            if (this.loop && this.current > this.loopLimit) {
                this.current = this.start;
                this.setRolledOver(true);
            }
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected void retreat() {
        super.retreat();
        int oldCurrent = this.current;
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            this.current -= this.incr;
            if (this.loop && oldCurrent <= this.start) {
                this.current = this.loopLimit;
                this.setRolledOver(true);
            }
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected Component getSetControl() {
        IntConfigurer config = new IntConfigurer("", " " + this.getConfigureName() + ":  ", (Integer)this.current);
        config.addPropertyChangeListener(e -> {
            this.current = (Integer)((IntConfigurer)e.getSource()).getValue();
            this.myValue.setPropertyValue(this.getValueString());
        });
        return config.getControls();
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.CounterTurnLevel.start_value"), Resources.getString("Editor.CounterTurnLevel.increment_by"), Resources.getString("Editor.CounterTurnLevel.loop"), Resources.getString("Editor.CounterTurnLevel.maximum_value")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{Integer.class, Integer.class, Boolean.class, Integer.class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{START, INCR, LOOP, LOOP_LIMIT});
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (START.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.current = this.start = ((Integer)value).intValue();
            this.myValue.setPropertyValue(this.getValueString());
        } else if (INCR.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.incr = (Integer)value;
        } else if (LOOP.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.loop = (Boolean)value;
        } else if (LOOP_LIMIT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.loopLimit = (Integer)value;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (START.equals(key)) {
            return Integer.toString(this.start);
        }
        if (INCR.equals(key)) {
            return Integer.toString(this.incr);
        }
        if (LOOP.equals(key)) {
            return Boolean.toString(this.loop);
        }
        if (LOOP_LIMIT.equals(key)) {
            return Integer.toString(this.loopLimit);
        }
        return super.getAttributeValueString(key);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.CounterTurnLevel.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.html", "Counter");
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (LOOP_LIMIT.equals(name)) {
            return this.loopCond;
        }
        return null;
    }
}

