/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class FormattedStringConfigurer
extends StringConfigurer
implements ActionListener,
FocusListener {
    private final DefaultComboBoxModel<String> optionsModel = new DefaultComboBoxModel();
    private JComboBox<String> dropList;

    public FormattedStringConfigurer(String key, String name) {
        this(key, name, new String[0]);
    }

    public FormattedStringConfigurer(String[] options) {
        this((String)null, "", options);
    }

    public FormattedStringConfigurer(String key, String name, String[] options) {
        super(key, name);
        this.setOptions(options);
    }

    public void setOptions(String[] options) {
        this.optionsModel.removeAllElements();
        this.optionsModel.addElement(Resources.getString("Editor.FormattedStringConfigurer.insert"));
        for (String option : options) {
            this.optionsModel.addElement(option);
        }
        this.setListVisibility();
    }

    public String[] getOptions() {
        String[] s = new String[this.optionsModel.getSize()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.optionsModel.getElementAt(i);
        }
        return s;
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            super.getControls();
            this.nameField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent event) {
                    if (FormattedStringConfigurer.this.dropList != null) {
                        FormattedStringConfigurer.this.dropList.setSelectedIndex(0);
                        FormattedStringConfigurer.this.dropList.setEnabled(true);
                    }
                }

                @Override
                public void focusLost(FocusEvent event) {
                    if (FormattedStringConfigurer.this.dropList != null) {
                        FormattedStringConfigurer.this.dropList.setPopupVisible(false);
                        FormattedStringConfigurer.this.dropList.setEnabled(false);
                    }
                }
            });
            this.nameField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    int code = e.getKeyCode();
                    if (code == 155 && FormattedStringConfigurer.this.dropList != null) {
                        FormattedStringConfigurer.this.dropList.setPopupVisible(true);
                    }
                }
            });
            this.dropList = new JComboBox<String>(this.optionsModel);
            this.dropList.setFocusable(false);
            this.dropList.setSelectedIndex(0);
            this.dropList.setEnabled(false);
            this.dropList.addActionListener(this);
            this.setListVisibility();
            this.p.add(this.dropList, "grow 0,right");
        }
        return this.p;
    }

    private void setListVisibility() {
        if (this.dropList != null) {
            this.dropList.setVisible(this.optionsModel.getSize() > 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedIndex = this.dropList.getSelectedIndex();
        if (selectedIndex > 0) {
            String item = "$" + this.optionsModel.getElementAt(selectedIndex) + "$";
            int start = this.nameField.getSelectionStart();
            int end = this.nameField.getSelectionEnd();
            String text = this.nameField.getText();
            this.nameField.setText(text.substring(0, start) + item + text.substring(end));
            this.nameField.setCaretPosition(start + item.length());
        }
        this.dropList.setSelectedIndex(0);
        this.nameField.requestFocusInWindow();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }
}

