/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.KeyNamer;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ComponentDescription;
import VASSAL.configure.NoInsetButton;
import VASSAL.configure.ShowHelpAction;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.launch.EditorWindow;
import VASSAL.search.SearchTarget;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.lang.Pair;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ListKeyCommandsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int KEY_COMMAND_COLUMN = 0;
    private static final int COLUMN_COUNT = 6;
    private static final int NAMED_COMMAND_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private static final int NAME_COLUMN = 3;
    private static final int PATH_COLUMN = 4;
    private static final int DESC_COLUMN = 5;
    private final EditorWindow owner;
    private final MyTableModel tmod;

    public ListKeyCommandsDialog(final EditorWindow owner, List<Pair<String[], AbstractConfigurable>> rows) {
        super((Frame)null, Resources.getString("Editor.ListKeyCommands.list_key_commands"), true);
        this.owner = owner;
        final JTextField filter = new JTextField(25);
        filter.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ ListKeyCommandsDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        filter.selectAll();
                    }
                });
            }
        });
        this.tmod = new MyTableModel(rows);
        final JTable table = new JTable(this.tmod){

            @Override
            public String getToolTipText(MouseEvent e) {
                int colIndex;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                Object obj = this.getValueAt(rowIndex, colIndex = this.columnAtPoint(p));
                return obj != null ? obj.toString() : null;
            }
        };
        this.setPreferredSize(new Dimension(1900, 800));
        table.getColumnModel().getColumn(0).setPreferredWidth(114);
        table.getColumnModel().getColumn(1).setPreferredWidth(140);
        table.getColumnModel().getColumn(2).setPreferredWidth(200);
        table.getColumnModel().getColumn(3).setPreferredWidth(200);
        table.getColumnModel().getColumn(4).setPreferredWidth(400);
        table.getColumnModel().getColumn(5).setPreferredWidth(800);
        final JPopupMenu pm = new JPopupMenu();
        pm.add(new CopyAction(table));
        pm.add(new JumpAction(table));
        table.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ListKeyCommandsDialog this$0;
            {
                this.this$0 = this$0;
            }

            private void doMouseStuff(MouseEvent e) {
                int rowindex;
                int r = table.rowAtPoint(e.getPoint());
                if (r >= 0 && r < table.getRowCount()) {
                    if (!table.getSelectionModel().isSelectedIndex(r)) {
                        table.setRowSelectionInterval(r, r);
                    }
                } else {
                    table.clearSelection();
                }
                if ((rowindex = table.getSelectedRow()) < 0) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    this.doPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.doMouseStuff(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.doMouseStuff(e);
            }

            protected void doPopup(MouseEvent e) {
                pm.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        final TableRowSorter<MyTableModel> trs = new TableRowSorter<MyTableModel>(this.tmod);
        table.setRowSorter(trs);
        trs.setSortsOnUpdates(true);
        trs.setRowFilter(new RowFilter<TableModel, Integer>(this){
            final /* synthetic */ ListKeyCommandsDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                String f = filter.getText();
                if (f == null) {
                    return true;
                }
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    String v;
                    if (i == 4 || (v = entry.getStringValue(i)) == null || !v.toLowerCase().contains(f.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[]rel[]unrel[]"));
        panel.setPreferredSize(new Dimension(1400, 700));
        panel.add((Component)filter, "split");
        filter.getDocument().addDocumentListener(new DocumentListener(){
            final /* synthetic */ ListKeyCommandsDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                trs.allRowsChanged();
            }
        });
        NoInsetButton clear = new NoInsetButton("no", 0, "Editor.clear");
        clear.addActionListener(e -> filter.setText(null));
        panel.add((Component)clear, "wrap");
        JScrollPane scroll = new JScrollPane(table);
        panel.add((Component)scroll, "grow, push, wrap");
        JButton ok = new JButton(Resources.getString("General.ok"));
        ok.addActionListener(e -> {
            this.dispose();
            owner.clearListKeyCommands();
        });
        JButton help = new JButton(Resources.getString("General.help"));
        help.addActionListener(e -> this.help());
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]push", ""));
        buttonPanel.add((Component)ok, "tag ok, sg 1");
        buttonPanel.add((Component)help, "tag help, sg 1");
        panel.add((Component)buttonPanel, "growx");
        this.setLayout((LayoutManager)new MigLayout("insets dialog, fill"));
        this.add((Component)panel, "grow");
        this.setModal(false);
        SwingUtils.repack(this);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ListKeyCommandsDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.dispose();
                owner.clearListKeyCommands();
            }
        });
    }

    public void updateConfigurable(AbstractConfigurable target) {
        this.tmod.updateConfigurable(target);
    }

    public void deleteConfigurable(AbstractConfigurable target) {
        this.tmod.deleteConfigurable(target);
    }

    private static void checkSearchTarget(SearchTarget target, List<Pair<String[], AbstractConfigurable>> list, AbstractConfigurable configurable) {
        List<NamedKeyStroke> keys = target.getNamedKeyStrokeList();
        if (keys != null) {
            for (NamedKeyStroke k : keys) {
                if (k == null) continue;
                String cmd_key = null;
                String cmd_name = null;
                if (k.isNamed()) {
                    cmd_name = k.getName();
                } else {
                    cmd_key = KeyNamer.getKeyString(k.getStroke());
                }
                if (StringUtils.isEmpty((CharSequence)cmd_key) && StringUtils.isEmpty((CharSequence)cmd_name)) continue;
                Object src_name = null;
                String src_desc = null;
                String src_type = null;
                if (target instanceof AbstractConfigurable) {
                    src_name = ((AbstractConfigurable)target).getConfigureName();
                    if (target instanceof ComponentDescription) {
                        src_desc = ((ComponentDescription)((Object)target)).getDescription();
                    }
                    src_type = ((AbstractConfigurable)target).getTypeName();
                } else if (target instanceof GamePiece) {
                    src_name = configurable instanceof PrototypeDefinition ? Resources.getString("Editor.ListKeyCommands.prototype") + ": " + configurable.getConfigureName() : ((GamePiece)((Object)target)).getName();
                    if (target instanceof Decorator) {
                        src_desc = ((Decorator)target).getDescriptionField();
                        src_type = ((Decorator)target).getBaseDescription();
                    }
                }
                Object src_path = "";
                Buildable path = configurable.getAncestor();
                while (path instanceof AbstractBuildable && !(path instanceof GameModule)) {
                    if (path instanceof AbstractConfigurable) {
                        Object node = ((AbstractConfigurable)path).getConfigureName();
                        if (node == null || ((String)node).isBlank()) {
                            node = "[" + ((AbstractConfigurable)path).getTypeName() + "]";
                        }
                        if (!((String)src_path).isEmpty()) {
                            src_path = (String)src_path + " > ";
                        }
                        src_path = (String)src_path + (String)node;
                    }
                    path = ((AbstractBuildable)path).getAncestor();
                }
                list.add(Pair.of(new String[]{cmd_key, cmd_name, src_type, src_name, src_path, src_desc}, configurable));
            }
        }
    }

    private static void checkForKeyCommands(AbstractConfigurable target, List<Pair<String[], AbstractConfigurable>> list) {
        boolean protoskip;
        GamePiece p;
        if (target instanceof GamePiece) {
            p = (GamePiece)((Object)target);
            protoskip = false;
        } else if (target instanceof PieceSlot) {
            p = ((PieceSlot)target).getPiece();
            protoskip = false;
        } else if (target instanceof PrototypeDefinition) {
            p = ((PrototypeDefinition)target).getPiece();
            protoskip = true;
        } else {
            ListKeyCommandsDialog.checkSearchTarget(target, list, target);
            return;
        }
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
        pieces.add(p);
        while (p instanceof Decorator) {
            p = ((Decorator)p).getInner();
            pieces.add(p);
        }
        Collections.reverse(pieces);
        for (GamePiece piece : pieces) {
            if (!protoskip && piece instanceof SearchTarget) {
                ListKeyCommandsDialog.checkSearchTarget((SearchTarget)((Object)piece), list, target);
            }
            protoskip = false;
        }
    }

    private static void recursivelyFindKeyCommands(AbstractBuildable target, List<Pair<String[], AbstractConfigurable>> list) {
        for (Buildable b : target.getBuildables()) {
            if (b instanceof AbstractConfigurable) {
                ListKeyCommandsDialog.checkForKeyCommands((AbstractConfigurable)b, list);
            }
            if (!(b instanceof AbstractBuildable)) continue;
            ListKeyCommandsDialog.recursivelyFindKeyCommands((AbstractBuildable)b, list);
        }
    }

    public static List<Pair<String[], AbstractConfigurable>> findAllKeyCommands() {
        ArrayList<Pair<String[], AbstractConfigurable>> keyCommandList = new ArrayList<Pair<String[], AbstractConfigurable>>();
        ListKeyCommandsDialog.recursivelyFindKeyCommands(GameModule.getGameModule(), keyCommandList);
        return keyCommandList;
    }

    private void help() {
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "ListKeyCommands.html"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        if (hf != null) {
            new ShowHelpAction(hf.getContents(), null).actionPerformed(null);
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final List<Pair<String[], AbstractConfigurable>> rows;

        public MyTableModel(List<Pair<String[], AbstractConfigurable>> rows) {
            this.rows = rows;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        public AbstractConfigurable getSourceFor(int row) {
            return (AbstractConfigurable)this.rows.get((int)row).second;
        }

        public void deleteConfigurable(AbstractConfigurable target) {
            int lowest = -1;
            int highest = -1;
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                if (!((AbstractConfigurable)this.rows.get((int)i).second).equals(target)) continue;
                this.rows.remove(i);
                lowest = i;
                if (highest >= 0) continue;
                highest = i;
            }
            if (highest >= 0) {
                this.fireTableRowsDeleted(lowest, highest);
            }
        }

        public void updateConfigurable(AbstractConfigurable target) {
            this.deleteConfigurable(target);
            int size = this.rows.size();
            ListKeyCommandsDialog.checkForKeyCommands(target, this.rows);
            if (this.rows.size() > size) {
                this.fireTableRowsInserted(size, this.rows.size() - 1);
            }
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Resources.getString("Editor.ListKeyCommands.key_command");
                }
                case 1: {
                    return Resources.getString("Editor.ListKeyCommands.named_command");
                }
                case 2: {
                    return Resources.getString("Editor.ListKeyCommands.source_type");
                }
                case 3: {
                    return Resources.getString("Editor.ListKeyCommands.source_name");
                }
                case 4: {
                    return Resources.getString("Editor.ListKeyCommands.source_path");
                }
                case 5: {
                    return Resources.getString("Editor.ListKeyCommands.source_description");
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            return row < this.rows.size() ? ((String[])this.rows.get((int)row).first)[column] : null;
        }
    }

    public static class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final JTable table;

        public CopyAction(JTable table) {
            this.table = table;
            this.putValue("Name", Resources.getString("General.copy"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.table.getActionMap().get("copy").actionPerformed(new ActionEvent(this.table, e.getID(), ""));
        }
    }

    public class JumpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final JTable table;

        public JumpAction(JTable table) {
            this.table = table;
            this.putValue("Name", Resources.getString("Editor.ListKeyCommands.jump_to_definition"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowIndex = this.table.getSelectedRow();
            if (rowIndex < 0) {
                return;
            }
            rowIndex = this.table.convertRowIndexToModel(rowIndex);
            AbstractConfigurable jumpTo = ((MyTableModel)this.table.getModel()).getSourceFor(rowIndex);
            ListKeyCommandsDialog.this.owner.getTree().jumpToTarget(jumpTo);
            ListKeyCommandsDialog.this.owner.toFront();
        }
    }
}

