/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import java.awt.Point;

public class RangeFilter
implements PieceFilter {
    private final Map map;
    private final Point position;
    private final MapGrid grid;
    private final int range;

    public RangeFilter(Map map, Point location, int range) {
        this.position = location;
        this.map = map;
        this.range = range;
        Board b = map.findBoard(location);
        this.grid = b != null ? b.getGrid() : null;
    }

    @Override
    public boolean accept(GamePiece piece) {
        boolean accept = false;
        if (piece.getMap() == this.map) {
            Point pos = piece.getPosition();
            int theRange = this.grid != null ? this.grid.range(this.position, pos) : (int)Math.round(this.position.distance(pos));
            accept = theRange <= this.range;
        }
        return accept;
    }
}

