/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

public class Replace
extends PlaceMarker {
    public static final String ID = "replace;";

    public Replace() {
        this(ID + Resources.getString("Editor.Replace.default_command") + ";R;null", null);
    }

    public Replace(String type, GamePiece inner) {
        super(type, inner);
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        if (this.command.matches(stroke)) {
            c = this.replacePiece();
        }
        return c;
    }

    protected Command replacePiece() {
        Command c = this.placeMarker(true);
        if (c == null) {
            Replace.reportDataError(this, Resources.getString("Error.bad_replace"));
        } else {
            if (GameModule.getGameModule().isMatSupport()) {
                Mat mat;
                String matName;
                MatCargo cargo;
                GamePiece outer = Replace.getOutermost(this);
                if (Boolean.TRUE.equals(outer.getProperty("IsCargo")) && (cargo = (MatCargo)Replace.getDecorator(outer, MatCargo.class)) != null) {
                    c = c.append(cargo.makeClearMatCommand());
                }
                if ((matName = (String)outer.getProperty("MatName")) != null && !"".equals(matName) && (mat = (Mat)Replace.getDecorator(outer, Mat.class)) != null) {
                    c = c.append(mat.makeRemoveAllCargoCommand());
                }
            }
            Command remove = GameModule.getGameModule().getGameState().getAttachmentManager().removeAttachments(this);
            remove = remove.append(new RemovePiece(Replace.getOutermost(this)));
            remove.execute();
            c.append(remove);
        }
        return c;
    }

    @Override
    protected void selectMarker(GamePiece marker) {
        KeyBuffer.getBuffer().add(marker);
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.Replace.trait_description", this.description);
        s = (String)s + this.getCommandDesc(this.command.getName(), this.key);
        this.updateDescString();
        if (this.descString != null && !this.descString.isEmpty()) {
            s = (String)s + " - " + this.descString;
        }
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Replace.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Replace.html");
    }

    @Override
    public String myGetType() {
        return ID + super.myGetType().substring("placemark;".length());
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public GamePiece createMarker() {
        GamePiece marker = super.createMarker();
        if (marker != null && this.matchRotation) {
            if (this.above) {
                this.matchTraits(this, marker);
            } else {
                this.matchTraits(Replace.getOutermost(this), marker);
            }
        }
        return marker;
    }

    protected void matchTraits(GamePiece base, GamePiece marker) {
        if (!(base instanceof Decorator) || !(marker instanceof Decorator)) {
            return;
        }
        Decorator currentMarker = (Decorator)marker;
        while (currentMarker != null) {
            if (!(currentMarker instanceof Marker)) {
                Decorator candidate = (Decorator)base;
                while (candidate != null) {
                    if ((candidate = (Decorator)Replace.getDecorator(candidate, currentMarker.getClass())) == null) continue;
                    if (candidate instanceof DynamicProperty && this.copyDPsByName) {
                        if (((DynamicProperty)candidate).getKey().equals(((DynamicProperty)currentMarker).getKey())) {
                            currentMarker.mySetState(candidate.myGetState());
                            candidate = null;
                        }
                    } else if (currentMarker instanceof Labeler && candidate.myGetType().equals(currentMarker.myGetType())) {
                        if (((Labeler)currentMarker).canChange()) {
                            currentMarker.mySetState(candidate.myGetState());
                            candidate = null;
                        }
                    } else if (candidate.myGetType().equals(currentMarker.myGetType())) {
                        currentMarker.mySetState(candidate.myGetState());
                        candidate = null;
                    }
                    if (candidate != null && candidate.getInner() instanceof Decorator) {
                        candidate = (Decorator)candidate.getInner();
                        continue;
                    }
                    candidate = null;
                }
            }
            if (currentMarker.getInner() instanceof Decorator) {
                currentMarker = (Decorator)currentMarker.getInner();
                continue;
            }
            currentMarker = null;
        }
    }

    @Override
    public List<String> getPropertyNames() {
        return new ArrayList<String>();
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command.getName(), this.getCommandDescription(this.description, Resources.getString("Editor.Replace.replace_command")));
    }

    protected static class Ed
    extends PlaceMarker.Ed {
        public Ed(Replace piece) {
            super(piece);
            this.defineButton.setText(Resources.getString("Editor.Replace.define_replacement"));
        }

        @Override
        protected BooleanConfigurer createMatchRotationConfig() {
            return new BooleanConfigurer(null, Resources.getString("Editor.Replace.match_current_state"));
        }

        @Override
        protected BooleanConfigurer createAboveConfig() {
            return new BooleanConfigurer(null, Resources.getString("Editor.Replace.only_match_above"));
        }

        @Override
        protected BooleanConfigurer createCopyConfig() {
            return new BooleanConfigurer(null, Resources.getString("Editor.Replace.copy_dps_by_name"));
        }

        @Override
        public String getType() {
            return Replace.ID + super.getType().substring("placemark;".length());
        }
    }
}

