/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.lang;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryUtils {
    private static final Logger logger = LoggerFactory.getLogger(MemoryUtils.class);

    protected MemoryUtils() {
    }

    public static long getPhysicalMemory() {
        try {
            java.lang.management.OperatingSystemMXBean o = ManagementFactory.getOperatingSystemMXBean();
            if (o instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean osb = (OperatingSystemMXBean)o;
                return osb.getTotalPhysicalMemorySize();
            }
        }
        catch (Exception e) {
            logger.error("Failed to get amount of physical RAM", (Throwable)e);
        }
        return -1L;
    }

    public static void main(String[] args) {
        long ram = MemoryUtils.getPhysicalMemory();
        if (ram >= 0L) {
            System.out.println("System reports " + (ram >> 20) + "MB RAM");
        } else {
            System.out.println("Could not determine amount of RAM");
        }
    }
}

