/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.tools.DataArchive;
import VASSAL.tools.swing.DataArchiveHTMLEditorKit;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.InlineView;

public class LabelerDataArchiveHTMLEditorKit
extends DataArchiveHTMLEditorKit {
    private static final long serialVersionUID = 1L;
    float valignImagesDefault = 0.5f;
    float valignTextDefault = 0.5f;

    public LabelerDataArchiveHTMLEditorKit(DataArchive arch) {
        super(arch);
    }

    public void setValignImagesDefault(float align) {
        this.valignImagesDefault = align;
    }

    public void setValignTextDefault(float align) {
        this.valignTextDefault = align;
    }

    private float getValign(Element e, float def) {
        AttributeSet attrs = e.getAttributes();
        String v = (String)attrs.getAttribute(HTML.Attribute.VALIGN);
        if ("top".equals(v)) {
            return 0.0f;
        }
        if ("middle".equals(v)) {
            return 0.5f;
        }
        if ("bottom".equals(v)) {
            return 1.0f;
        }
        return def;
    }

    @Override
    public ViewFactory getViewFactory() {
        return new LabelerDataArchiveHTMLFactory();
    }

    private class LabelerDataArchiveHTMLFactory
    extends DataArchiveHTMLEditorKit.DataArchiveHTMLFactory {
        private LabelerDataArchiveHTMLFactory() {
        }

        @Override
        public View create(Element e) {
            String file;
            AttributeSet attrs = e.getAttributes();
            HTML.Tag kind = (HTML.Tag)attrs.getAttribute(StyleConstants.NameAttribute);
            if (kind == HTML.Tag.CONTENT) {
                return new LabelerInlineView(e);
            }
            if (kind == HTML.Tag.IMG && (file = (String)attrs.getAttribute(HTML.Attribute.SRC)) != null && !file.isBlank() && !file.contains("/")) {
                return new LabelerDataArchiveImageView(e);
            }
            return super.create(e);
        }
    }

    private class LabelerDataArchiveImageView
    extends DataArchiveHTMLEditorKit.DataArchiveImageView {
        protected final float valign;

        public LabelerDataArchiveImageView(Element e) {
            super(e);
            this.setLoadsSynchronously(true);
            this.valign = LabelerDataArchiveHTMLEditorKit.this.getValign(e, LabelerDataArchiveHTMLEditorKit.this.valignImagesDefault);
        }

        @Override
        public float getAlignment(int axis) {
            switch (axis) {
                case 1: {
                    return this.valign;
                }
            }
            return super.getAlignment(axis);
        }
    }

    protected class LabelerInlineView
    extends InlineView {
        protected float valign;

        public LabelerInlineView(Element e) {
            super(e);
            this.valign = LabelerDataArchiveHTMLEditorKit.this.getValign(e, LabelerDataArchiveHTMLEditorKit.this.valignTextDefault);
        }

        @Override
        public float getAlignment(int axis) {
            switch (axis) {
                case 1: {
                    return this.valign;
                }
            }
            return super.getAlignment(axis);
        }
    }
}

