/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.NewPeersSupport;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.PendingPeerLinkedList;
import org.litesoft.p2pchat.PendingPeerNode;
import org.litesoft.p2pchat.PendingPeersSupport;
import org.litesoft.p2pchat.UserDialog;

public class PendingPeerManager
extends Thread
implements NewPeersSupport {
    private UserDialog zUserDialog;
    private PendingPeerLinkedList zPendingPeers = new PendingPeerLinkedList();
    private PendingPeersSupport zPendingPeersSupport = null;
    private int maxRetries = 3;
    private boolean finish = false;

    public PendingPeerManager(UserDialog pUserDialog) {
        this.zUserDialog = pUserDialog;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zUserDialog.setPendingPeerManager(this);
    }

    public void start(PendingPeersSupport pPendingPeersSupport) {
        this.zPendingPeersSupport = pPendingPeersSupport;
        IllegalArgument.ifNull("PendingPeersSupport", this.zPendingPeersSupport);
        this.start();
    }

    @Override
    public void addNewPeer(PeerInfo pInfo) {
        IllegalArgument.ifNull("Info", pInfo);
        this.zPendingPeers.add(null, pInfo);
    }

    public void addNewPeer(Socket pSocket) {
        IllegalArgument.ifNull("Socket", pSocket);
        InetAddress theirAddress = pSocket.getInetAddress();
        String theirName = theirAddress.getHostName();
        String theirIP = theirAddress.getHostAddress();
        String name = theirIP.equals(theirName) ? null : "(Host: " + theirName + ")";
        this.zPendingPeers.add(pSocket, new PeerInfo(name, theirIP));
    }

    public void addNewPeer(PeerInfo info, PeerReader reader, PeerWriter writer) {
        this.zPendingPeersSupport.addActivePeer(info, reader, writer);
    }

    @Override
    public void run() {
        while (true) {
            final PendingPeerNode next = this.zPendingPeers.next();
            if (this.finish) {
                return;
            }
            Runnable runnable = new Runnable(){
                final /* synthetic */ PendingPeerManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.handleNewPeerClient(next);
                }
            };
            new Thread(runnable).start();
        }
    }

    public void finish() {
        this.finish = true;
        this.interrupt();
    }

    private void handleNewPeerClient(PendingPeerNode pPendingPeerNode) {
        Socket socket;
        PeerInfo peerInfo = pPendingPeerNode.getPeerInfo();
        if (this.zPendingPeersSupport.isAlreadyConnected(peerInfo)) {
            return;
        }
        if ("true".equals(System.getProperty("debug"))) {
            System.err.println("Attempting to contact " + peerInfo.format());
        }
        if ((socket = pPendingPeerNode.getSocket()) == null) {
            try {
                socket = this.getPeerClientSocketFromAddresses(peerInfo);
            }
            catch (IOException e) {
                if ("true".equals(System.getProperty("debug"))) {
                    System.err.println("Failed to establish connection to " + peerInfo.format() + ":  " + e.getMessage());
                }
                if (peerInfo.incrementFailureCount() <= this.maxRetries) {
                    this.zPendingPeers.add(socket, peerInfo);
                } else {
                    if ("true".equals(System.getProperty("debug"))) {
                        System.err.println("Maximum retries reached for " + peerInfo.format());
                    }
                    peerInfo.setFailureReason(e);
                    this.zUserDialog.showConnectFailed(peerInfo);
                }
                return;
            }
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
        }
        catch (IOException e) {
            this.zUserDialog.showStreamsFailed(peerInfo);
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.zPendingPeersSupport.addActivePeer(peerInfo, inputStream, outputStream);
        this.zUserDialog.showConnect(peerInfo);
    }

    private Socket getPeerClientSocketFromAddresses(PeerInfo pPeerInfo) throws IOException {
        int i;
        String pPeerAddresses = pPeerInfo.getAddresses();
        int peerPort = pPeerInfo.getPort();
        while (-1 != (i = pPeerAddresses.indexOf(44))) {
            try {
                return this.getPeerClientSocket(pPeerAddresses.substring(0, i), peerPort);
            }
            catch (IOException e) {
                if ("true".equals(System.getProperty("debug"))) {
                    System.err.println("Failed to establish connection to " + pPeerAddresses.substring(0, i) + ":" + peerPort + ".  " + e.getMessage());
                }
                pPeerAddresses = pPeerAddresses.substring(i + 1);
            }
        }
        return this.getPeerClientSocket(pPeerAddresses, peerPort);
    }

    private Socket getPeerClientSocket(String pPeerAddress, int pPeerPort) throws IOException {
        Socket retval = new Socket(pPeerAddress, pPeerPort);
        if ("true".equals(System.getProperty("debug"))) {
            System.err.println("Established connection to " + pPeerAddress + ":" + pPeerPort);
        }
        return retval;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setSocketConnectTimeout(long socketConnectTimeout) {
    }
}

