/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.wizard;

import java.awt.Container;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.wizard.WizardResultReceiver;
import org.netbeans.api.wizard.displayer.WizardDisplayerImpl;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.Wizard;

public abstract class WizardDisplayer {
    private static final String SYSPROP_KEY = "WizardDisplayer.default";

    protected WizardDisplayer() {
    }

    public static Object showWizard(Wizard wizard, Rectangle rect, Action help, Map initialProperties) {
        WizardDisplayer.nonBuggyWizard(wizard);
        WizardDisplayer defaultInstance = WizardDisplayer.getDefault();
        return defaultInstance.show(wizard, rect, help, initialProperties);
    }

    private static WizardDisplayer getDefault() {
        String wdProp;
        WizardDisplayer factory = NbBridge.getFactoryViaLookup();
        if (factory == null && (wdProp = System.getProperty(SYSPROP_KEY)) != null) {
            try {
                factory = (WizardDisplayer)Class.forName(wdProp).newInstance();
            }
            catch (Exception e) {
                System.err.println("Could not instantiate " + wdProp);
                System.setProperty(SYSPROP_KEY, null);
                e.printStackTrace();
            }
        }
        if (factory == null) {
            factory = new WizardDisplayerImpl();
        }
        return factory;
    }

    public static Object showWizard(Wizard wizard) {
        return WizardDisplayer.showWizard(wizard, null, null, null);
    }

    public static Object showWizard(Wizard wizard, Action help) {
        return WizardDisplayer.showWizard(wizard, null, help, null);
    }

    public static Object showWizard(Wizard wizard, Rectangle r) {
        return WizardDisplayer.showWizard(wizard, r, null, null);
    }

    protected abstract Object show(Wizard var1, Rectangle var2, Action var3, Map var4);

    public static WizardDisplayer installInContainer(Container c, Object layoutConstraint, Wizard awizard, Action helpAction, Map initialProperties, WizardResultReceiver receiver) {
        WizardDisplayer displayer = WizardDisplayer.getDefault();
        displayer.install(c, layoutConstraint, awizard, helpAction, initialProperties, receiver);
        return displayer;
    }

    protected abstract void install(Container var1, Object var2, Wizard var3, Action var4, Map var5, WizardResultReceiver var6);

    private static boolean nonBuggyWizard(Wizard wizard) {
        Object[] s = wizard.getAllSteps();
        if (new HashSet<String>(Arrays.asList(s)).size() != s.length) {
            throw new RuntimeException("steps are duplicated: " + Arrays.toString(s));
        }
        if (s.length == 1 && "_#UndeterminedStep".equals(s[0])) {
            throw new RuntimeException("Only ID may not be UNDETERMINED_ID");
        }
        for (int i = 0; i < s.length; ++i) {
            if (!"_#UndeterminedStep".equals(s[i]) || i == s.length - 1) continue;
            throw new RuntimeException("UNDETERMINED_ID may only be last element in ids array " + Arrays.toString(s));
        }
        return true;
    }
}

