/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.wizard.displayer;

import java.awt.Container;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.api.wizard.displayer.NavButtonManager;
import org.netbeans.api.wizard.displayer.WizardDisplayerImpl;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;

public class NavProgress
implements ResultProgressHandle {
    private static final Logger logger = Logger.getLogger(NavProgress.class.getName());
    private static final Icon busyIcon = new ImageIcon(NavProgress.class.getResource("busy.gif"));
    private static final String MESSAGE_SPACE = "________________________________________________________________";
    private final JPanel panel = new JPanel();
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel messageLabel = new JLabel("________________________________________________________________");
    private final JLabel busyLabel = new JLabel();
    private final WizardDisplayerImpl parent;
    private final boolean disableUIWhileBusy;
    private boolean isRunning = true;

    NavProgress(WizardDisplayerImpl impl, boolean disableUIWhileBusy) {
        this.parent = impl;
        this.disableUIWhileBusy = disableUIWhileBusy;
        this.panel.setOpaque(false);
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.messageLabel);
        if (disableUIWhileBusy) {
            this.panel.add(this.busyLabel);
        } else {
            this.panel.add(this.progressBar);
        }
        this.setBusy();
    }

    @Override
    public void addProgressComponents(Container container) {
        container.add(this.panel);
        container.invalidate();
    }

    @Override
    public void setProgress(final String description, final int currentStep, final int totalSteps) {
        Runnable r = new Runnable(){
            final /* synthetic */ NavProgress this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.messageLabel.setText(description == null ? " " : description);
                this.this$0.messageLabel.revalidate();
                this.this$0.setProgress(currentStep, totalSteps);
                this.this$0.panel.repaint();
            }
        };
        this.invoke(r);
    }

    @Override
    public void setProgress(final int currentStep, final int totalSteps) {
        if (totalSteps == -1) {
            this.setBusy();
        } else {
            if (currentStep > totalSteps || currentStep < 0) {
                throw new IllegalArgumentException("Bad step values: " + currentStep + " out of " + totalSteps);
            }
            this.invoke(new Runnable(){
                final /* synthetic */ NavProgress this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (this.this$0.disableUIWhileBusy) {
                        this.this$0.busyLabel.setIcon(null);
                    } else {
                        this.this$0.progressBar.setIndeterminate(false);
                        this.this$0.progressBar.setMaximum(totalSteps);
                        this.this$0.progressBar.setValue(currentStep);
                    }
                    this.this$0.panel.repaint();
                }
            });
        }
    }

    private void setBusy() {
        this.invoke(new Runnable(){

            @Override
            public void run() {
                if (NavProgress.this.disableUIWhileBusy) {
                    NavProgress.this.busyLabel.setIcon(busyIcon);
                } else {
                    NavProgress.this.progressBar.setIndeterminate(true);
                }
            }
        });
    }

    @Override
    public void setBusy(final String description) {
        this.invoke(new Runnable(){
            final /* synthetic */ NavProgress this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.messageLabel.setText(description == null ? " " : description);
                this.this$0.setBusy();
            }
        });
    }

    private void invoke(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                logger.severe("Error invoking operation " + ex.getClass().getName() + " " + ex.getMessage());
            }
            catch (InterruptedException ex) {
                logger.severe("Error invoking operation " + ex.getClass().getName() + " " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void finished(final Object o) {
        this.isRunning = false;
        Runnable r = new Runnable(){
            final /* synthetic */ NavProgress this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (o instanceof Summary) {
                    Summary summary = (Summary)o;
                    this.this$0.parent.handleSummary(summary);
                    this.this$0.parent.setWizardResult(summary.getResult());
                } else if (this.this$0.parent.getDeferredResult() != null) {
                    this.this$0.parent.setWizardResult(o);
                    this.this$0.parent.getButtonManager().deferredResultFinished(o);
                }
            }
        };
        this.invoke(r);
    }

    @Override
    public void failed(final String message, final boolean canGoBack) {
        this.isRunning = false;
        Runnable r = new Runnable(){
            final /* synthetic */ NavProgress this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JLabel comp = new JLabel("<html><body>" + message + "</body></html>");
                comp.setBorder(new EmptyBorder(5, 5, 5, 5));
                this.this$0.parent.setCurrentWizardPanel(comp);
                this.this$0.parent.getTtlLabel().setText(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Failed"));
                NavButtonManager bm = this.this$0.parent.getButtonManager();
                bm.deferredResultFailed(canGoBack);
            }
        };
        this.invoke(r);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }
}

