/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardImplementation;
import org.netbeans.spi.wizard.WizardObserver;

public final class Wizard {
    public static final int MODE_CAN_CONTINUE = 1;
    public static final int MODE_CAN_FINISH = 2;
    public static final int MODE_CAN_CONTINUE_OR_FINISH = 3;
    public static final String UNDETERMINED_STEP = "_#UndeterminedStep";
    final WizardImplementation impl;
    private volatile boolean listeningToImpl = false;
    private final List listeners = Collections.synchronizedList(new LinkedList());
    private WizardObserver l = null;

    Wizard(WizardImplementation impl) {
        this.impl = impl;
        if (impl == null) {
            throw new NullPointerException();
        }
    }

    public JComponent navigatingTo(String id, Map wizardData) {
        return this.impl.navigatingTo(id, wizardData);
    }

    public String getCurrentStep() {
        return this.impl.getCurrentStep();
    }

    public String getNextStep() {
        return this.impl.getNextStep();
    }

    public String getPreviousStep() {
        return this.impl.getPreviousStep();
    }

    public String getProblem() {
        return this.impl.getProblem();
    }

    public String[] getAllSteps() {
        return this.impl.getAllSteps();
    }

    public String getLongDescription(String stepId) {
        return this.impl.getLongDescription(stepId);
    }

    public String getStepDescription(String id) {
        return this.impl.getStepDescription(id);
    }

    public Object finish(Map settings) throws WizardException {
        return this.impl.finish(settings);
    }

    public boolean cancel(Map settings) {
        return this.impl.cancel(settings);
    }

    public String getTitle() {
        return this.impl.getTitle();
    }

    public boolean isBusy() {
        return this.impl.isBusy();
    }

    public int getForwardNavigationMode() {
        return this.impl.getForwardNavigationMode();
    }

    public void addWizardObserver(WizardObserver observer) {
        this.listeners.add(observer);
        if (!this.listeningToImpl) {
            this.l = new ImplL();
            this.impl.addWizardObserver(this.l);
            this.listeningToImpl = true;
        }
    }

    public void removeWizardObserver(WizardObserver observer) {
        this.listeners.remove(observer);
        if (this.listeningToImpl && this.listeners.size() == 0) {
            this.impl.removeWizardObserver(this.l);
            this.l = null;
            this.listeningToImpl = false;
        }
    }

    public int hashCode() {
        return this.impl.hashCode() * 17;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Wizard) {
            return this.impl.equals(((Wizard)o).impl);
        }
        return false;
    }

    public void show() {
        WizardDisplayer.showWizard(this);
    }

    public Object show(Wizard wizard, Action help) {
        return WizardDisplayer.showWizard(wizard, help);
    }

    public Object show(Wizard wizard, Rectangle r) {
        return WizardDisplayer.showWizard(wizard, r);
    }

    public Object show(Wizard wizard, Rectangle r, Action help) {
        return WizardDisplayer.showWizard(wizard, r, help, null);
    }

    private class ImplL
    implements WizardObserver {
        private ImplL() {
        }

        @Override
        public void stepsChanged(Wizard wizard) {
            WizardObserver[] l = Wizard.this.listeners.toArray(new WizardObserver[Wizard.this.listeners.size()]);
            for (int i = 0; i < l.length; ++i) {
                l[i].stepsChanged(Wizard.this);
            }
        }

        @Override
        public void navigabilityChanged(Wizard wizard) {
            WizardObserver[] l = Wizard.this.listeners.toArray(new WizardObserver[Wizard.this.listeners.size()]);
            for (int i = 0; i < l.length; ++i) {
                l[i].navigabilityChanged(Wizard.this);
            }
        }

        @Override
        public void selectionChanged(Wizard wizard) {
            WizardObserver[] l = Wizard.this.listeners.toArray(new WizardObserver[Wizard.this.listeners.size()]);
            for (int i = 0; i < l.length; ++i) {
                l[i].selectionChanged(Wizard.this);
            }
        }
    }
}

