/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GpIdChecker {
    protected GpIdSupport gpIdSupport;
    protected int maxId;
    protected boolean extensionsLoaded = false;
    final Map<String, SlotElement> goodSlots = new HashMap<String, SlotElement>();
    final List<SlotElement> errorSlots = new ArrayList<SlotElement>();
    private Chatter chatter;
    private final Set<String> refresherOptions = new HashSet<String>();

    public GpIdChecker() {
        this((GpIdSupport)null);
    }

    public GpIdChecker(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
        this.maxId = -1;
    }

    public GpIdChecker(Set<String> options) {
        this();
        this.extensionsLoaded = true;
        if (!options.isEmpty()) {
            this.refresherOptions.addAll(options);
        }
    }

    public boolean useLabelerName() {
        return this.refresherOptions.contains("UseLabelerName");
    }

    public boolean useLayerName() {
        return this.refresherOptions.contains("UseLayerName");
    }

    public boolean useRotateName() {
        return this.refresherOptions.contains("UseRotateName");
    }

    public boolean useName() {
        return this.refresherOptions.contains("UseName");
    }

    public void add(PieceSlot pieceSlot) {
        this.testGpId(pieceSlot.getGpId(), new SlotElement(pieceSlot));
        this.checkTrait(pieceSlot.getPiece());
    }

    public void add(PrototypeDefinition prototype) {
        GamePiece gp = prototype.getPiece();
        this.checkTrait(gp, prototype, gp);
    }

    protected void checkTrait(GamePiece gp) {
        if (gp == null || gp instanceof BasicPiece) {
            return;
        }
        if (gp instanceof PlaceMarker) {
            PlaceMarker pm = (PlaceMarker)gp;
            this.testGpId(pm.getGpId(), new SlotElement(pm));
        }
        this.checkTrait(((Decorator)gp).getInner());
    }

    protected void checkTrait(GamePiece gp, PrototypeDefinition prototype, GamePiece definition) {
        if (gp == null || gp instanceof BasicPiece) {
            return;
        }
        if (gp instanceof PlaceMarker) {
            PlaceMarker pm = (PlaceMarker)gp;
            this.testGpId(pm.getGpId(), new SlotElement(pm, prototype, definition));
        }
        this.checkTrait(((Decorator)gp).getInner(), prototype, definition);
    }

    protected void testGpId(String id, SlotElement element) {
        if (!this.extensionsLoaded && id.contains(":")) {
            id = id.split(":")[1];
        }
        if (id == null || id.length() == 0) {
            this.errorSlots.add(element);
        } else {
            if (this.goodSlots.get(id) != null) {
                this.errorSlots.add(element);
            }
            try {
                if (this.extensionsLoaded) {
                    this.goodSlots.put(id, element);
                } else {
                    int iid = Integer.parseInt(id);
                    this.goodSlots.put(id, element);
                    if (iid > this.maxId) {
                        this.maxId = iid;
                    }
                }
            }
            catch (Exception e) {
                this.errorSlots.add(element);
            }
        }
    }

    public boolean hasErrors() {
        return !this.errorSlots.isEmpty();
    }

    private void chat(String text) {
        if (this.chatter == null) {
            this.chatter = GameModule.getGameModule().getChatter();
        }
        Chatter.DisplayText mess = new Chatter.DisplayText(this.chatter, "- " + text);
        mess.execute();
    }

    public void fixErrors() {
        if (this.maxId >= this.gpIdSupport.getNextGpId()) {
            this.chat(Resources.getString("GpIdChecker.next_gpid_updated", this.gpIdSupport.getNextGpId(), this.maxId + 1));
            this.gpIdSupport.setNextGpId(this.maxId + 1);
        }
        for (SlotElement slotElement : this.errorSlots) {
            String before = slotElement.getGpId();
            slotElement.updateGpId();
            this.chat(Resources.getString("GpIdChecker.piece_gpid_updated", slotElement.toString(), before, slotElement.getGpId()));
        }
    }

    public GamePiece createUpdatedPiece(GamePiece oldPiece) {
        SlotElement element;
        String gpid = (String)oldPiece.getProperty("PieceId");
        if (gpid != null && !gpid.isEmpty() && (element = this.goodSlots.get(gpid)) != null) {
            GamePiece newPiece = element.createPiece(oldPiece, this);
            this.copyState(oldPiece, newPiece);
            return newPiece;
        }
        if (this.useName()) {
            String oldPieceName = Decorator.getInnermost(oldPiece).getName();
            for (SlotElement element2 : this.goodSlots.values()) {
                GamePiece slotPiece = element2.getPiece();
                String gpName = Decorator.getInnermost(slotPiece).getName();
                if (!oldPieceName.equals(gpName)) continue;
                GamePiece newPiece = element2.createPiece(oldPiece, this);
                this.copyState(oldPiece, newPiece);
                return newPiece;
            }
        }
        return oldPiece;
    }

    protected void copyState(GamePiece oldPiece, GamePiece newPiece) {
        GamePiece p = newPiece;
        while (p != null) {
            if (p instanceof BasicPiece) {
                p.setState(Decorator.getInnermost(oldPiece).getState());
                p = null;
                continue;
            }
            Decorator decoratorNew = (Decorator)p;
            String newState = this.findState(oldPiece, p, decoratorNew, p.getClass());
            if (!(newState == null || decoratorNew instanceof Marker || decoratorNew instanceof Labeler && !((Labeler)decoratorNew).canChange())) {
                decoratorNew.mySetState(newState);
            }
            p = decoratorNew.getInner();
        }
    }

    protected String findState(GamePiece oldPiece, GamePiece pNew, Decorator decoratorNewPc, Class<? extends GamePiece> classToFind) {
        GamePiece p = oldPiece;
        String typeToFind = decoratorNewPc.myGetType();
        while (p != null && !(p instanceof BasicPiece)) {
            Decorator d = (Decorator)Decorator.getDecorator(p, classToFind);
            if (d != null) {
                if (d.getClass().equals(classToFind)) {
                    String nameToFind;
                    if (d.myGetType().equals(typeToFind)) {
                        return d.myGetState();
                    }
                    if (d instanceof Labeler) {
                        if (this.useLabelerName()) {
                            nameToFind = ((Labeler)decoratorNewPc).getActualDescription();
                            String name = ((Labeler)d).getActualDescription();
                            if (name.equals(nameToFind)) {
                                return d.myGetState();
                            }
                        }
                    } else if (d instanceof Embellishment) {
                        if (this.useLayerName()) {
                            nameToFind = ((Embellishment)decoratorNewPc).getLayerName();
                            if (((Embellishment)d).getLayerName().equals(nameToFind)) {
                                return d.myGetState();
                            }
                        }
                    } else if (d instanceof FreeRotator && this.useRotateName()) {
                        nameToFind = ((FreeRotator)decoratorNewPc).getRotateName();
                        if (((FreeRotator)d).getRotateName().equals(nameToFind)) {
                            return d.myGetState();
                        }
                    }
                }
                p = d.getInner();
                continue;
            }
            p = null;
        }
        return null;
    }

    static class SlotElement {
        private PieceSlot slot = null;
        private PlaceMarker marker = null;
        private String id;
        private PrototypeDefinition prototype = null;
        private GamePiece expandedPrototype = null;
        private GpIdChecker gpIdChecker;

        public SlotElement() {
        }

        public SlotElement(PieceSlot ps) {
            this();
            this.slot = ps;
            this.id = ps.getGpId();
        }

        public SlotElement(PlaceMarker pm) {
            this();
            this.marker = pm;
            this.id = pm.getGpId();
        }

        public SlotElement(PlaceMarker pm, PrototypeDefinition pd, GamePiece definition) {
            this();
            this.marker = pm;
            this.prototype = pd;
            this.expandedPrototype = definition;
            this.id = pm.getGpId();
        }

        public String getGpId() {
            return this.id;
        }

        public String toString() {
            return this.marker == null ? Resources.getString("GpIdChecker.piece_slot", this.slot.getConfigureName()) : Resources.getString("GpIdChecker.place_replace_trait", this.marker.getDescription());
        }

        public void updateGpId() {
            if (this.marker == null) {
                this.slot.updateGpId();
                this.id = this.slot.getGpId();
            } else {
                this.marker.updateGpId();
                this.id = this.marker.getGpId();
                if (this.prototype != null) {
                    this.prototype.setPiece(this.expandedPrototype);
                }
            }
        }

        public GamePiece getPiece() {
            if (this.slot == null) {
                return this.marker;
            }
            return this.slot.getPiece();
        }

        public GamePiece createPiece(GamePiece oldPiece, GpIdChecker gpIdChecker) {
            this.gpIdChecker = gpIdChecker;
            GamePiece newPiece = this.slot != null ? this.slot.getPiece() : this.marker.createMarker();
            newPiece = PieceCloner.getInstance().clonePiece(newPiece);
            newPiece.setProperty("PieceId", this.getGpId());
            return newPiece;
        }
    }
}

