/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.BoxWidget;
import VASSAL.build.widget.Chart;
import VASSAL.build.widget.HtmlChart;
import VASSAL.build.widget.ListWidget;
import VASSAL.build.widget.MapWidget;
import VASSAL.build.widget.PanelWidget;
import VASSAL.build.widget.TabWidget;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.PositionOption;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ChartWindow
extends Widget {
    public static final String DESCRIPTION = "description";
    public static final String DEPRECATED_NAME = "label";
    public static final String NAME = "name";
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    protected LaunchButton launch;
    protected JDialog frame;
    protected Container root = new JPanel();
    protected String tooltip = "";
    protected String id;
    protected String description;

    public ChartWindow() {
        ActionListener al = new ActionListener(){
            boolean initialized;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.initialized) {
                    String key = "BoundsOf" + ChartWindow.this.id;
                    GameModule.getGameModule().getPrefs().addOption(new PositionOption(key, ChartWindow.this.frame));
                    this.initialized = true;
                }
                ChartWindow.this.frame.setVisible(!ChartWindow.this.frame.isVisible());
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, al);
        this.setAttribute(NAME, Resources.getString("Editor.ChartWindow.component_type"));
        this.setAttribute(BUTTON_TEXT, Resources.getString("Editor.ChartWindow.component_type"));
        this.launch.setAttribute(TOOLTIP, Resources.getString("Editor.ChartWindow.component_type"));
    }

    @Override
    public void addTo(Buildable b) {
        this.rebuild();
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.frame = new JDialog(GameModule.getGameModule().getPlayerWindow());
        GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.frame.getRootPane(), 2));
        while (this.root.getComponentCount() > 0) {
            this.frame.add(this.root.getComponent(0));
        }
        this.root = this.frame.getContentPane();
        this.frame.setTitle(this.getAttributeValueString(NAME));
        int count = GameModule.getGameModule().getComponentsOf(ChartWindow.class).size();
        this.id = "ChartWindow" + count;
    }

    @Override
    public void removeFrom(Buildable b) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (DEPRECATED_NAME.equals(key)) {
            this.setAttribute(NAME, val);
            this.setAttribute(BUTTON_TEXT, val);
        } else if (NAME.equals(key)) {
            this.setConfigureName((String)val);
            if (this.tooltip.length() == 0) {
                this.launch.setToolTipText((String)val);
            }
            if (this.frame != null) {
                this.frame.setTitle((String)val);
            }
        } else if (TOOLTIP.equals(key)) {
            this.tooltip = (String)val;
            this.launch.setAttribute(key, val);
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)val;
        } else {
            this.launch.setAttribute(key, val);
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, DESCRIPTION, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY};
    }

    @Override
    public String getAttributeValueString(String name) {
        if (NAME.equals(name)) {
            return this.getConfigureName();
        }
        if (TOOLTIP.equals(name)) {
            return this.tooltip.length() == 0 ? this.launch.getAttributeValueString(name) : this.tooltip;
        }
        if (DESCRIPTION.equals(name)) {
            return this.description;
        }
        return this.launch.getAttributeValueString(name);
    }

    @Override
    public Class<?>[] getChildAllowableConfigureComponents() {
        return new Class[]{Chart.class, HtmlChart.class, TabWidget.class, PanelWidget.class, BoxWidget.class, ListWidget.class, MapWidget.class};
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return this.getChildAllowableConfigureComponents();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof Widget) {
            this.root.add(((Widget)b).getComponent());
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        if (b instanceof Widget) {
            this.root.remove(((Widget)b).getComponent());
        }
        super.remove(b);
    }

    @Override
    public Component getComponent() {
        return this.root;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ChartWindow.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.html");
    }

    @Override
    public List<String> getMenuTextList() {
        return Arrays.asList(this.getAttributeValueString(BUTTON_TEXT), this.getAttributeValueString(TOOLTIP));
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(HOTKEY)));
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        String string = this.launch.getAttributeValueString(this.launch.getIconAttribute());
        if (string != null) {
            s.add(string);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/chart.gif");
        }
    }
}

