/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AbstractFolder;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.folder.PrototypeFolder;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.Configurer;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PrototypesContainer
extends AbstractConfigurable {
    private static PrototypesContainer instance;
    private final Map<String, PrototypeDefinition> definitions = new HashMap<String, PrototypeDefinition>();

    public Collection<PrototypeDefinition> getDefinitions() {
        return Collections.unmodifiableCollection(this.definitions.values());
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String key) {
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{PrototypeFolder.class, PrototypeDefinition.class};
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PrototypesContainer.component_type");
    }

    private void rebuildPrototypeMap(AbstractBuildable target) {
        for (Buildable b : target.getBuildables()) {
            if (b instanceof PrototypeDefinition) {
                this.addDefinition((PrototypeDefinition)b);
                continue;
            }
            if (!(b instanceof AbstractBuildable)) continue;
            this.rebuildPrototypeMap((AbstractBuildable)b);
        }
    }

    public void addDefinition(PrototypeDefinition def) {
        this.definitions.put(def.getConfigureName(), def);
        def.addPropertyChangeListener(evt -> {
            if ("name".equals(evt.getPropertyName())) {
                this.definitions.clear();
                this.rebuildPrototypeMap(GameModule.getGameModule());
            }
        });
    }

    @Override
    public void add(Buildable b) {
        super.add(b);
        if (b instanceof PrototypeDefinition) {
            this.addDefinition((PrototypeDefinition)b);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Prototypes.html");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    public static PrototypesContainer findInstance() {
        if (instance == null) {
            Iterator<PrototypesContainer> i = GameModule.getGameModule().getComponentsOf(PrototypesContainer.class).iterator();
            if (i.hasNext()) {
                instance = i.next();
            } else {
                return null;
            }
        }
        return instance;
    }

    private void resetCache(AbstractBuildable target) {
        for (Buildable b : target.getBuildables()) {
            if (b instanceof PrototypeDefinition) {
                ((PrototypeDefinition)b).clearCache();
                continue;
            }
            if (!(b instanceof AbstractFolder)) continue;
            this.resetCache((AbstractBuildable)b);
        }
    }

    private void resetPieceCache(AbstractBuildable target) {
        for (Buildable b : target.getBuildables()) {
            if (b instanceof PieceSlot) {
                ((PieceSlot)b).clearCache();
                continue;
            }
            if (!(b instanceof AbstractBuildable)) continue;
            this.resetPieceCache((AbstractBuildable)b);
        }
    }

    public void resetCache() {
        this.resetCache(this);
        this.resetPieceCache(GameModule.getGameModule());
    }

    public static PrototypeDefinition getPrototype(String name) {
        PrototypesContainer.findInstance();
        return instance == null ? null : PrototypesContainer.instance.definitions.get(name);
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData data = super.getI18nData();
        data.setPrefix("");
        return data;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return true;
    }
}

