/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.dice;

import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.DieServer;
import VASSAL.build.module.dice.RollSet;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class BonesDiceServer
extends DieServer {
    public BonesDiceServer() {
        this.name = "Bones";
        this.description = "Bones Dice Server";
        this.emailOnly = false;
        this.maxRolls = 0;
        this.maxEmails = 0;
        this.serverURL = "http://dice.nomic.net/cgi-bin/randroll.pl";
        this.passwdRequired = false;
        this.canDoSeparateDice = true;
    }

    @Override
    public String[] buildInternetRollString(RollSet toss) {
        DieRoll[] rolls = toss.getDieRolls();
        StringBuilder query = new StringBuilder("req=");
        for (DieRoll roll : rolls) {
            query.append("{{").append(roll.getNumDice()).append('D').append(roll.getNumSides());
            if (roll.getPlus() != 0) {
                query.append('+').append(roll.getPlus());
            }
            query.append("}}\n");
        }
        try {
            return new String[]{new URI("http", "dice.nomic.net", "/cgi-bin/randroll.pl", query.toString(), null).toURL().toString()};
        }
        catch (MalformedURLException | URISyntaxException e) {
            ErrorDialog.bug(e);
            return null;
        }
    }

    @Override
    public void parseInternetRollString(RollSet rollSet, Vector<String> results) {
        Iterator<String> line = results.iterator();
        for (int i = 0; i < rollSet.dieRolls.length; ++i) {
            StringTokenizer st = new StringTokenizer(line.next(), " ");
            for (int j = 0; j < rollSet.dieRolls[i].getNumDice(); ++j) {
                rollSet.dieRolls[i].setResult(j, Integer.parseInt(st.nextToken()));
            }
        }
    }

    @Override
    public void roll(RollSet mr, FormattedString format) {
        super.doInternetRoll(mr, format);
    }

    @Override
    public void doIRoll(RollSet toss) throws IOException {
        String[] rollString = this.buildInternetRollString(toss);
        Vector<String> returnString = new Vector<String>();
        URL url = new URL(rollString[0]);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                returnString.add(line);
            }
        }
        this.parseInternetRollString(toss, returnString);
    }
}

