/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.i18n.Resources;
import VASSAL.tools.image.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class Symbol {
    protected static final String NATO = "NATO Unit Symbols";
    protected static final String[] SYMBOL_SETS = new String[]{"NATO Unit Symbols"};
    protected static final String[] SYMBOL_SETS_DESC = new String[]{"Editor.Symbol.NATO"};
    protected String symbolSetName;
    protected String symbolName1;
    protected String symbolName2;
    protected String symbolSize;

    public Symbol(String setName, String name1, String name2, String size) {
        this.symbolSetName = setName;
        this.symbolName1 = name1;
        this.symbolName2 = name2;
        this.symbolSize = size;
    }

    public void draw(Graphics g, Rectangle bounds, Color fg, Color bg, Color sz, float lineWidth) {
        if (this.symbolSetName.equals(NATO)) {
            NatoUnitSymbolSet.draw(this.symbolName1, this.symbolName2, g, bounds, fg, bg, sz, lineWidth, this.symbolSize);
        }
    }

    public static class NatoUnitSymbolSet {
        protected static final String SZ_NONE = "None";
        protected static final String SZ_INSTALLATION = "Installation";
        protected static final String SZ_TEAM = "Team";
        protected static final String SZ_SQUAD = "Squad";
        protected static final String SZ_SECTION = "Section";
        protected static final String SZ_PLATOON = "Platoon";
        protected static final String SZ_ECHELON = "Echelon";
        protected static final String SZ_COMPANY = "Company";
        protected static final String SZ_BATTALION = "Battalion";
        protected static final String SZ_REGIMENT = "Regiment";
        protected static final String SZ_BRIGADE = "Brigade";
        protected static final String SZ_DIVISION = "Division";
        protected static final String SZ_CORPS = "Corps";
        protected static final String SZ_ARMY = "Army";
        protected static final String SZ_ARMY_GROUP = "Army Group";
        protected static final String SZ_REGION = "Region";
        protected static final String NONE = "None";
        protected static final String AIRBORNE = "Airborne";
        protected static final String AIR_DEFENCE = "Air Defence";
        protected static final String AIR_FORCE = "Air Force";
        protected static final String ANTI_TANK = "Anti Tank";
        protected static final String ARMORED = "Armored";
        protected static final String ARMY_AVIATION = "Army Aviation";
        protected static final String ARTILLERY = "Artillery";
        protected static final String COMMANDO = "Commando";
        protected static final String ENGINEERS = "Engineers";
        protected static final String GLIDER = "Glider-Borne";
        protected static final String GUERILLA = "Guerrilla";
        protected static final String INFANTRY = "Infantry";
        protected static final String MARINES = "Marines";
        protected static final String MOUNTAIN = "Mountain";
        protected static final String NAVY = "";
        protected static final String RECON = "Cavalry/Recon";
        protected static final String INSTALLATION_SYMBOL = "m";
        protected static final String TEAM_SYMBOL = "o";
        protected static final String SQUAD_SYMBOL = "s";
        protected static final String COMPANY_SYMBOL = "i";
        protected static final String BRIGADE_SYMBOL = "x";
        protected static String[] sizeNames;
        protected static String[] sizeDisplayNames;
        public static final SizeOption[] SIZES;

        protected static String[] getSymbolNames() {
            return new String[]{"None", INFANTRY, RECON, ARMORED, ARTILLERY, ENGINEERS, AIRBORNE, AIR_DEFENCE, AIR_FORCE, ANTI_TANK, ARMY_AVIATION, COMMANDO, GLIDER, GUERILLA, MOUNTAIN, NAVY};
        }

        protected static String[] getSymbolDisplayNames() {
            return new String[]{"Editor.Symbol.none", "Editor.Symbol.infantry", "Editor.Symbol.cavalry_recon", "Editor.Symbol.armored", "Editor.Symbol.artillery", "Editor.Symbol.engineers", "Editor.Symbol.airborne", "Editor.Symbol.air_defense", "Editor.Symbol.air_force", "Editor.Symbol.anti_tank", "Editor.Symbol.army_aviation", "Editor.Symbol.commando", "Editor.Symbol.glider_borne", "Editor.Symbol.guerrilla", "Editor.Symbol.mountain", "Editor.Symbol.navy"};
        }

        protected static String[] getSymbolSizes() {
            if (sizeNames == null) {
                sizeNames = new String[SIZES.length];
                for (int i = 0; i < SIZES.length; ++i) {
                    NatoUnitSymbolSet.sizeNames[i] = SIZES[i].getName();
                }
            }
            return sizeNames;
        }

        protected static String[] getSymbolSizeDisplayNames() {
            if (sizeDisplayNames == null) {
                sizeDisplayNames = new String[SIZES.length];
                for (int i = 0; i < SIZES.length; ++i) {
                    NatoUnitSymbolSet.sizeDisplayNames[i] = SIZES[i].getDisplayName();
                }
            }
            return sizeDisplayNames;
        }

        protected static SizeOption findSize(String name) {
            for (SizeOption size : SIZES) {
                if (!name.equals(size.getName())) continue;
                return size;
            }
            return SIZES[0];
        }

        protected static SizeOption findSizeByDisplayName(String displayName) {
            for (SizeOption size : SIZES) {
                if (!displayName.equals(size.getDisplayName())) continue;
                return size;
            }
            return SIZES[0];
        }

        protected static void draw(String name1, String name2, Graphics g, Rectangle bounds, Color fg, Color bg, Color sz, float lineWidth, String size) {
            if (bg != null) {
                g.setColor(bg);
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            g.setColor(fg);
            BasicStroke stroke = new BasicStroke(lineWidth, 1, 1);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(stroke);
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(sz);
            NatoUnitSymbolSet.drawSize(g, size, bounds);
            g.setColor(fg);
            NatoUnitSymbolSet.draw(g, lineWidth, name1, bounds, false);
            NatoUnitSymbolSet.draw(g, lineWidth, name2, bounds, true);
        }

        protected static void draw(Graphics g, float lineWidth, String name, Rectangle bounds, boolean drawLow) {
            if (name.equals("None") || name.equals(MARINES)) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            BasicStroke stroke = new BasicStroke(lineWidth, 1, 1);
            g2.setStroke(stroke);
            int x_left = bounds.x;
            int x_center = bounds.x + bounds.width / 2 + 1;
            int x_right = bounds.x + bounds.width;
            int y_top = bounds.y;
            int y_center = bounds.y + bounds.height / 2;
            int y_bottom = bounds.y + bounds.height;
            switch (name) {
                case "Airborne": {
                    int x1 = x_center - bounds.width / 4;
                    int y1 = y_top + bounds.height * 4 / 5 + 1;
                    g2.draw(new Arc2D.Double(x1, y1, bounds.width / 4, bounds.height / 4, 0.0, 180.0, 0));
                    g2.draw(new Arc2D.Double(x_center, y1, bounds.width / 4, bounds.height / 4, 0.0, 180.0, 0));
                    break;
                }
                case "Air Defence": {
                    g2.draw(new Arc2D.Double(x_left, y_top + bounds.height / 4, bounds.width, (double)bounds.height * 1.5, 0.0, 180.0, 0));
                    break;
                }
                case "Air Force": {
                    int xoff1 = (int)((double)bounds.width * 0.15);
                    int xoff2 = (int)((double)bounds.width * 0.2);
                    int yoff = (int)((double)bounds.height * 0.35);
                    g.drawLine(x_center - xoff2, y_top + yoff, x_center + xoff2, y_bottom - yoff);
                    g.drawLine(x_center + xoff2, y_top + yoff, x_center - xoff2, y_bottom - yoff);
                    g2.draw(new Arc2D.Double(x_center - xoff2 - xoff1, y_top + yoff, xoff1 * 2, bounds.height - 2 * yoff, 90.0, 180.0, 0));
                    g2.draw(new Arc2D.Double(x_center + xoff2 - xoff1, y_top + yoff, xoff1 * 2, bounds.height - 2 * yoff, 270.0, 180.0, 0));
                    break;
                }
                case "Anti Tank": {
                    g.drawLine(x_left, y_bottom, x_center, y_top);
                    g.drawLine(x_center, y_top, x_right, y_bottom);
                    break;
                }
                case "Armored": {
                    int yoff = (int)((double)bounds.height * 0.25);
                    int xoff1 = (int)((double)bounds.width * 0.15);
                    int xoff2 = (int)((double)bounds.width * 0.2);
                    g.drawLine(x_left + xoff1 + xoff2, y_top + yoff, x_right - xoff1 - xoff2, y_top + yoff);
                    g.drawLine(x_left + xoff1 + xoff2, y_bottom - yoff, x_right - xoff1 - xoff2, y_bottom - yoff);
                    g2.draw(new Arc2D.Double(x_left + xoff1, y_top + yoff, xoff2 * 2, bounds.height - yoff * 2, 90.0, 180.0, 0));
                    g2.draw(new Arc2D.Double(x_right - xoff1 - 2 * xoff2, y_top + yoff, xoff2 * 2, bounds.height - yoff * 2, 270.0, 180.0, 0));
                    break;
                }
                case "Army Aviation": {
                    int xoff = (int)((double)bounds.height * 0.25);
                    int yoff = (int)((double)bounds.height * 0.33);
                    GeneralPath p = new GeneralPath();
                    p.moveTo(x_left + xoff, y_top + yoff);
                    p.lineTo(x_right - yoff, y_bottom - yoff);
                    p.lineTo(x_right - yoff, y_top + yoff);
                    p.lineTo(x_left + xoff, y_bottom - yoff);
                    p.closePath();
                    g2.draw(p);
                    break;
                }
                case "Artillery": {
                    int radius = bounds.height / 5;
                    int yoff = drawLow ? (int)((double)bounds.height * 0.2) : 0;
                    g.fillOval(x_center - radius, y_center - radius + yoff, radius * 2, radius * 2);
                    break;
                }
                case "Commando": {
                    g.drawLine(x_left, y_top, x_right, y_bottom);
                    g.drawLine(x_left, y_bottom, x_right, y_top);
                    int x1 = (int)((double)bounds.width / 2.5);
                    int y1 = (int)((double)bounds.height / 2.5);
                    GeneralPath p = new GeneralPath();
                    p.moveTo(x_left, y_top);
                    p.lineTo(x_left + x1, y_top);
                    p.lineTo(x_left + x1, y_top + y1);
                    p.lineTo(x_left, y_top);
                    p.moveTo(x_right, y_top);
                    p.lineTo(x_right - x1, y_top);
                    p.lineTo(x_right - x1, y_top + y1);
                    p.lineTo(x_right, y_top);
                    g2.fill(p);
                    break;
                }
                case "Engineers": {
                    BasicStroke oldStroke = (BasicStroke)g2.getStroke();
                    BasicStroke estroke = new BasicStroke(oldStroke.getLineWidth() * 1.2f, 1, 1);
                    g2.setStroke(estroke);
                    int yh = (int)((double)bounds.height * 0.2);
                    int y1 = drawLow ? y_bottom - yh - 1 : y_top + (bounds.height - yh) / 2;
                    int y2 = y1 + yh;
                    int x1 = x_center - bounds.width / 5;
                    int x2 = x_center + bounds.width / 5;
                    GeneralPath p = new GeneralPath();
                    p.moveTo(x1, y2);
                    p.lineTo(x1, y1);
                    p.lineTo(x2, y1);
                    p.lineTo(x2, y2);
                    p.moveTo(x_center, y2);
                    p.lineTo(x_center, y1);
                    g2.draw(p);
                    break;
                }
                case "Glider-Borne": {
                    g.drawLine(x_left + (x_center - x_left) / 3, y_center, x_right - (x_center - x_left) / 3, y_center);
                    break;
                }
                case "Guerrilla": {
                    GeneralPath p = new GeneralPath();
                    p.moveTo(x_left, y_top);
                    p.lineTo(x_right, y_bottom);
                    p.lineTo(x_right, y_top);
                    p.lineTo(x_left, y_bottom);
                    p.lineTo(x_left, y_top);
                    g2.fill(p);
                    break;
                }
                case "Infantry": {
                    g.drawLine(x_left, y_top, x_right, y_bottom);
                    g.drawLine(x_left, y_bottom, x_right, y_top);
                    break;
                }
                case "Mountain": {
                    int x_off = bounds.width / 6;
                    GeneralPath p = new GeneralPath();
                    p.moveTo(x_center, y_center);
                    p.lineTo(x_center + x_off, y_bottom);
                    p.lineTo(x_center - x_off, y_bottom);
                    p.closePath();
                    g2.fill(p);
                    break;
                }
                case "": {
                    int yoff1 = (int)((double)bounds.height * 0.2);
                    int yoff2 = (int)((double)bounds.height * 0.15);
                    int xoff1 = (int)((double)bounds.width * 0.15);
                    int xoff2 = (int)((double)bounds.width * 0.3);
                    g.drawLine(x_center, y_top + yoff1, x_center, y_bottom - yoff1);
                    g.drawLine(x_center - xoff1, y_top + yoff1 + yoff2, x_center + xoff1, y_top + yoff1 + yoff2);
                    g2.draw(new Arc2D.Double(x_center - xoff2, y_top + yoff1, xoff2 * 2, bounds.height - 2 * yoff1, 225.0, 90.0, 0));
                    break;
                }
                case "Cavalry/Recon": {
                    g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y);
                    break;
                }
            }
        }

        protected static void drawSize(Graphics g, String size, Rectangle bounds) {
            if (size.equals("None") || size.equals(NAVY)) {
                return;
            }
            SizeOption option = NatoUnitSymbolSet.findSize(size);
            String type = option.getType();
            int count = option.getCount();
            int sym_h = bounds.height / 3;
            int sym_w = count <= 4 ? bounds.width / 5 : bounds.width / 7;
            int gap = bounds.width / 15;
            BufferedImage bi = NatoUnitSymbolSet.buildSizeImage(g, count, type, sym_w, sym_h, gap);
            int xpos = bounds.x + bounds.width / 2 - bi.getWidth() / 2 + gap;
            int ypos = bounds.y - sym_h - 1;
            g.drawImage(bi, xpos, ypos, null);
        }

        public static BufferedImage buildSizeImage(String size, int sym_w, int sym_h, int gap) {
            SizeOption option = NatoUnitSymbolSet.findSize(size);
            String type = option.getType();
            int count = option.getCount();
            BufferedImage bi = NatoUnitSymbolSet.createImage(count, sym_w, sym_h, gap);
            Graphics2D g = bi.createGraphics();
            g.setBackground(null);
            g.setColor(Color.BLACK);
            return NatoUnitSymbolSet.buildSizeImage(g, count, type, sym_w, sym_h, gap);
        }

        protected static BufferedImage createImage(int count, int sym_w, int sym_h, int gap) {
            int w = sym_w * count + gap * (count - 1) + 1;
            if (w < 1) {
                w = sym_w;
            }
            return ImageUtils.createCompatibleTranslucentImage(w, sym_h + 1);
        }

        public static BufferedImage buildSizeImage(Graphics g, int count, String type, int sym_w, int sym_h, int gap) {
            Graphics2D g2 = (Graphics2D)g;
            BufferedImage bi = type.equals(INSTALLATION_SYMBOL) ? NatoUnitSymbolSet.createImage(count, sym_w * 3, sym_h, gap) : NatoUnitSymbolSet.createImage(count, sym_w, sym_h, gap);
            Graphics2D big = bi.createGraphics();
            big.setColor(g2.getColor());
            big.setBackground(null);
            big.setStroke(new BasicStroke(1.0f, 1, 1));
            big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int x_pos = 0;
            for (int i = 0; i < count; ++i) {
                int radius;
                if (type.equals(TEAM_SYMBOL)) {
                    radius = sym_w / 2;
                    big.drawOval(x_pos, sym_h / 3, radius * 2, radius * 2);
                    big.drawLine(x_pos, sym_h, x_pos + sym_w, 0);
                } else if (type.equals(SQUAD_SYMBOL)) {
                    radius = sym_w / 2;
                    big.fillOval(x_pos, sym_h / 3, radius * 2, radius * 2);
                } else if (type.equals(COMPANY_SYMBOL)) {
                    big.drawLine(x_pos + sym_w / 2, 0, x_pos + sym_w / 2, sym_h);
                } else if (type.equals(BRIGADE_SYMBOL)) {
                    big.drawLine(x_pos, 0, x_pos + sym_w, sym_h);
                    big.drawLine(x_pos, sym_h, x_pos + sym_w, 0);
                } else if (type.equals(INSTALLATION_SYMBOL)) {
                    big.fillRect(x_pos, sym_h / 2, x_pos + 3 * sym_w, sym_h);
                }
                x_pos += sym_w + gap;
            }
            big.dispose();
            return bi;
        }

        static {
            SIZES = new SizeOption[]{new SizeOption("None", Resources.getString("Editor.Symbol.Size.none"), 0, NAVY), new SizeOption(SZ_INSTALLATION, Resources.getString("Editor.Symbol.Size.installation"), 1, INSTALLATION_SYMBOL), new SizeOption(SZ_TEAM, Resources.getString("Editor.Symbol.Size.team"), 1, TEAM_SYMBOL), new SizeOption(SZ_SQUAD, Resources.getString("Editor.Symbol.Size.squad"), 1, SQUAD_SYMBOL), new SizeOption(SZ_PLATOON, Resources.getString("Editor.Symbol.Size.section"), 2, SQUAD_SYMBOL), new SizeOption(SZ_SECTION, Resources.getString("Editor.Symbol.Size.platoon"), 3, SQUAD_SYMBOL), new SizeOption(SZ_ECHELON, Resources.getString("Editor.Symbol.Size.echelon"), 4, SQUAD_SYMBOL), new SizeOption(SZ_COMPANY, Resources.getString("Editor.Symbol.Size.company"), 1, COMPANY_SYMBOL), new SizeOption(SZ_BATTALION, Resources.getString("Editor.Symbol.Size.battalion"), 2, COMPANY_SYMBOL), new SizeOption(SZ_REGIMENT, Resources.getString("Editor.Symbol.Size.regiment"), 3, COMPANY_SYMBOL), new SizeOption(SZ_BRIGADE, Resources.getString("Editor.Symbol.Size.brigade"), 1, BRIGADE_SYMBOL), new SizeOption(SZ_DIVISION, Resources.getString("Editor.Symbol.Size.division"), 2, BRIGADE_SYMBOL), new SizeOption(SZ_CORPS, Resources.getString("Editor.Symbol.Size.corps"), 3, BRIGADE_SYMBOL), new SizeOption(SZ_ARMY, Resources.getString("Editor.Symbol.Size.army"), 4, BRIGADE_SYMBOL), new SizeOption(SZ_ARMY_GROUP, Resources.getString("Editor.Symbol.Size.army_group"), 5, BRIGADE_SYMBOL), new SizeOption(SZ_REGION, Resources.getString("Editor.Symbol.Size.region"), 6, BRIGADE_SYMBOL)};
        }
    }

    public static class SizeOption {
        String name;
        String displayName;
        String type;
        int count;

        public SizeOption(String n, String d, int c, String t) {
            this.name = n;
            this.displayName = d;
            this.type = t;
            this.count = c;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getType() {
            return this.type;
        }

        public int getCount() {
            return this.count;
        }
    }
}

