/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.index;

import VASSAL.build.module.Map;
import VASSAL.build.module.index.PiecePropertyIndex;
import VASSAL.build.module.index.VassalMapQuadTree;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.counters.GamePiece;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VassalMapPieceIndex {
    private VassalMapQuadTree qtree;
    private final PiecePropertyIndex zoneIndex;
    private final PiecePropertyIndex locationIndex;
    private final Map map;

    public VassalMapPieceIndex(Map map) {
        this.map = map;
        this.qtree = new VassalMapQuadTree(map);
        this.zoneIndex = new PiecePropertyIndex("CurrentZone");
        this.locationIndex = new PiecePropertyIndex("LocationName");
    }

    public void addOrUpdatePiece(GamePiece piece) {
        Point pos = piece.getPosition();
        if (pos != null) {
            if (!this.qtree.getBounds().contains(pos)) {
                Rectangle bounds = this.qtree.getBounds();
                int minX = Math.min(pos.x - 100, bounds.x);
                int maxX = Math.max(pos.x + 100, bounds.x + bounds.width);
                int minY = Math.min(pos.y - 100, bounds.y);
                int maxY = Math.max(pos.y + 100, bounds.y + bounds.height);
                this.qtree = new VassalMapQuadTree(this.qtree, minX, minY, maxX, maxY);
            }
            this.qtree.addOrUpdatePiece(piece);
        }
        this.zoneIndex.addOrUpdatePiece(piece);
        this.locationIndex.addOrUpdatePiece(piece);
    }

    public void removePiece(GamePiece piece) {
        this.qtree.removePiece(piece);
        this.zoneIndex.removePiece(piece);
        this.locationIndex.removePiece(piece);
    }

    public List<GamePiece> getPieces(GamePiece piece, int range) {
        return this.getPieces(piece, range, false);
    }

    public List<GamePiece> getPieces(GamePiece piece, int range, boolean forceAsPixels) {
        List<GamePiece> pieces = this.getPieces(piece.getPosition(), range, forceAsPixels);
        pieces.remove(piece);
        return pieces;
    }

    public List<GamePiece> getPieces(Point point, int range) {
        return this.getPieces(point, range, false);
    }

    public List<GamePiece> getPieces(Point point, int range, boolean forceAsPixels) {
        int pixelsPerRangeElement = forceAsPixels ? 1 : this.map.getMaxPixelsPerRangeUnit(point);
        List<GamePiece> rawPieces = this.qtree.getPiecesInRange(point, (range + 1) * pixelsPerRangeElement);
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
        for (GamePiece piece : rawPieces) {
            Point pos = piece.getPosition();
            MapGrid grid = this.map.findBoard(pos) == null ? null : this.map.findBoard(pos).getGrid();
            double calculatedRange = grid == null ? Point.distance(point.x, point.y, pos.x, pos.y) : (double)grid.range(point, pos);
            if ((int)Math.floor(calculatedRange + 0.5) > range) continue;
            pieces.add(piece);
        }
        return pieces;
    }

    public Set<GamePiece> getPieces(String propertyName, String propertyValue) {
        if ("CurrentZone".equals(propertyName)) {
            return this.zoneIndex.getPieces(propertyValue);
        }
        if ("LocationName".equals(propertyName)) {
            return this.locationIndex.getPieces(propertyValue);
        }
        return new HashSet<GamePiece>();
    }
}

