/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.index;

import VASSAL.build.module.Map;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.counters.GamePiece;
import VASSAL.tools.qtree.QFunc;
import VASSAL.tools.qtree.QNode;
import VASSAL.tools.qtree.QPoint;
import VASSAL.tools.qtree.QuadTree;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VassalMapQuadTree
extends QuadTree {
    private final Rectangle bounds;
    java.util.Map<String, Point> pieces = new HashMap<String, Point>();

    public VassalMapQuadTree(Map map) {
        int minX = 9999999;
        int minY = 9999999;
        int maxX = 0;
        int maxY = 0;
        for (Board b : map.getBoards()) {
            Rectangle bounds = b.bounds();
            if (bounds.x < minX) {
                minX = bounds.x;
            }
            if (bounds.y < minY) {
                minY = bounds.y;
            }
            if (bounds.x + bounds.width > maxX) {
                maxX = bounds.x + bounds.width;
            }
            if (bounds.y + bounds.height <= maxY) continue;
            maxY = bounds.y + bounds.height;
        }
        Dimension d = map.getEdgeBuffer();
        this.setRootNode(new QNode(minX -= d.width + 100, minY -= d.height + 100, (maxX += d.width + 100) - minX, (maxY += d.height + 100) - minY, null));
        this.bounds = new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public VassalMapQuadTree(VassalMapQuadTree qtree, int x1, int y1, int x2, int y2) {
        this.setRootNode(new QNode(x1, y1, x2 - x1, y2 - y1, null));
        this.bounds = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        this.traverse(qtree.getRootNode(), new QFunc(){

            public void call(QuadTree quadTree, QNode node) {
                VassalMapQuadTree.this.set(node.getPoint().getX(), node.getPoint().getY(), node.getPoint().getValue());
            }
        });
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void addOrUpdatePiece(GamePiece p) {
        Point lastLocation = this.pieces.get(p.getId());
        Point currentLocation = p.getPosition();
        if (lastLocation != null && lastLocation.equals(currentLocation)) {
            return;
        }
        if (lastLocation != null) {
            this.removePiece(p);
        }
        if (currentLocation != null && this.bounds.contains(currentLocation)) {
            Set nodePieces = this.get(currentLocation.x, currentLocation.y, new HashSet());
            if (!nodePieces.contains(p)) {
                nodePieces.add(p);
                this.set(currentLocation.x, currentLocation.y, nodePieces);
            }
            this.pieces.put(p.getId(), currentLocation);
        }
    }

    public void removePiece(GamePiece p) {
        Set nodePieces;
        Point lastLocation = this.pieces.remove(p.getId());
        if (lastLocation != null && (nodePieces = (Set)this.get(lastLocation.x, lastLocation.y, null)) != null) {
            nodePieces.remove(p);
            this.set(lastLocation.x, lastLocation.y, nodePieces);
        }
    }

    public List<GamePiece> getPiecesInRange(Point pos, int range) {
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
        for (QPoint q : this.searchWithin(pos.x - range, pos.y - range, pos.x + range, pos.y + range)) {
            pieces.addAll((Set)q.getValue());
        }
        return pieces;
    }
}

