/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.FormattedStringExpression;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class EnumeratedPropertyPrompt
extends PropertyPrompt {
    protected String[] validValues;
    protected Expression[] valueExpressions;
    protected PropertyPrompt.DialogParent dialogParent;

    public EnumeratedPropertyPrompt(PropertyPrompt.DialogParent dialogParent, String prompt, String[] validValues, PropertyPrompt.Constraints propertySource) {
        super(propertySource, prompt);
        this.validValues = validValues;
        this.valueExpressions = new Expression[validValues.length];
        for (int i = 0; i < validValues.length; ++i) {
            String updatedExpression = new FormattedStringExpression(validValues[i]).tryEvaluate((PropertySource)((Object)propertySource), (Auditable)((Object)propertySource), AuditTrail.create((Auditable)((Object)propertySource), validValues[i]));
            this.valueExpressions[i] = Expression.createExpression(updatedExpression);
        }
        this.dialogParent = dialogParent;
    }

    public Expression[] getValueExpressions() {
        return this.valueExpressions;
    }

    @Override
    public String getNewValue(String oldValue) {
        String[] finalValues = new String[this.valueExpressions.length];
        for (int i = 0; i < finalValues.length; ++i) {
            String value;
            try {
                AuditTrail audit = AuditTrail.create((Auditable)(this.constraints == null ? null : this.constraints.getPropertySource()), this.valueExpressions[i].getExpression());
                value = this.constraints == null ? this.valueExpressions[i].evaluate((PropertySource)GameModule.getGameModule(), null, audit) : this.valueExpressions[i].evaluate(this.constraints.getPropertySource(), this.constraints.getPropertySource(), audit);
            }
            catch (ExpressionException e) {
                value = this.valueExpressions[i].getExpression();
            }
            finalValues[i] = value;
        }
        boolean purgeBlanks = GlobalOptions.getInstance().isPurgeBlankPropertyPrompts();
        ArrayList<String> nonBlankValues = new ArrayList<String>();
        for (String value : finalValues) {
            if (purgeBlanks && value.isEmpty()) continue;
            nonBlankValues.add(value);
        }
        if (nonBlankValues.isEmpty()) {
            return oldValue;
        }
        return (String)JOptionPane.showInputDialog(this.dialogParent.getComponent(), this.promptText, null, 3, null, nonBlankValues.toArray(new String[0]), oldValue);
    }

    public String[] getValidValues() {
        return this.validValues;
    }
}

