/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class HintTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private String hint;
    private Color hintColor;
    private Font hintFont;
    private boolean focusOnly;

    public HintTextField(int length, String hint) {
        super(length);
        this.setHint(hint);
        this.setFocusOnly(false);
        this.addFocusListener(this);
    }

    public HintTextField(String hint) {
        this.setHint(hint);
        this.setFocusOnly(false);
        this.addFocusListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.getText().isEmpty() && this.focusCheck() && this.hint != null && !this.hint.isEmpty()) {
            int h = this.getHeight();
            ((Graphics2D)g).addRenderingHints(SwingUtils.FONT_HINTS);
            Insets ins = this.getInsets();
            FontMetrics fm = g.getFontMetrics();
            if (this.hintColor == null) {
                int c0 = this.getBackground().getRGB();
                int c1 = this.getForeground().getRGB();
                int m = -16843010;
                int c2 = ((c0 & 0xFEFEFEFE) >>> 1) + ((c1 & 0xFEFEFEFE) >>> 1);
                this.hintColor = new Color(c2, true);
                this.hintFont = new Font(this.getFont().getFontName(), 2, this.getFont().getSize());
            }
            g.setColor(this.hintColor);
            g.setFont(this.hintFont);
            g.drawString(this.hint, ins.left, h / 2 + fm.getAscent() / 2 - 2);
        }
    }

    protected boolean focusCheck() {
        return !this.isFocusOnly() || this.hasFocus();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public boolean isFocusOnly() {
        return this.focusOnly;
    }

    public void setFocusOnly(boolean focusOnly) {
        this.focusOnly = focusOnly;
        this.repaint();
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.repaint();
    }
}

