/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameState;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.GlobalCommandTargetConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalAttach;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.counters.GlobalDetach;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.RangeFilter;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class Attachment
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "attach;";
    public static final String ATTACH_NAME = "AttachName";
    public static final String ATTACH_LIST = "AttachList";
    public static final String ATTACH_COUNT = "AttachCount";
    public static final String BEFORE_ATTACH_NOTHING = "nothing";
    public static final String BEFORE_ATTACH_CLEAR = "clear";
    protected static final String[] BEFORE_ATTACH_OPTIONS = new String[]{"nothing", "clear"};
    protected static final String[] BEFORE_ATTACH_KEYS = new String[]{"Editor.Attachment.leave_existing", "Editor.Attachment.clear_existing"};
    public static final String ON_ATTACH_NOTHING = "nothing";
    public static final String ON_ATTACH_FOLLOW_BACK = "follow";
    public static final String ON_ATTACH_ATTACH_ALL = "attachAll";
    protected static final String[] ON_ATTACH_OPTIONS = new String[]{"nothing", "follow", "attachAll"};
    protected static final String[] ON_ATTACH_KEYS = new String[]{"Editor.Attachment.no_additional_action", "Editor.Attachment.follow_back", "Editor.Attachment.attach_to_all"};
    public static final String ON_DETACH_NOTHING = "nothing";
    public static final String ON_DETACH_REMOVE = "remove";
    protected static final String[] ON_DETACH_OPTIONS = new String[]{"nothing", "remove"};
    protected static final String[] ON_DETACH_KEYS = new String[]{"Editor.Attachment.no_additional_action", "Editor.Attachment.remove_incoming_attachment"};
    protected String attachName;
    protected String desc;
    protected List<GamePiece> contents = new ArrayList<GamePiece>();
    protected GlobalCommandTarget target = new GlobalCommandTarget(GlobalCommandTarget.GKCtype.COUNTER);
    protected GlobalCommandTarget clearTarget = new GlobalCommandTarget(GlobalCommandTarget.GKCtype.COUNTER);
    protected KeyCommand[] command;
    protected String attachCommandName;
    protected NamedKeyStroke attachKey;
    protected GlobalAttach globalAttach = new GlobalAttach(this);
    protected PropertyExpression propertiesFilter = new PropertyExpression();
    protected boolean restrictRange;
    protected boolean fixedRange = true;
    protected int range;
    protected String rangeProperty = "";
    protected String clearAllCommandName;
    protected NamedKeyStroke clearAllKey;
    protected String clearMatchingCommandName;
    protected NamedKeyStroke clearMatchingKey;
    protected PropertyExpression clearMatchingFilter = new PropertyExpression();
    protected String onAttach = "nothing";
    protected String onDetach = "nothing";
    protected String beforeAttach = "clear";
    protected boolean allowSelfAttach = false;
    protected boolean autoAttach = true;
    private KeyCommand myAttachCommand;
    private KeyCommand myClearAllCommand;
    private KeyCommand myClearMatchingCommand;
    private String attachCountName = "";
    private final GlobalDetach globalDetach = new GlobalDetach(this);

    public Attachment() {
        this("attach;;", null);
    }

    public Attachment(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    public boolean isAutoAttach() {
        return this.autoAttach;
    }

    public boolean isAllowSelfAttach() {
        return this.allowSelfAttach;
    }

    public static List<GamePiece> getAttachList(GamePiece piece, String attachmentName) {
        GamePiece p = Decorator.getOutermost(piece);
        while (p instanceof Decorator) {
            Attachment a;
            if (p instanceof Attachment && (a = (Attachment)p).getAttachName().equals(attachmentName)) {
                return a.getAttachList();
            }
            p = ((Decorator)p).getInner();
        }
        return Collections.emptyList();
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.setAttachName(st.nextToken());
        this.desc = st.nextToken();
        this.attachCommandName = st.nextToken(Resources.getString("Editor.Attachment.attach_command"));
        this.attachKey = st.nextNamedKeyStroke(null);
        this.clearAllCommandName = st.nextToken(Resources.getString("Editor.Attachment.clear_all_command"));
        this.clearAllKey = st.nextNamedKeyStroke(null);
        this.propertiesFilter.setExpression(st.nextToken(""));
        this.restrictRange = st.nextBoolean(false);
        this.range = st.nextInt(1);
        this.fixedRange = st.nextBoolean(true);
        this.rangeProperty = st.nextToken("");
        this.globalAttach.setSelectFromDeckExpression(st.nextToken("-1"));
        this.target.decode(st.nextToken(""));
        this.target.setGKCtype(GlobalCommandTarget.GKCtype.COUNTER);
        this.target.setCurPiece(this);
        this.clearMatchingCommandName = st.nextToken(Resources.getString("Editor.Attachment.clear_matching_command"));
        this.clearMatchingKey = st.nextNamedKeyStroke(null);
        this.clearMatchingFilter.setExpression(st.nextToken(""));
        this.onAttach = st.nextToken("nothing");
        this.onDetach = st.nextToken("nothing");
        this.beforeAttach = st.nextToken(BEFORE_ATTACH_CLEAR);
        this.allowSelfAttach = st.nextBoolean(false);
        this.autoAttach = st.nextBoolean(true);
        this.command = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.attachName).append(this.desc).append(this.attachCommandName).append(this.attachKey).append(this.clearAllCommandName).append(this.clearAllKey).append(this.propertiesFilter).append(this.restrictRange).append(this.range).append(this.fixedRange).append(this.rangeProperty).append(this.globalAttach.getSelectFromDeckExpression()).append(this.target.encode()).append(this.clearMatchingCommandName).append(this.clearMatchingKey).append(this.clearMatchingFilter).append(this.onAttach).append(this.onDetach).append(this.beforeAttach).append(this.allowSelfAttach).append(this.autoAttach);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.autoAttach) {
            return KeyCommand.NONE;
        }
        if (this.command == null) {
            boolean doClearMatching;
            this.myAttachCommand = new KeyCommand(this.attachCommandName, this.attachKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.myClearAllCommand = new KeyCommand(this.clearAllCommandName, this.clearAllKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.myClearMatchingCommand = new KeyCommand(this.clearMatchingCommandName, this.clearMatchingKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            boolean doAttach = this.attachCommandName.length() > 0 && this.attachKey != null && !this.attachKey.isNull();
            boolean doClearAll = this.clearAllCommandName.length() > 0 && this.clearAllKey != null && !this.clearAllKey.isNull();
            boolean bl = doClearMatching = this.clearMatchingCommandName.length() > 0 && this.clearMatchingKey != null && !this.clearMatchingKey.isNull();
            this.command = doAttach ? (doClearAll ? (doClearMatching ? new KeyCommand[]{this.myAttachCommand, this.myClearMatchingCommand, this.myClearAllCommand} : new KeyCommand[]{this.myAttachCommand, this.myClearAllCommand}) : (doClearMatching ? new KeyCommand[]{this.myAttachCommand, this.myClearMatchingCommand} : new KeyCommand[]{this.myAttachCommand})) : (doClearAll ? (doClearMatching ? new KeyCommand[]{this.myClearMatchingCommand, this.myClearAllCommand} : new KeyCommand[]{this.myClearAllCommand}) : (doClearMatching ? new KeyCommand[]{this.myClearMatchingCommand} : KeyCommand.NONE));
        }
        for (KeyCommand c : this.command) {
            c.setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.contents.size());
        for (GamePiece p : this.contents) {
            se.append(p.getId());
        }
        return se.getValue();
    }

    public Command attach() {
        Command c = new NullCommand();
        if (BEFORE_ATTACH_CLEAR.equals(this.beforeAttach)) {
            c = c.append(this.clearAll());
        }
        GamePiece outer = Decorator.getOutermost(this);
        this.globalAttach.setPropertySource(outer);
        AuditTrail audit = AuditTrail.create((Auditable)this, this.propertiesFilter.getExpression(), Resources.getString("Editor.GlobalKeyCommand.matching_properties"));
        PieceFilter filter = this.propertiesFilter.getFilter((PropertySource)outer, (Auditable)this, audit);
        if (this.restrictRange) {
            int r = this.range;
            if (!this.fixedRange) {
                String rangeValue = (String)Decorator.getOutermost(this).getProperty(this.rangeProperty);
                try {
                    r = Integer.parseInt(rangeValue);
                }
                catch (NumberFormatException e) {
                    Attachment.reportDataError(this, Resources.getString("Error.non_number_error"), "range[" + this.rangeProperty + "]=" + rangeValue, e);
                }
            }
            filter = new BooleanAndPieceFilter(filter, new RangeFilter(this.getMap(), this.getPosition(), r));
        }
        c = c.append(this.globalAttach.apply(Map.getMapList().toArray(new Map[0]), filter, this.target, audit));
        return c;
    }

    public Command clearAll() {
        Command c = new NullCommand();
        if (this.isAutoAttach()) {
            this.contents.clear();
            return c;
        }
        if (this.contents.isEmpty()) {
            return c;
        }
        List<GamePiece> targets = this.getAttachList();
        for (GamePiece target : targets) {
            c = c.append(this.makeRemoveTargetCommand(target));
        }
        ChangeTracker ct = new ChangeTracker(this);
        this.contents.clear();
        c = c.append(ct.getChangeCommand());
        return c;
    }

    public Command clearMatching() {
        GamePiece outer = Decorator.getOutermost(this);
        this.clearTarget.fastMatchLocation = true;
        this.clearTarget.fastMatchProperty = false;
        this.clearTarget.setTargetType(GlobalCommandTarget.Target.CURATTACH);
        this.clearTarget.setCurPiece(this);
        this.globalDetach.setPropertySource(outer);
        AuditTrail audit = AuditTrail.create((Auditable)this, this.clearMatchingFilter.getExpression(), Resources.getString("Editor.GlobalKeyCommand.matching_properties"));
        PieceFilter filter = this.clearMatchingFilter.getFilter((PropertySource)outer, (Auditable)this, audit);
        return this.globalDetach.apply(Map.getMapList().toArray(new Map[0]), filter, this.clearTarget, audit);
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.autoAttach) {
            return null;
        }
        if (this.myAttachCommand.matches(stroke)) {
            return this.attach();
        }
        if (this.myClearAllCommand.matches(stroke)) {
            return this.clearAll();
        }
        if (this.myClearMatchingCommand.matches(stroke)) {
            return this.clearMatching();
        }
        return null;
    }

    public List<GamePiece> getContents() {
        return new ArrayList<GamePiece>(this.contents);
    }

    public void setContents(List<GamePiece> newContents) {
        this.contents = newContents;
    }

    @Override
    public void mySetState(String newState) {
        this.contents.clear();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(newState, ';');
        int num = st.nextInt(0);
        GameState gs = GameModule.getGameModule().getGameState();
        for (int i = 0; i < num; ++i) {
            GamePiece piece = gs.getPieceForId(st.nextToken());
            if (piece == null) continue;
            this.contents.add(piece);
        }
    }

    public void autoAttach(Attachment attach) {
        GamePiece piece;
        if (this.isAutoAttach() && attach.getAttachName().equals(this.getAttachName()) && !this.hasTarget(piece = Decorator.getOutermost(attach))) {
            this.contents.add(piece);
        }
    }

    public boolean hasTarget(GamePiece p) {
        return this.contents.contains(p);
    }

    public Command makeAddTargetCommand(GamePiece p) {
        Command c = new NullCommand();
        if (!this.allowSelfAttach && Decorator.getOutermost(this).equals(Decorator.getOutermost(p))) {
            return c;
        }
        if (!this.hasTarget(p)) {
            ChangeTracker ct = new ChangeTracker(this);
            this.contents.add(p);
            c = c.append(ct.getChangeCommand());
            GamePiece target = Decorator.getOutermost(p);
            while (target instanceof Decorator) {
                if (target instanceof Attachment) {
                    Attachment targetAttach = (Attachment)target;
                    if (this.attachName.equals(targetAttach.attachName) && (this.autoAttach || !targetAttach.onAttach.equals("nothing"))) {
                        c = c.append(targetAttach.makeAddTargetCommand(Decorator.getOutermost(this)));
                        if (this.autoAttach || targetAttach.onAttach.equals(ON_ATTACH_ATTACH_ALL)) {
                            for (GamePiece other : this.getAttachList()) {
                                c = c.append(targetAttach.makeAddTargetCommand(Decorator.getOutermost(other)));
                            }
                        }
                    }
                }
                target = ((Decorator)target).getInner();
            }
        }
        return c;
    }

    public void removeTarget(GamePiece p) {
        if (p instanceof Decorator && this.hasTarget(p)) {
            this.contents.remove(p);
        }
    }

    public Command makeRemoveTargetCommand(GamePiece p) {
        Command c = new NullCommand();
        if (this.hasTarget(p)) {
            ChangeTracker ct = new ChangeTracker(this);
            this.removeTarget(p);
            c = c.append(ct.getChangeCommand());
            if (this.onDetach.equals(ON_DETACH_REMOVE)) {
                GamePiece target = Decorator.getOutermost(p);
                while (target instanceof Decorator) {
                    if (target instanceof Attachment) {
                        Attachment targetAttach = (Attachment)target;
                        if (this.attachName.equals(targetAttach.attachName)) {
                            c = c.append(targetAttach.makeRemoveTargetCommand(Decorator.getOutermost(this)));
                        }
                    }
                    target = ((Decorator)target).getInner();
                }
            }
        }
        return c;
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object d = Resources.getString("Editor.Attachment.trait_description");
        d = (String)d + " - " + this.attachName;
        if (this.autoAttach) {
            d = (String)d + " " + Resources.getString("Editor.Attachment.auto");
        }
        if (this.desc.length() > 0) {
            d = (String)d + " - " + this.desc;
        }
        if (!this.autoAttach) {
            if (this.attachKey != null) {
                d = (String)d + this.getCommandDesc(this.attachCommandName, this.attachKey);
            }
            if (this.clearAllKey != null) {
                d = (String)d + this.getCommandDesc(this.clearAllCommandName, this.clearAllKey);
            }
            if (this.clearMatchingKey != null) {
                d = (String)d + this.getCommandDesc(this.clearMatchingCommandName, this.clearMatchingKey);
            }
        }
        return d;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Attachment.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.desc;
    }

    public GamePiece getPropertyPiece() {
        if (this.contents.isEmpty()) {
            return null;
        }
        for (GamePiece piece : this.contents) {
            if (piece.getMap() == null) continue;
            return piece;
        }
        return null;
    }

    public String translatePropertyName(Object key) {
        String k;
        if (!this.attachName.isEmpty() && key instanceof String && !this.contents.isEmpty() && (k = (String)key).length() > this.attachName.length() + 1 && k.startsWith(this.attachName) && k.charAt(this.attachName.length()) == '_') {
            return k.substring(this.attachName.length() + 1);
        }
        return null;
    }

    public String getAttachName() {
        return this.attachName;
    }

    void setAttachName(String name) {
        this.attachName = name;
        this.attachCountName = name + "_AttachCount";
    }

    public int getAttachCount() {
        int count = 0;
        for (GamePiece piece : this.contents) {
            if (piece.getMap() == null) continue;
            ++count;
        }
        return count;
    }

    public GamePiece getAttachedPieceAt(int index) {
        int count = 0;
        for (GamePiece piece : this.contents) {
            if (piece.getMap() == null) continue;
            if (count == index) {
                return piece;
            }
            ++count;
        }
        return null;
    }

    public List<GamePiece> getAttachList() {
        ArrayList<GamePiece> attachList = new ArrayList<GamePiece>();
        for (GamePiece p : this.contents) {
            if (p.getMap() == null) continue;
            attachList.add(p);
        }
        return attachList;
    }

    @Override
    public Object getProperty(Object key) {
        Object getIt;
        GamePiece propPiece;
        if (ATTACH_NAME.equals(key)) {
            return this.attachName;
        }
        if (ATTACH_LIST.equals(key)) {
            return this.getAttachList();
        }
        if (this.attachCountName.equals(key) || ATTACH_COUNT.equals(key)) {
            return String.valueOf(this.getAttachCount());
        }
        String attachProp = this.translatePropertyName(key);
        if (attachProp != null && (propPiece = this.getPropertyPiece()) != null && (getIt = propPiece.getProperty(attachProp)) != null) {
            return getIt;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        Object getIt;
        GamePiece propPiece;
        if (ATTACH_NAME.equals(key)) {
            return this.attachName;
        }
        if (this.attachCountName.equals(key) || ATTACH_COUNT.equals(key)) {
            return String.valueOf(this.getAttachCount());
        }
        String attachProp = this.translatePropertyName(key);
        if (attachProp != null && (propPiece = this.getPropertyPiece()) != null && (getIt = propPiece.getLocalizedProperty(attachProp)) != null) {
            return getIt;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (ATTACH_NAME.equals(key)) {
            this.setAttachName((String)value);
            return;
        }
        super.setProperty(key, value);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment c = (Attachment)o;
        if (!Objects.equals(this.attachName, c.attachName)) {
            return false;
        }
        if (!Objects.equals(this.desc, c.desc)) {
            return false;
        }
        if (!Objects.equals(this.attachCommandName, c.attachCommandName)) {
            return false;
        }
        if (!Objects.equals(this.attachKey, c.attachKey)) {
            return false;
        }
        if (!Objects.equals(this.clearAllCommandName, c.clearAllCommandName)) {
            return false;
        }
        if (!Objects.equals(this.clearAllKey, c.clearAllKey)) {
            return false;
        }
        if (!Objects.equals(this.propertiesFilter.getExpression(), c.propertiesFilter.getExpression())) {
            return false;
        }
        if (!Objects.equals(this.restrictRange, c.restrictRange)) {
            return false;
        }
        if (!Objects.equals(this.range, c.range)) {
            return false;
        }
        if (!Objects.equals(this.fixedRange, c.fixedRange)) {
            return false;
        }
        if (!Objects.equals(this.rangeProperty, c.rangeProperty)) {
            return false;
        }
        if (!Objects.equals(this.target, c.target)) {
            return false;
        }
        if (!Objects.equals(this.globalAttach.getSelectFromDeckExpression(), c.globalAttach.getSelectFromDeckExpression())) {
            return false;
        }
        if (!Objects.equals(this.clearMatchingCommandName, c.clearMatchingCommandName)) {
            return false;
        }
        if (!Objects.equals(this.clearMatchingKey, c.clearMatchingKey)) {
            return false;
        }
        if (!Objects.equals(this.clearMatchingFilter.getExpression(), c.clearMatchingFilter.getExpression())) {
            return false;
        }
        if (!Objects.equals(this.onAttach, c.onAttach)) {
            return false;
        }
        if (!Objects.equals(this.onDetach, c.onDetach)) {
            return false;
        }
        if (!Objects.equals(this.beforeAttach, c.beforeAttach)) {
            return false;
        }
        if (!Objects.equals(this.autoAttach, c.autoAttach)) {
            return false;
        }
        return Objects.equals(this.allowSelfAttach, c.allowSelfAttach);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Attachment.html");
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(ATTACH_COUNT);
        l.add(this.attachCountName);
        return l;
    }

    @Override
    public List<String> getExpressionList() {
        List<String> expList = this.target.getExpressionList();
        expList.add(this.propertiesFilter.getExpression());
        expList.add(this.clearMatchingFilter.getExpression());
        return expList;
    }

    @Override
    public List<String> getMenuTextList() {
        return Arrays.asList(this.attachCommandName, this.clearAllCommandName, this.clearMatchingCommandName);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.attachKey, this.clearAllKey, this.clearMatchingKey);
    }

    @Override
    public List<String> getPropertyList() {
        return Arrays.asList(this.attachName, this.rangeProperty);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer attachNameInput;
        private final StringConfigurer descInput;
        private final TraitConfigPanel traitPanel;
        private final StringConfigurer attachCommandNameInput;
        protected NamedHotKeyConfigurer attachKeyInput;
        private final StringConfigurer clearAllCommandNameInput;
        protected NamedHotKeyConfigurer clearAllKeyInput;
        private final StringConfigurer clearMatchingCommandNameInput;
        protected NamedHotKeyConfigurer clearMatchingKeyInput;
        protected PropertyExpressionConfigurer propertyMatch;
        protected PropertyExpressionConfigurer clearMatchingMatch;
        protected MassKeyCommand.DeckPolicyConfig deckPolicy;
        protected BooleanConfigurer restrictRange;
        protected BooleanConfigurer fixedRange;
        protected JLabel fixedRangeLabel;
        protected IntConfigurer range;
        protected JLabel rangeLabel;
        protected StringConfigurer rangeProperty;
        protected JLabel rangePropertyLabel;
        protected GlobalCommandTargetConfigurer targetConfig;
        protected TranslatingStringEnumConfigurer onAttachInput;
        protected TranslatingStringEnumConfigurer onDetachInput;
        protected TranslatingStringEnumConfigurer beforeAttachInput;
        protected BooleanConfigurer allowSelfAttachInput;
        protected BooleanConfigurer autoAttachInput;
        protected JLabel beforeAttachLabel;
        protected JLabel onAttachLabel;
        protected JLabel attachCommandNameLabel;
        protected JLabel attachKeyLabel;
        protected JLabel targetLabel;
        protected JLabel propertyLabel;
        protected JLabel deckLabel;
        protected JLabel restrictLabel;
        protected JLabel onDetachLabel;
        protected JLabel clearAllCommandNameLabel;
        protected JLabel clearAllKeyLabel;
        protected JLabel clearMatchingKeyLabel;
        protected JLabel clearMatchingCommandNameLabel;
        protected JLabel clearMatchingMatchLabel;
        protected Attachment attachment;

        public Ed(Attachment p) {
            this.attachment = p;
            this.traitPanel = new TraitConfigPanel();
            this.attachNameInput = new StringConfigurer(p.attachName);
            this.attachNameInput.setHintKey("Editor.Attachment.name_hint");
            this.traitPanel.add("Editor.Attachment.name_label", (Configurer)this.attachNameInput);
            this.descInput = new StringConfigurer(p.desc);
            this.descInput.setHintKey("Editor.description_hint");
            this.traitPanel.add("Editor.description_label", (Configurer)this.descInput);
            this.autoAttachInput = new BooleanConfigurer(p.autoAttach);
            this.traitPanel.add("Editor.Attachment.auto_attach", (Configurer)this.autoAttachInput);
            this.allowSelfAttachInput = new BooleanConfigurer(p.allowSelfAttach);
            this.traitPanel.add("Editor.Attachment.allow_self_attach", (Configurer)this.allowSelfAttachInput);
            this.beforeAttachInput = new TranslatingStringEnumConfigurer(BEFORE_ATTACH_OPTIONS, BEFORE_ATTACH_KEYS);
            this.beforeAttachInput.setValue(Attachment.BEFORE_ATTACH_CLEAR);
            for (String option : BEFORE_ATTACH_OPTIONS) {
                if (!option.equals(p.beforeAttach)) continue;
                this.beforeAttachInput.setValue(option);
            }
            this.beforeAttachLabel = new JLabel(Resources.getString("Editor.Attachment.before_attach"));
            this.traitPanel.add(this.beforeAttachLabel, (Configurer)this.beforeAttachInput);
            this.onAttachInput = new TranslatingStringEnumConfigurer(ON_ATTACH_OPTIONS, ON_ATTACH_KEYS);
            this.onAttachInput.setValue("nothing");
            for (String option : ON_ATTACH_OPTIONS) {
                if (!option.equals(p.onAttach)) continue;
                this.onAttachInput.setValue(option);
            }
            this.onAttachLabel = new JLabel(Resources.getString("Editor.Attachment.on_attach"));
            this.traitPanel.add(this.onAttachLabel, (Configurer)this.onAttachInput);
            this.attachCommandNameInput = new StringConfigurer(p.attachCommandName);
            this.attachCommandNameInput.setHintKey("Editor.menu_command_hint");
            this.attachCommandNameLabel = new JLabel(Resources.getString("Editor.Attachment.attach_menu_command"));
            this.traitPanel.add(this.attachCommandNameLabel, (Configurer)this.attachCommandNameInput);
            this.attachKeyInput = new NamedHotKeyConfigurer(p.attachKey);
            this.attachKeyLabel = new JLabel(Resources.getString("Editor.Attachment.attach_key_command"));
            this.traitPanel.add(this.attachKeyLabel, (Configurer)this.attachKeyInput);
            this.targetConfig = new GlobalCommandTargetConfigurer(p.target, p);
            this.targetLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.pre_select"));
            this.traitPanel.add(this.targetLabel, (Configurer)this.targetConfig);
            this.propertyMatch = new PropertyExpressionConfigurer(p.propertiesFilter, (GamePiece)p);
            this.propertyLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.matching_properties"));
            this.traitPanel.add(this.propertyLabel, (Configurer)this.propertyMatch);
            this.deckPolicy = new MassKeyCommand.DeckPolicyConfig(false, p);
            this.deckPolicy.setValue(p.globalAttach.getSelectFromDeckExpression());
            this.deckLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.deck_policy"));
            this.traitPanel.add(this.deckLabel, (Configurer)this.deckPolicy);
            this.restrictRange = new BooleanConfigurer(p.restrictRange);
            this.restrictLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.restrict_range"));
            this.traitPanel.add(this.restrictLabel, (Configurer)this.restrictRange);
            this.fixedRange = new BooleanConfigurer(p.fixedRange);
            this.fixedRangeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.fixed_range"));
            this.traitPanel.add(this.fixedRangeLabel, (Configurer)this.fixedRange);
            this.range = new IntConfigurer(p.range);
            this.rangeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.range"));
            this.traitPanel.add(this.rangeLabel, (Configurer)this.range);
            this.rangeProperty = new StringConfigurer(p.rangeProperty);
            this.rangeProperty.setHintKey("Editor.GlobalKeyCommand.range_property_hint");
            this.rangePropertyLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.range_property"));
            this.traitPanel.add(this.rangePropertyLabel, (Configurer)this.rangeProperty);
            this.onDetachInput = new TranslatingStringEnumConfigurer(ON_DETACH_OPTIONS, ON_DETACH_KEYS);
            this.onDetachInput.setValue("nothing");
            for (String option : ON_DETACH_OPTIONS) {
                if (!option.equals(p.onDetach)) continue;
                this.onDetachInput.setValue(option);
            }
            this.onDetachLabel = new JLabel(Resources.getString("Editor.Attachment.on_detach"));
            this.traitPanel.add(this.onDetachLabel, (Configurer)this.onDetachInput);
            this.clearAllCommandNameInput = new StringConfigurer(p.clearAllCommandName);
            this.clearAllCommandNameInput.setHintKey("Editor.menu_command_hint");
            this.clearAllCommandNameLabel = new JLabel(Resources.getString("Editor.Attachment.clear_all_menu_command"));
            this.traitPanel.add(this.clearAllCommandNameLabel, (Configurer)this.clearAllCommandNameInput);
            this.clearAllKeyInput = new NamedHotKeyConfigurer(p.clearAllKey);
            this.clearAllKeyLabel = new JLabel(Resources.getString("Editor.Attachment.clear_all_key_command"));
            this.traitPanel.add(this.clearAllKeyLabel, (Configurer)this.clearAllKeyInput);
            this.clearMatchingCommandNameInput = new StringConfigurer(p.clearMatchingCommandName);
            this.clearMatchingCommandNameInput.setHintKey("Editor.menu_command_hint");
            this.clearMatchingCommandNameLabel = new JLabel(Resources.getString("Editor.Attachment.clear_matching_menu_command"));
            this.traitPanel.add(this.clearMatchingCommandNameLabel, (Configurer)this.clearMatchingCommandNameInput);
            this.clearMatchingKeyInput = new NamedHotKeyConfigurer(p.clearMatchingKey);
            this.clearMatchingKeyLabel = new JLabel(Resources.getString("Editor.Attachment.clear_matching_key_command"));
            this.traitPanel.add(this.clearMatchingKeyLabel, (Configurer)this.clearMatchingKeyInput);
            this.clearMatchingMatch = new PropertyExpressionConfigurer(p.clearMatchingFilter, (GamePiece)p);
            this.clearMatchingMatchLabel = new JLabel(Resources.getString("Editor.Attachment.clear_matching_properties"));
            this.traitPanel.add(this.clearMatchingMatchLabel, (Configurer)this.clearMatchingMatch);
            PropertyChangeListener pl = evt -> {
                boolean isAuto = Boolean.TRUE.equals(this.autoAttachInput.getValue());
                boolean isRange = Boolean.TRUE.equals(this.restrictRange.getValue());
                boolean isFixed = Boolean.TRUE.equals(this.fixedRange.getValue());
                this.range.getControls().setVisible(isRange && isFixed && !isAuto);
                this.rangeLabel.setVisible(isRange && isFixed && !isAuto);
                this.fixedRange.getControls().setVisible(isRange && !isAuto);
                this.fixedRangeLabel.setVisible(isRange && !isAuto);
                this.rangeProperty.getControls().setVisible(isRange && !isFixed && !isAuto);
                this.rangePropertyLabel.setVisible(isRange && !isFixed && !isAuto);
                this.beforeAttachInput.getControls().setVisible(!isAuto);
                this.onAttachInput.getControls().setVisible(!isAuto);
                this.attachCommandNameInput.getControls().setVisible(!isAuto);
                this.attachKeyInput.getControls().setVisible(!isAuto);
                this.targetConfig.getControls().setVisible(!isAuto);
                this.propertyMatch.getControls().setVisible(!isAuto);
                this.deckPolicy.getControls().setVisible(!isAuto);
                this.restrictRange.getControls().setVisible(!isAuto);
                this.onDetachInput.getControls().setVisible(!isAuto);
                this.clearAllCommandNameInput.getControls().setVisible(!isAuto);
                this.clearAllKeyInput.getControls().setVisible(!isAuto);
                this.clearMatchingCommandNameInput.getControls().setVisible(!isAuto);
                this.clearMatchingKeyInput.getControls().setVisible(!isAuto);
                this.clearMatchingMatch.getControls().setVisible(!isAuto);
                this.beforeAttachLabel.setVisible(!isAuto);
                this.onAttachLabel.setVisible(!isAuto);
                this.attachCommandNameLabel.setVisible(!isAuto);
                this.attachKeyLabel.setVisible(!isAuto);
                this.targetLabel.setVisible(!isAuto);
                this.propertyLabel.setVisible(!isAuto);
                this.deckLabel.setVisible(!isAuto);
                this.restrictLabel.setVisible(!isAuto);
                this.onDetachLabel.setVisible(!isAuto);
                this.clearAllCommandNameLabel.setVisible(!isAuto);
                this.clearAllKeyLabel.setVisible(!isAuto);
                this.clearMatchingCommandNameLabel.setVisible(!isAuto);
                this.clearMatchingKeyLabel.setVisible(!isAuto);
                this.clearMatchingMatchLabel.setVisible(!isAuto);
                Decorator.repack(this.range);
                Decorator.repack(this.autoAttachInput);
            };
            this.autoAttachInput.addPropertyChangeListener(pl);
            this.restrictRange.addPropertyChangeListener(pl);
            this.fixedRange.addPropertyChangeListener(pl);
            pl.propertyChange(null);
        }

        @Override
        public Component getControls() {
            return this.traitPanel;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.attachNameInput.getValueString()).append(this.descInput.getValueString()).append(this.attachCommandNameInput.getValueString()).append(this.attachKeyInput.getValueString()).append(this.clearAllCommandNameInput.getValueString()).append(this.clearAllKeyInput.getValueString()).append(this.propertyMatch.getValueString()).append(this.restrictRange.getValueString()).append(this.range.getValueString()).append(this.fixedRange.getValueString()).append(this.rangeProperty.getValueString()).append(this.deckPolicy.getValueString()).append(this.targetConfig.getValueString()).append(this.clearMatchingCommandNameInput.getValueString()).append(this.clearMatchingKeyInput.getValueString()).append(this.clearMatchingMatch.getValueString()).append(this.onAttachInput.getValueString()).append(this.onDetachInput.getValueString()).append(this.beforeAttachInput.getValueString()).append(this.allowSelfAttachInput.getValueString()).append(this.autoAttachInput.getValueString());
            return Attachment.ID + se.getValue();
        }

        @Override
        public String getState() {
            return this.attachment.myGetState();
        }
    }
}

