/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.property.PersistentPropertyContainer;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Clone
extends Decorator
implements TranslatablePiece {
    public static final String ID = "clone;";
    public static final String CLONE_ID = "CloneID";
    protected KeyCommand[] command;
    protected String commandName;
    protected NamedKeyStroke key;
    protected KeyCommand cloneCommand;
    protected String description = "";

    public Clone() {
        this(ID + Resources.getString("Editor.Clone.clone") + ";C", null);
    }

    public Clone(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken();
        this.key = st.nextNamedKeyStroke('C');
        this.description = st.nextToken("");
        this.command = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.cloneCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command = this.commandName.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.cloneCommand} : KeyCommand.NONE;
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        this.myGetKeyCommands();
        if (this.cloneCommand.matches(stroke)) {
            GamePiece outer = Decorator.getOutermost(this);
            GamePiece newPiece = ((AddPiece)GameModule.getGameModule().decode(GameModule.getGameModule().encode(new AddPiece(outer)))).getTarget();
            newPiece.setId(null);
            GameModule.getGameModule().getGameState().addPiece(newPiece);
            newPiece.setState(outer.getState());
            c = new AddPiece(newPiece);
            if (newPiece instanceof PersistentPropertyContainer) {
                c = c.append(((PersistentPropertyContainer)((Object)newPiece)).setPersistentProperty("UniqueID", newPiece.getProperty("PieceUID")));
                String cloneId = (String)this.getProperty(CLONE_ID);
                if (cloneId == null || cloneId.isEmpty()) {
                    cloneId = (String)this.getProperty("UniqueID");
                    c = c.append(this.setPersistentProperty(CLONE_ID, cloneId));
                }
                c = c.append(((PersistentPropertyContainer)((Object)newPiece)).setPersistentProperty(CLONE_ID, cloneId));
            }
            if (this.getMap() != null) {
                c.append(this.getMap().placeOrMerge(newPiece, outer.getPosition()));
                KeyBuffer.getBuffer().remove(outer);
                KeyBuffer.getBuffer().add(newPiece);
            }
        }
        return c;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.Clone.trait_description", this.description);
        s = (String)s + this.getCommandDesc(this.commandName, this.key);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Clone.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.commandName);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.html", "Clone");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, Resources.getString("Editor.Clone.clone_command_description"));
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(CLONE_ID);
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Clone)) {
            return false;
        }
        Clone c = (Clone)o;
        if (!Objects.equals(this.commandName, c.commandName)) {
            return false;
        }
        return Objects.equals(this.key, c.key);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer nameInput;
        private final NamedHotKeyConfigurer keyInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer descInput;

        public Ed(Clone p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.nameInput = new StringConfigurer(p.commandName);
            this.nameInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.nameInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.keyboard_command", (Configurer)this.keyInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.descInput.getValueString());
            return Clone.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

