/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang3.ArrayUtils;

public class ImagePicker
extends JPanel
implements MouseListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final String NO_IMAGE = "(" + Resources.getString("Editor.ImagePicker.no_image") + ")";
    private String imageName = null;
    protected static final Font FONT = new Font("Dialog", 0, 11);
    private final JTextArea noImage = new JTextArea(1, 10);
    private final JComboBox<String> select;
    private final OpIcon icon;
    private final JPanel imageViewer;
    private final JScrollPane imageScroller;

    public ImagePicker() {
        this.noImage.setFont(FONT);
        this.noImage.setText(Resources.getString("Editor.ImagePicker.double_click_here"));
        this.noImage.addMouseListener(this);
        this.noImage.setEditable(false);
        this.noImage.setLineWrap(true);
        this.noImage.setWrapStyleWord(true);
        this.noImage.setMinimumSize(new Dimension(15, 32));
        this.icon = new OpIcon();
        JLabel imageView = new JLabel(this.icon);
        imageView.addMouseListener(this);
        this.imageViewer = new JPanel(new BorderLayout());
        this.imageScroller = new ScrollPane(imageView, 20, 30);
        this.imageViewer.add((Component)this.imageScroller, "Center");
        this.select = new JComboBox<String>((String[])ArrayUtils.addFirst((Object[])GameModule.getGameModule().getDataArchive().getImageNames(), (Object)NO_IMAGE));
        this.select.addItemListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.noImage);
        this.add(this.select);
    }

    public String getImageName() {
        return this.imageName;
    }

    protected void setViewSize() {
    }

    public void setImageName(String name) {
        this.remove(0);
        if (name == null || name.isEmpty()) {
            this.imageName = null;
            this.add((Component)this.noImage, 0);
        } else {
            if (name.equals(this.imageName)) {
                Op.clearCache();
            } else {
                this.imageName = name;
            }
            this.icon.setOp(Op.load(this.imageName));
            Dimension d = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
            if (d.width > 200) {
                d.width = 200;
            }
            d.height = d.height > 200 ? 200 : (d.height += 4);
            this.imageScroller.setPreferredSize(d);
            this.imageScroller.setMinimumSize(d);
            this.add((Component)this.imageViewer, 0);
        }
        this.select.removeItemListener(this);
        this.select.setSelectedItem(name);
        if (name != null && !name.equals(this.select.getSelectedItem())) {
            this.select.setSelectedItem(name + ".gif");
        }
        this.select.addItemListener(this);
        this.revalidate();
        SwingUtils.repack(this);
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && SwingUtils.isMainMouseButtonDown(e)) {
            this.pickImage();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setImageName((String)this.select.getSelectedItem());
    }

    public void pickImage() {
        GameModule gm = GameModule.getGameModule();
        FileChooser fc = gm.getEditorImageChooser();
        fc.setFileFilter(new ImageFileFilter());
        if (fc.showOpenDialog(this) == 0 && fc.getSelectedFile().exists()) {
            String name = fc.getSelectedFile().getName();
            gm.getArchiveWriter().addImage(fc.getSelectedFile().getPath(), name);
            this.select.setModel(new DefaultComboBoxModel<String>((String[])ArrayUtils.addFirst((Object[])gm.getDataArchive().getImageNames(), (Object)NO_IMAGE)));
            this.setImageName(name);
        } else {
            this.setImageName(null);
        }
        this.repaint();
    }
}

