/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class MultiLocationCommand
extends Decorator
implements TranslatablePiece {
    public static final String ID = "locCommand;";
    public static final String LOC_NAME = "LocationOfCommand";
    public static final String LOC_ZONE = "ZoneOfCommand";
    public static final String LOC_BOARD = "BoardOfCommand";
    public static final String LOC_MAP = "MapOfCommand";
    public static final String LOC_REGIONS = "locRegions";
    public static final String LOC_ZONES = "locZones";
    public static final String[] LOC_OPTIONS = new String[]{"locRegions", "locZones"};
    public static final String[] LOC_KEYS = new String[]{"Editor.MultiLocationCommand.regions", "Editor.MultiLocationCommand.zones"};
    protected String desc;
    protected String locType;
    protected Boolean curMapOnly = true;
    protected PropertyExpression propertiesFilter = new PropertyExpression("");
    protected FormattedString menuText = new FormattedString("");
    protected NamedKeyStroke key;
    private final List<MultiLocationKeyCommand> keyCommands = new ArrayList<MultiLocationKeyCommand>();
    private final MultiLocationPropertySource locPS = new MultiLocationPropertySource();
    private String evalLocation = "";
    private String evalZone = "";
    private String evalBoard = "";
    private String evalMap = "";
    private boolean everBuilt = false;

    public MultiLocationCommand() {
        this("locCommand;;", null);
    }

    public MultiLocationCommand(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.desc = st.nextToken("");
        this.locType = st.nextToken(LOC_REGIONS);
        this.propertiesFilter.setExpression(st.nextToken(""));
        this.menuText.setFormat(st.nextToken(Resources.getString("Editor.MultiLocationCommand.loc_default_command")));
        this.key = st.nextNamedKeyStroke();
        this.curMapOnly = st.nextBoolean(true);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.desc).append(this.locType).append(this.propertiesFilter.getExpression()).append(this.menuText.getFormat()).append(this.key).append(this.curMapOnly);
        return ID + se.getValue();
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return Arrays.asList(this.menuText.getFormat());
    }

    @Override
    public List<String> getExpressionList() {
        return Arrays.asList(this.propertiesFilter.getExpression());
    }

    private void tryName(String name) {
        this.evalLocation = name;
        if (this.propertiesFilter.getExpression().isBlank() || this.propertiesFilter.isTrue(this.locPS)) {
            AuditTrail audit = AuditTrail.create((Auditable)this.locPS, this.menuText.getFormat(), Resources.getString("Editor.MultiLocationCommand.evaluate_menu_text"));
            String myMenuText = this.menuText.getLocalizedText((PropertySource)this.locPS, (Auditable)this, audit);
            this.keyCommands.add(new MultiLocationKeyCommand(myMenuText, this.key, Decorator.getOutermost(this), this, this.evalLocation, this.evalZone, this.evalBoard, this.evalMap));
        }
    }

    private void tryZone(Zone zone) {
        this.tryName(zone.getName());
    }

    private void tryRegion(Region region) {
        this.tryName(region.getName());
    }

    private void tryGrid(MapGrid grid) {
        block4: {
            block3: {
                if (!(grid instanceof ZonedGrid)) break block3;
                for (Zone zone : ((ZonedGrid)grid).getZonesList()) {
                    this.evalZone = zone.getName();
                    if (LOC_ZONES.equals(this.locType)) {
                        this.tryZone(zone);
                        continue;
                    }
                    this.tryGrid(zone.getGrid());
                }
                break block4;
            }
            if (!(grid instanceof RegionGrid) || !LOC_REGIONS.equals(this.locType)) break block4;
            for (Region r : ((RegionGrid)grid).getRegionList().values()) {
                this.tryRegion(r);
            }
        }
    }

    private void tryMap(Map map) {
        this.evalMap = map.getMapName();
        for (Board board : map.getBoardPicker().getSelectedBoards()) {
            this.evalBoard = board.getName();
            this.tryGrid(board.getGrid());
        }
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.key == null || this.key.isNull()) {
            return KeyCommand.NONE;
        }
        this.everBuilt = true;
        this.keyCommands.clear();
        if (this.curMapOnly.booleanValue()) {
            Map map = this.getMap();
            if (map == null) {
                return KeyCommand.NONE;
            }
            this.tryMap(map);
        } else {
            for (Map map : Map.getMapList()) {
                this.tryMap(map);
            }
        }
        return this.keyCommands.toArray(new KeyCommand[0]);
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        if (this.key.equals(stroke)) {
            KeyCommand kc = GameModule.getGameModule().getLocationKeyCommand();
            if (!(kc instanceof MultiLocationKeyCommand)) {
                if (!this.everBuilt) {
                    this.myGetKeyCommands();
                }
                if (this.keyCommands.isEmpty()) {
                    return null;
                }
                kc = this.keyCommands.get(0);
            }
            this.setProperty(LOC_NAME, ((MultiLocationKeyCommand)kc).locationName);
            this.setProperty(LOC_ZONE, ((MultiLocationKeyCommand)kc).zoneName);
            this.setProperty(LOC_BOARD, ((MultiLocationKeyCommand)kc).boardName);
            this.setProperty(LOC_MAP, ((MultiLocationKeyCommand)kc).mapName);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public Object getProperty(Object key) {
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        return super.getLocalizedProperty(key);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.MultiLocationCommand.trait_description", this.desc);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.MultiLocationCommand.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.desc;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof MultiLocationCommand)) {
            return false;
        }
        MultiLocationCommand c = (MultiLocationCommand)o;
        if (!Objects.equals(this.desc, c.desc)) {
            return false;
        }
        if (!Objects.equals(this.locType, c.locType)) {
            return false;
        }
        if (!Objects.equals(this.propertiesFilter.getExpression(), c.propertiesFilter.getExpression())) {
            return false;
        }
        if (!Objects.equals(this.menuText.getFormat(), c.menuText.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.curMapOnly, c.curMapOnly)) {
            return false;
        }
        return Objects.equals(this.key, c.key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MultiLocationCommand.html");
    }

    @Override
    public List<String> getPropertyNames() {
        return Arrays.asList(LOC_BOARD, LOC_MAP, LOC_NAME, LOC_ZONE);
    }

    private class MultiLocationPropertySource
    implements PropertySource {
        private MultiLocationPropertySource() {
        }

        @Override
        public Object getProperty(Object key) {
            if (MultiLocationCommand.LOC_NAME.equals(key)) {
                return MultiLocationCommand.this.evalLocation;
            }
            if (MultiLocationCommand.LOC_ZONE.equals(key)) {
                return MultiLocationCommand.this.evalZone;
            }
            if (MultiLocationCommand.LOC_BOARD.equals(key)) {
                return MultiLocationCommand.this.evalBoard;
            }
            if (MultiLocationCommand.LOC_MAP.equals(key)) {
                return MultiLocationCommand.this.evalMap;
            }
            return Decorator.getOutermost(MultiLocationCommand.this.piece).getProperty(key);
        }

        @Override
        public Object getLocalizedProperty(Object key) {
            return this.getProperty(key);
        }
    }

    public static class MultiLocationKeyCommand
    extends KeyCommand {
        private static final long serialVersionUID = 1L;
        private final String locationName;
        private final String zoneName;
        private final String boardName;
        private final String mapName;

        public MultiLocationKeyCommand(String name, NamedKeyStroke key, GamePiece target, TranslatablePiece i18nPiece, String locationName, String zoneName, String boardName, String mapName) {
            super(name, key, target, i18nPiece);
            this.locationName = locationName;
            this.zoneName = zoneName;
            this.boardName = boardName;
            this.mapName = mapName;
        }

        public String getLocationName() {
            return this.locationName;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            GameModule gm = GameModule.getGameModule();
            gm.setLocationKeyCommand(this);
            super.actionPerformed(evt);
            gm.setLocationKeyCommand(null);
        }
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer descInput;
        private final TranslatingStringEnumConfigurer locTypeInput;
        private final BooleanConfigurer curMapOnlyInput;
        private final PropertyExpressionConfigurer propertyMatchInput;
        private final FormattedStringConfigurer menuTextInput;
        private final NamedHotKeyConfigurer keyInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();

        public Ed(MultiLocationCommand p) {
            this.descInput = new StringConfigurer(p.desc);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.locTypeInput = new TranslatingStringEnumConfigurer(LOC_OPTIONS, LOC_KEYS);
            this.locTypeInput.setValue(MultiLocationCommand.LOC_REGIONS);
            for (String s : LOC_OPTIONS) {
                if (!s.equals(p.locType)) continue;
                this.locTypeInput.setValue(s);
            }
            this.controls.add("Editor.MultiLocationCommand.location_type", (Configurer)this.locTypeInput);
            this.curMapOnlyInput = new BooleanConfigurer(p.curMapOnly);
            this.controls.add("Editor.MultiLocationCommand.current_map_only", (Configurer)this.curMapOnlyInput);
            this.propertyMatchInput = new PropertyExpressionConfigurer(p.propertiesFilter, (GamePiece)p);
            this.propertyMatchInput.setContextLevel(Configurer.ContextLevel.MAP);
            this.controls.add("Editor.MultiLocationCommand.matching_properties", (Configurer)this.propertyMatchInput);
            this.menuTextInput = new FormattedExpressionConfigurer(p.menuText.getFormat(), p);
            this.controls.add("Editor.MultiLocationCommand.menu_format", (Configurer)this.menuTextInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.MultiLocationCommand.key_command", (Configurer)this.keyInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.descInput.getValueString()).append(this.locTypeInput.getValueString()).append(this.propertyMatchInput.getValueString()).append(this.menuTextInput.getValueString()).append(this.keyInput.getValueString()).append(this.curMapOnlyInput.getValueString());
            return MultiLocationCommand.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

