/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.LongConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslateVassalWindow;
import VASSAL.launch.CustomVmOptions;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.FirstTimeDialog;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.LaunchRequestHandler;
import VASSAL.launch.ModuleManagerMacOSXStartUp;
import VASSAL.launch.ModuleManagerMenuManager;
import VASSAL.launch.ModuleManagerSocketListener;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.StandardConfig;
import VASSAL.launch.StartUp;
import VASSAL.launch.UpdateCheckRequest;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.lang.MemoryUtils;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.menu.MacOSXMenuManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManager.class);
    private static final String NEXT_VERSION_CHECK = "nextVersionCheck";
    private static final String AUTO_VERSION_CHECK = "autoVersionCheck";
    public static final String CONVERTER_MAXIMUM_HEAP = "converterMaximumHeap";
    public static final String TILER_MAXIMUM_HEAP = "tilerMaximumHeap";
    @Deprecated(since="2022-02-25", forRemoval=true)
    public static final String MAXIMUM_HEAP = "maximumHeap";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String INITIAL_HEAP = "initialHeap";
    private static ModuleManager instance = null;
    private final long key;
    private final FileChannel lout;
    private final FileLock lock;

    private static FileLock acquireLock(FileChannel fc) throws IOException {
        try {
            return fc.lock();
        }
        catch (OverlappingFileLockException e) {
            throw new IOException(e);
        }
    }

    private static FileLock tryLock(FileChannel fc) throws IOException {
        try {
            return fc.tryLock();
        }
        catch (OverlappingFileLockException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) {
        System.setProperty("swing.boldMetal", "false");
        try {
            Info.setConfig(new StandardConfig());
        }
        catch (IOException e) {
            System.err.println("VASSAL: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        LaunchRequest lr = null;
        try {
            lr = LaunchRequest.parseArgs(args);
        }
        catch (LaunchRequestException e) {
            System.err.println("VASSAL: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        if (lr.mode == LaunchRequest.Mode.TRANSLATE) {
            SwingUtilities.invokeLater(() -> new TranslateVassalWindow(null).setVisible(true));
            return;
        }
        String ver = Info.getReportableVersion();
        File keyfile = new File(Info.getConfDir(), "key-" + ver);
        File lockfile = new File(Info.getConfDir(), "lock-" + ver);
        int port = 0;
        long key = 0L;
        try (RandomAccessFile kraf = new RandomAccessFile(keyfile, "rw");
             FileLock klock = ModuleManager.acquireLock(kraf.getChannel());){
            FileChannel lout = FileChannel.open(lockfile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            FileLock lock = ModuleManager.tryLock(lout);
            if (lock != null) {
                if (lr.mode == LaunchRequest.Mode.UPDATE_MOD || lr.mode == LaunchRequest.Mode.UPDATE_EXT || lr.mode == LaunchRequest.Mode.UPDATE_GAME) {
                    return;
                }
                ServerSocket serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
                port = serverSocket.getLocalPort();
                kraf.writeInt(port);
                key = (long)(Math.random() * 9.223372036854776E18);
                kraf.writeLong(key);
                new ModuleManager(serverSocket, key, lout, lock);
            } else {
                lout.close();
                port = kraf.readInt();
                key = kraf.readLong();
            }
        }
        catch (IOException e) {
            System.err.println("VASSAL: IO error");
            e.printStackTrace();
            System.exit(1);
        }
        lr.key = key;
        try (Socket clientSocket = new Socket((String)null, port);
             ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(clientSocket.getOutputStream()));){
            out.writeObject(lr);
            out.flush();
            try (InputStream in = clientSocket.getInputStream();){
                in.transferTo(System.err);
            }
        }
        catch (UnknownHostException e) {
            logger.error("VASSAL: Unable to open socket for loopback device", (Throwable)e);
            System.exit(1);
        }
        catch (IOException e) {
            logger.error("VASSAL: Problem with socket on port {}", (Object)port, (Object)e);
            System.exit(1);
        }
    }

    public static ModuleManager getInstance() {
        return instance;
    }

    public ModuleManager(ServerSocket serverSocket, long key, FileChannel lout, FileLock lock) throws IOException {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        this.key = key;
        this.lout = lout;
        this.lock = lock;
        File errorLog = Info.getErrorLogPath();
        Files.newOutputStream(errorLog.toPath(), new OpenOption[0]).close();
        StartUp start = SystemUtils.IS_OS_MAC ? new ModuleManagerMacOSXStartUp() : new StartUp();
        start.startErrorLog();
        System.setErr(new PrintStream((OutputStream)new LoggedOutputStream(), true, Charset.defaultCharset()));
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        start.initSystemProperties();
        if (SystemUtils.IS_OS_MAC) {
            new MacOSXMenuManager();
        } else {
            new ModuleManagerMenuManager();
        }
        new CustomVmOptions().ensureCustomVmOptionsFileExistsInConfDir();
        SwingUtilities.invokeLater(this::launch);
        Thread socketListener = new Thread((Runnable)new ModuleManagerSocketListener(serverSocket, obj -> this.execute(obj)), "socket listener");
        socketListener.setDaemon(true);
        socketListener.start();
        Prefs globalPrefs = Prefs.getGlobalPrefs();
        this.updateCheck(globalPrefs);
        this.converterHeapSetup(globalPrefs);
        this.tilerHeapSetup(globalPrefs);
    }

    private void updateCheck(Prefs globalPrefs) {
        LongConfigurer nextVersionCheckConfig = new LongConfigurer(NEXT_VERSION_CHECK, null, -1L);
        globalPrefs.addOption(null, nextVersionCheckConfig);
        BooleanConfigurer autoVersionCheck = new BooleanConfigurer(AUTO_VERSION_CHECK, Resources.getString("GlobalOptions.auto_version_check"), true);
        globalPrefs.addOption(Resources.getString("Prefs.general_tab"), autoVersionCheck);
        if (!autoVersionCheck.getValueBoolean()) {
            return;
        }
        long nextVersionCheck = nextVersionCheckConfig.getLongValue(-1L);
        if (nextVersionCheck < System.currentTimeMillis()) {
            new UpdateCheckRequest().execute();
        }
        nextVersionCheck = nextVersionCheck == -1L ? System.currentTimeMillis() + (long)(Math.random() * 5.0 * 8.64E7) : (nextVersionCheck += 432000000L);
        nextVersionCheckConfig.setValue(nextVersionCheck);
    }

    private void tilerHeapSetup(Prefs globalPrefs) {
        long physMemory = MemoryUtils.getPhysicalMemory();
        physMemory = physMemory <= 0L ? 4096L : physMemory >> 20;
        IntConfigurer maxHeapConf = new IntConfigurer(TILER_MAXIMUM_HEAP, Resources.getString("GlobalOptions.maximum_heap"), (Integer)((int)(3L * physMemory / 4L)));
        globalPrefs.addOption(Resources.getString("Prefs.tiler_tab"), maxHeapConf);
    }

    private void converterHeapSetup(Prefs globalPrefs) {
        IntConfigurer maxHeapConf = new IntConfigurer(CONVERTER_MAXIMUM_HEAP, Resources.getString("GlobalOptions.maximum_heap"), (Integer)512);
        globalPrefs.addOption(Resources.getString("Prefs.converter_tab"), maxHeapConf);
    }

    public void shutDown() throws IOException {
        this.lock.release();
        this.lout.close();
    }

    protected void launch() {
        boolean isFirstTime;
        logger.info("Manager");
        ModuleManagerWindow window = ModuleManagerWindow.getInstance();
        window.setVisible(true);
        boolean bl = isFirstTime = !Info.getPrefsDir().exists();
        if (isFirstTime) {
            new FirstTimeDialog(window).setVisible(true);
        }
    }

    protected String execute(Object req) {
        if (req instanceof LaunchRequest) {
            LaunchRequest lr = (LaunchRequest)req;
            if (lr.key != this.key) {
                return "incorrect key";
            }
            LaunchRequestHandler handler = new LaunchRequestHandler(lr);
            try {
                SwingUtilities.invokeAndWait(handler);
            }
            catch (InterruptedException e) {
                return "interrupted";
            }
            catch (InvocationTargetException e) {
                ErrorDialog.bug(e);
                return null;
            }
            return handler.getResult();
        }
        return "unrecognized command";
    }
}

