/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ReadErrorDialog;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang3.SystemUtils;

public class BrowserSupport {
    private static final HyperlinkListener listener = e -> {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            BrowserSupport.openURL(e.getURL());
        }
    };

    public static void openURI(URI uri) {
        Desktop desktop;
        if (!SystemUtils.IS_OS_LINUX && Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, uri.toString());
            }
            return;
        }
        String uristr = uri.toString();
        String launcher = SystemUtils.IS_OS_WINDOWS ? "start" : (SystemUtils.IS_OS_MAC ? "open" : "xdg-open");
        ProcessBuilder pb = new ProcessBuilder(launcher, uristr);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            pb.start();
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, uristr);
        }
    }

    public static void openURL(URL url) {
        URI uri;
        try {
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, url.toString());
            return;
        }
        BrowserSupport.openURI(uri);
    }

    public static void openURL(String url) {
        URI uri;
        try {
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, url);
            return;
        }
        BrowserSupport.openURI(uri);
    }

    public static HyperlinkListener getListener() {
        return listener;
    }
}

