/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import java.lang.reflect.InvocationTargetException;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static void handleImportClassFailure(Throwable t, String className) {
        ReflectionUtils.handle(t, className, ClassNotFoundException.class, ExceptionInInitializerError.class, LinkageError.class, NoSuchMethodException.class, SecurityException.class, IllegalAccessException.class, IllegalArgumentException.class, InstantiationException.class, InvocationTargetException.class);
    }

    public static void handleNewInstanceFailure(Throwable t, Class<?> c) {
        ReflectionUtils.handle(t, c.getName(), IllegalAccessException.class, IllegalArgumentException.class, InstantiationException.class, InvocationTargetException.class, NoSuchMethodException.class, SecurityException.class, ExceptionInInitializerError.class);
    }

    private static void handle(Throwable t, String className, Class<?> ... args) {
        ThrowableUtils.throwRecent(OutOfMemoryError.class, t);
        if (className.startsWith("VASSAL.")) {
            ErrorDialog.bug(t);
            return;
        }
        for (Class<?> cl : args) {
            if (!cl.isInstance(t)) continue;
            ErrorDialog.showDetailsDisableable(t, ThrowableUtils.getStackTrace(t), (Object)className, "Error.custom_class_error", className);
            return;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new IllegalStateException(t);
    }
}

