/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.Buildable;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.i18n.Resources;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UniqueIdManager
implements ValidityChecker {
    private final List<Identifyable> instances = new ArrayList<Identifyable>();
    private final String prefix;

    public UniqueIdManager(String prefix) {
        this.prefix = prefix;
    }

    public void add(Identifyable i) {
        i.setId(this.prefix + this.instances.size());
        this.instances.add(i);
    }

    public void remove(Identifyable i) {
        int index = this.instances.indexOf(i);
        if (index >= 0) {
            int n = this.instances.size();
            for (int j = index + 1; j < n; ++j) {
                this.instances.get(j).setId(this.prefix + (j - 1));
            }
            this.instances.remove(index);
        }
    }

    public static String getIdentifier(Identifyable target) {
        String id = target.getConfigureName();
        if (id == null || id.length() == 0) {
            id = target.getId();
        }
        return id;
    }

    public Iterator<Identifyable> getAllInstances() {
        return this.instances.iterator();
    }

    public Identifyable findInstance(String id) {
        if (id != null) {
            for (Identifyable i : this.instances) {
                if (!id.equals(i.getConfigureName()) && !id.equals(i.getId())) continue;
                return i;
            }
        }
        return null;
    }

    @Override
    public void validate(Buildable target, ValidationReport report) {
        if (target instanceof Identifyable) {
            Identifyable iTarget = (Identifyable)((Object)target);
            if (iTarget.getConfigureName() == null || iTarget.getConfigureName().length() == 0) {
                report.addWarning(Resources.getString("Editor.UniqueIdManager.a_girl_has_no_name", ConfigureTree.getConfigureName(target.getClass())));
            } else if (this.instances.contains(iTarget)) {
                Identifyable compare = null;
                Iterator<Identifyable> i = this.instances.iterator();
                while (i.hasNext() && compare != iTarget) {
                    compare = i.next();
                    if (compare == iTarget || !iTarget.getConfigureName().equals(compare.getConfigureName())) continue;
                    report.addWarning(Resources.getString("Editor.UniqueIdManager.more_than_one", ConfigureTree.getConfigureName(target.getClass()), iTarget.getConfigureName()));
                    break;
                }
            }
        }
    }

    public static interface Identifyable {
        public void setId(String var1);

        public String getId();

        public String getConfigureName();
    }
}

