/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.FixedScaleOpBitmapImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ScaleOpTiledBitmapImpl;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FixedScaleOpTiledBitmapImpl
extends FixedScaleOpBitmapImpl {
    public FixedScaleOpTiledBitmapImpl(ImageOp sop, double scale, int width, int height) {
        this(sop, scale, width, height, defaultHints);
    }

    public FixedScaleOpTiledBitmapImpl(ImageOp sop, double scale, int width, int height, RenderingHints hints) {
        super(sop, scale, width, height, hints);
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new TileOp(this, tileX, tileY);
    }

    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp rsop;
        private final ImageOp[] sop;
        private final int dx0;
        private final int dy0;
        private final int dx1;
        private final int dy1;
        private final int dw;
        private final int dh;
        private final int sx0;
        private final int sy0;
        private final int sx1;
        private final int sy1;
        private final int sw;
        private final int sh;
        private final Dimension dd;
        private final Dimension sd;
        private final double scale;
        private final float xscale;
        private final float yscale;
        private final int tx;
        private final int ty;
        private final RenderingHints hints;
        private final int hash;
        private static final GeneralFilter.Filter downFilter = new GeneralFilter.Lanczos3Filter();
        private static final GeneralFilter.Filter upFilter = new GeneralFilter.MitchellFilter();

        public TileOp(FixedScaleOpTiledBitmapImpl rop, int tileX, int tileY) {
            if (rop == null) {
                throw new IllegalArgumentException();
            }
            if (tileX < 0 || tileX >= rop.getNumXTiles() || tileY < 0 || tileY >= rop.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.tx = tileX;
            this.ty = tileY;
            this.scale = rop.getScale();
            this.hints = rop.getHints();
            this.dd = rop.getSize();
            this.dx0 = tileX * rop.getTileWidth();
            this.dy0 = tileY * rop.getTileHeight();
            this.dw = Math.min(rop.getTileWidth(), this.dd.width - this.dx0);
            this.dh = Math.min(rop.getTileHeight(), this.dd.height - this.dy0);
            this.dx1 = this.dx0 + this.dw - 1;
            this.dy1 = this.dy0 + this.dh - 1;
            this.size = new Dimension(this.dw, this.dh);
            if (this.scale >= 1.0) {
                this.rsop = rop.sop;
            } else {
                double nscale = 1.0 / (double)(1 << (int)Math.floor(Math.log(1.0 / this.scale) / Math.log(2.0)));
                this.rsop = new ScaleOpTiledBitmapImpl(rop.sop, nscale);
            }
            this.sd = this.rsop.getSize();
            this.xscale = this.sd.width == 1 ? (float)this.dd.width : (float)(this.dd.width - 1) / (float)(this.sd.width - 1);
            this.yscale = this.sd.height == 1 ? (float)this.dd.height : (float)(this.dd.height - 1) / (float)(this.sd.height - 1);
            float fw = this.scale < 1.0 ? downFilter.getSamplingRadius() : upFilter.getSamplingRadius();
            this.sx0 = Math.max(0, (int)Math.floor(((float)this.dx0 - fw) / this.xscale));
            this.sy0 = Math.max(0, (int)Math.floor(((float)this.dy0 - fw) / this.yscale));
            this.sx1 = Math.min(this.sd.width - 1, (int)Math.ceil(((float)this.dx1 + fw) / this.xscale));
            this.sy1 = Math.min(this.sd.height - 1, (int)Math.ceil(((float)this.dy1 + fw) / this.yscale));
            this.sw = this.sx1 - this.sx0 + 1;
            this.sh = this.sy1 - this.sy0 + 1;
            Rectangle sr = new Rectangle(this.sx0, this.sy0, this.sw, this.sh);
            Point[] stiles = this.rsop.getTileIndices(sr);
            this.sop = new ImageOp[stiles.length];
            for (int i = 0; i < stiles.length; ++i) {
                this.sop[i] = this.rsop.getTileOp(stiles[i]);
            }
            this.hash = new HashCodeBuilder().append((Object[])this.sop).append(this.dx0).append(this.dy0).append(this.dw).append(this.dh).append(this.tx).append(this.ty).toHashCode();
        }

        @Override
        public List<Op<?>> getSources() {
            return Arrays.asList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            BufferedImage src;
            if (this.dw < 1 || this.dh < 1) {
                return ImageUtils.NULL_IMAGE;
            }
            Point[] tiles = this.rsop.getTileIndices(new Rectangle(this.sx0, this.sy0, this.sw, this.sh));
            int tw = this.rsop.getTileWidth();
            int th = this.rsop.getTileHeight();
            boolean src_trans = ImageUtils.isTransparent(this.rsop.getTile(tiles[0], null));
            switch (ImageUtils.getCompatibleImageType(this.rsop.getTile(tiles[0], null))) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    src = ImageUtils.createCompatibleImage(this.sw, this.sh, src_trans);
                    break;
                }
                default: {
                    src = new BufferedImage(this.sw, this.sh, src_trans ? 3 : 1);
                }
            }
            Graphics2D g = src.createGraphics();
            for (Point tile : tiles) {
                g.drawImage((Image)this.rsop.getTile(tile, null), tile.x * tw - this.sx0, tile.y * th - this.sy0, null);
            }
            g.dispose();
            int[] src_data = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
            WritableRaster dstR = src.getColorModel().createCompatibleWritableRaster(this.dw, this.dh);
            int[] dst_data = ((DataBufferInt)dstR.getDataBuffer()).getData();
            int src_type = !src_trans ? 0 : (src.isAlphaPremultiplied() ? 1 : 2);
            GeneralFilter.resample(src_data, true, this.sx0, this.sy0, this.sx1, this.sy1, this.sw, this.sh, src_type, this.sd.width, this.sd.height, dst_data, this.dx0, this.dy0, this.dx1, this.dy1, this.dw, this.dh, this.dd.width, this.dd.height, this.xscale, this.yscale, this.scale < 1.0 ? downFilter : upFilter);
            return ImageUtils.toCompatibleImage(new BufferedImage(src.getColorModel(), dstR, src.isAlphaPremultiplied(), null));
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            TileOp op = (TileOp)o;
            return this.dx0 == op.dx0 && this.dy0 == op.dy0 && this.dw == op.dw && this.dh == op.dh && this.tx == op.tx && this.ty == op.ty && this.scale == op.scale && Arrays.equals(this.sop, op.sop);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[sop=" + Arrays.toString(this.sop) + ",scale=" + this.scale + ",dx0=" + this.dx0 + ",dy0=" + this.dy0 + ",dw=" + this.dw + ",dy=" + this.dh + "]";
        }
    }
}

