/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.qtree;

import VASSAL.tools.qtree.QFunc;
import VASSAL.tools.qtree.QNode;
import VASSAL.tools.qtree.QNodeType;
import VASSAL.tools.qtree.QPoint;
import VASSAL.tools.qtree.QuadTreeException;
import java.util.ArrayList;
import java.util.List;

public class QuadTree<T>
implements Cloneable {
    private QNode<T> root_;
    private int count_ = 0;

    public QuadTree(double minX, double minY, double maxX, double maxY) {
        this.root_ = new QNode(minX, minY, maxX - minX, maxY - minY, null);
    }

    public QuadTree() {
    }

    public QNode<T> getRootNode() {
        return this.root_;
    }

    public void setRootNode(QNode<T> root) {
        this.root_ = root;
    }

    public void set(double x, double y, T value) {
        QNode<T> root = this.root_;
        if (x < root.getX() || y < root.getY() || x > root.getX() + root.getW() || y > root.getY() + root.getH()) {
            throw new QuadTreeException("Out of bounds : (" + x + ", " + y + ")");
        }
        if (this.insert(root, new QPoint<T>(x, y, value))) {
            ++this.count_;
        }
    }

    public T get(double x, double y, T opt_default) {
        QNode<T> node = this.find(this.root_, x, y);
        return node != null ? node.getPoint().getValue() : opt_default;
    }

    public T remove(double x, double y) {
        QNode node = this.find(this.root_, x, y);
        if (node != null) {
            T value = node.getPoint().getValue();
            node.setPoint(null);
            node.setNodeType(QNodeType.EMPTY);
            this.balance(node);
            --this.count_;
            return value;
        }
        return null;
    }

    public boolean contains(double x, double y) {
        return this.get(x, y, null) != null;
    }

    public boolean isEmpty() {
        return this.root_.getNodeType() == QNodeType.EMPTY;
    }

    public int getCount() {
        return this.count_;
    }

    public void clear() {
        this.root_.setNw(null);
        this.root_.setNe(null);
        this.root_.setSw(null);
        this.root_.setSe(null);
        this.root_.setNodeType(QNodeType.EMPTY);
        this.root_.setPoint(null);
        this.count_ = 0;
    }

    public QPoint<T>[] getKeys() {
        final ArrayList arr = new ArrayList();
        this.traverse(this.root_, new QFunc<T>(){

            @Override
            public void call(QuadTree<T> quadTree, QNode<T> node) {
                arr.add(node.getPoint());
            }
        });
        return arr.toArray(new QPoint[0]);
    }

    public List<T> getValues() {
        final ArrayList arr = new ArrayList();
        this.traverse(this.root_, new QFunc<T>(){

            @Override
            public void call(QuadTree<T> quadTree, QNode<T> node) {
                arr.add(node.getPoint().getValue());
            }
        });
        return arr;
    }

    public QPoint<T>[] searchIntersect(final double xmin, final double ymin, final double xmax, final double ymax) {
        final ArrayList arr = new ArrayList();
        this.navigate(this.root_, new QFunc<T>(){

            @Override
            public void call(QuadTree<T> quadTree, QNode<T> node) {
                QPoint pt = node.getPoint();
                if (!(pt.getX() < xmin || pt.getX() > xmax || pt.getY() < ymin || pt.getY() > ymax)) {
                    arr.add(node.getPoint());
                }
            }
        }, xmin, ymin, xmax, ymax);
        return arr.toArray(new QPoint[0]);
    }

    public QPoint<T>[] searchWithin(final double xmin, final double ymin, final double xmax, final double ymax) {
        final ArrayList arr = new ArrayList();
        this.navigate(this.root_, new QFunc<T>(){

            @Override
            public void call(QuadTree<T> quadTree, QNode<T> node) {
                QPoint pt = node.getPoint();
                if (pt.getX() > xmin && pt.getX() < xmax && pt.getY() > ymin && pt.getY() < ymax) {
                    arr.add(node.getPoint());
                }
            }
        }, xmin, ymin, xmax, ymax);
        return arr.toArray(new QPoint[0]);
    }

    public void navigate(QNode<T> node, QFunc<T> func, double xmin, double ymin, double xmax, double ymax) {
        switch (node.getNodeType()) {
            case LEAF: {
                func.call(this, node);
                break;
            }
            case POINTER: {
                if (this.intersects(xmin, ymax, xmax, ymin, node.getNe())) {
                    this.navigate(node.getNe(), func, xmin, ymin, xmax, ymax);
                }
                if (this.intersects(xmin, ymax, xmax, ymin, node.getSe())) {
                    this.navigate(node.getSe(), func, xmin, ymin, xmax, ymax);
                }
                if (this.intersects(xmin, ymax, xmax, ymin, node.getSw())) {
                    this.navigate(node.getSw(), func, xmin, ymin, xmax, ymax);
                }
                if (!this.intersects(xmin, ymax, xmax, ymin, node.getNw())) break;
                this.navigate(node.getNw(), func, xmin, ymin, xmax, ymax);
            }
        }
    }

    private boolean intersects(double left, double bottom, double right, double top, QNode<T> node) {
        return !(node.getX() > right || node.getX() + node.getW() < left || node.getY() > bottom || node.getY() + node.getH() < top);
    }

    public QuadTree<T> clone() {
        double x1 = this.root_.getX();
        double y1 = this.root_.getY();
        double x2 = x1 + this.root_.getW();
        double y2 = y1 + this.root_.getH();
        final QuadTree<T> clone = new QuadTree<T>(x1, y1, x2, y2);
        this.traverse(this.root_, new QFunc<T>(){

            @Override
            public void call(QuadTree<T> quadTree, QNode<T> node) {
                clone.set(node.getPoint().getX(), node.getPoint().getY(), node.getPoint().getValue());
            }
        });
        return clone;
    }

    public void traverse(QNode<T> node, QFunc<T> func) {
        switch (node.getNodeType()) {
            case LEAF: {
                func.call(this, node);
                break;
            }
            case POINTER: {
                this.traverse(node.getNe(), func);
                this.traverse(node.getSe(), func);
                this.traverse(node.getSw(), func);
                this.traverse(node.getNw(), func);
            }
        }
    }

    public QNode<T> find(QNode<T> node, double x, double y) {
        QNode<T> resposne = null;
        switch (node.getNodeType()) {
            case EMPTY: {
                break;
            }
            case LEAF: {
                resposne = node.getPoint().getX() == x && node.getPoint().getY() == y ? node : null;
                break;
            }
            case POINTER: {
                resposne = this.find(this.getQuadrantForPoint(node, x, y), x, y);
                break;
            }
            default: {
                throw new QuadTreeException("Invalid nodeType");
            }
        }
        return resposne;
    }

    private boolean insert(QNode<T> parent, QPoint<T> point) {
        Boolean result = false;
        switch (parent.getNodeType()) {
            case EMPTY: {
                this.setPointForNode(parent, point);
                result = true;
                break;
            }
            case LEAF: {
                if (parent.getPoint().getX() == point.getX() && parent.getPoint().getY() == point.getY()) {
                    this.setPointForNode(parent, point);
                    result = false;
                    break;
                }
                this.split(parent);
                result = this.insert(parent, point);
                break;
            }
            case POINTER: {
                result = this.insert(this.getQuadrantForPoint(parent, point.getX(), point.getY()), point);
                break;
            }
            default: {
                throw new QuadTreeException("Invalid nodeType in parent");
            }
        }
        return result;
    }

    private void split(QNode<T> node) {
        QPoint<T> oldPoint = node.getPoint();
        node.setPoint(null);
        node.setNodeType(QNodeType.POINTER);
        double x = node.getX();
        double y = node.getY();
        double hw = node.getW() / 2.0;
        double hh = node.getH() / 2.0;
        node.setNw(new QNode<T>(x, y, hw, hh, node));
        node.setNe(new QNode<T>(x + hw, y, hw, hh, node));
        node.setSw(new QNode<T>(x, y + hh, hw, hh, node));
        node.setSe(new QNode<T>(x + hw, y + hh, hw, hh, node));
        this.insert(node, oldPoint);
    }

    private void balance(QNode<T> node) {
        switch (node.getNodeType()) {
            case LEAF: 
            case EMPTY: {
                if (node.getParent() == null) break;
                this.balance(node.getParent());
                break;
            }
            case POINTER: {
                QNode<T> nw = node.getNw();
                QNode<T> ne = node.getNe();
                QNode<T> sw = node.getSw();
                QNode<T> se = node.getSe();
                QNode<T> firstLeaf = null;
                if (nw.getNodeType() != QNodeType.EMPTY) {
                    firstLeaf = nw;
                }
                if (ne.getNodeType() != QNodeType.EMPTY) {
                    if (firstLeaf != null) break;
                    firstLeaf = ne;
                }
                if (sw.getNodeType() != QNodeType.EMPTY) {
                    if (firstLeaf != null) break;
                    firstLeaf = sw;
                }
                if (se.getNodeType() != QNodeType.EMPTY) {
                    if (firstLeaf != null) break;
                    firstLeaf = se;
                }
                if (firstLeaf == null) {
                    node.setNodeType(QNodeType.EMPTY);
                    node.setNw(null);
                    node.setNe(null);
                    node.setSw(null);
                    node.setSe(null);
                } else {
                    if (firstLeaf.getNodeType() == QNodeType.POINTER) break;
                    node.setNodeType(QNodeType.LEAF);
                    node.setNw(null);
                    node.setNe(null);
                    node.setSw(null);
                    node.setSe(null);
                    node.setPoint(firstLeaf.getPoint());
                }
                if (node.getParent() == null) break;
                this.balance(node.getParent());
            }
        }
    }

    private QNode<T> getQuadrantForPoint(QNode<T> parent, double x, double y) {
        double mx = parent.getX() + parent.getW() / 2.0;
        double my = parent.getY() + parent.getH() / 2.0;
        if (x < mx) {
            return y < my ? parent.getNw() : parent.getSw();
        }
        return y < my ? parent.getNe() : parent.getSe();
    }

    private void setPointForNode(QNode<T> node, QPoint<T> point) {
        if (node.getNodeType() == QNodeType.POINTER) {
            throw new QuadTreeException("Can not set point for node of type POINTER");
        }
        node.setNodeType(QNodeType.LEAF);
        node.setPoint(point);
    }
}

