/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.Stack;
import java.awt.Rectangle;

public class RemovePiece
extends Command {
    private Command undo = null;
    private GamePiece target;
    private String id;

    public RemovePiece(GamePiece p) {
        this.target = p;
    }

    public RemovePiece(String id) {
        this.id = id;
    }

    @Override
    protected void executeCommand() {
        if (this.target == null) {
            this.target = GameModule.getGameModule().getGameState().getPieceForId(this.id);
            if (this.target == null) {
                return;
            }
        }
        this.undo = new AddPiece(this.target, this.target.getState());
        Rectangle r = null;
        Map m = this.target.getMap();
        Stack parent = this.target.getParent();
        HighlightLastMoved.setLastMoved(this.target);
        if (m != null) {
            r = parent == null ? m.boundingBoxOf(this.target) : m.boundingBoxOf(parent);
            m.removePiece(this.target);
            this.target.setMap(null);
        }
        if (parent != null) {
            String stateWithPiece = parent.getState();
            parent.remove(this.target);
            this.undo = this.undo.append(new ChangePiece(parent.getId(), parent.getState(), stateWithPiece));
            this.target.setParent(null);
        }
        if (m != null) {
            m.repaint(r);
        }
        GameModule.getGameModule().getGameState().removePiece(this.target);
        KeyBuffer.getBuffer().remove(this.target);
    }

    @Override
    protected Command myUndoCommand() {
        if (this.undo == null && this.target != null) {
            this.undo = new AddPiece(this.target);
        }
        return this.undo;
    }

    public GamePiece getTarget() {
        return this.target;
    }

    public String getId() {
        return this.target == null ? this.id : this.target.getId();
    }
}

