/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.counters.GamePiece;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.GamePieceOp;
import VASSAL.tools.opcache.Op;
import VASSAL.tools.opcache.OpObserver;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class GamePieceOpImpl
extends AbstractTileOpImpl
implements GamePieceOp {
    private final GamePiece piece;
    private final String state;
    private final int hash;

    public GamePieceOpImpl(GamePiece gp) {
        if (gp == null) {
            throw new IllegalArgumentException();
        }
        this.piece = gp;
        this.state = String.valueOf(this.piece.getProperty("visibleState"));
        this.hash = this.piece.hashCode();
    }

    @Override
    public BufferedImage get(OpObserver<BufferedImage> obs) throws CancellationException, InterruptedException, ExecutionException {
        if (obs != null) {
            throw new UnsupportedOperationException();
        }
        return (BufferedImage)super.get(null);
    }

    @Override
    public Future<BufferedImage> getFuture(OpObserver<BufferedImage> obs) throws ExecutionException {
        if (obs != null) {
            throw new UnsupportedOperationException();
        }
        return super.getFuture(null);
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() {
        Rectangle b = this.piece.boundingBox();
        BufferedImage im = ImageUtils.createCompatibleTranslucentImage(Math.max(b.width, 1), Math.max(b.height, 1));
        Graphics2D g = im.createGraphics();
        this.piece.draw(g, -b.x, -b.y, null, 1.0);
        g.dispose();
        return im;
    }

    @Override
    protected void fixSize() {
        Dimension s = this.piece.boundingBox().getSize();
        if (s.width < 1) {
            s.width = 1;
        }
        if (s.height < 1) {
            s.height = 1;
        }
        this.size = s;
    }

    @Override
    public GamePiece getPiece() {
        return this.piece;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public boolean isChanged() {
        return !this.state.equals(this.piece.getProperty("visibleState"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GamePieceOp op = (GamePieceOp)o;
        return this.piece.equals(op.getPiece()) && this.state.equals(op.getState());
    }

    public int hashCode() {
        return this.hash;
    }
}

