/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class FontManager
extends AbstractConfigurable {
    protected static FontManager instance = new FontManager();
    protected Map<String, FontStyle> fontStyles = new HashMap<String, FontStyle>();
    public static final String DIALOG = "Dialog";
    public static final String SERIF = "Serif";
    public static final String SANS_SERIF = "SanSerif";
    public static final String DIALOG_INPUT = "DialogInput";
    public static final String MONOSPACED = "Monospaced";
    public static final String DEFAULT = "Default";
    public static final OutlineFont DEFAULT_FONT = new OutlineFont("Dialog", 0, 12, false);
    public static final FontStyle DEFAULT_STYLE = new FontStyle();
    public static final String[] ALLOWABLE_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public static FontManager getFontManager() {
        return instance;
    }

    @Override
    public void build(Element e) {
        super.build(e);
        if (this.fontStyles.get(DEFAULT) == null) {
            this.addChild(new FontStyle(DEFAULT, DEFAULT_FONT));
        }
    }

    private void addChild(Buildable b) {
        this.add(b);
        b.addTo(this);
    }

    protected FontStyle getFontStyle(String name) {
        FontStyle fs = this.fontStyles.get(name);
        return fs == null ? DEFAULT_STYLE : fs;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String key) {
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{FontStyle.class};
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.FontManager.component_type");
    }

    @Override
    public void add(Buildable b) {
        super.add(b);
        if (b instanceof FontStyle) {
            FontStyle def = (FontStyle)b;
            this.fontStyles.put(def.getConfigureName(), def);
            def.addPropertyChangeListener(evt -> {
                if ("name".equals(evt.getPropertyName())) {
                    this.fontStyles.remove(evt.getOldValue());
                    this.fontStyles.put((String)evt.getNewValue(), (FontStyle)evt.getSource());
                }
            });
        }
    }

    @Override
    public void remove(Buildable b) {
        super.remove(b);
        if (b instanceof ColorSwatch) {
            this.fontStyles.remove(((ColorSwatch)b).getConfigureName());
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImageDefinitions.html", "FontStyles");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    public String[] getFontNames() {
        ArrayList<String> names = new ArrayList<String>(this.fontStyles.size());
        for (FontStyle fs : this.fontStyles.values()) {
            names.add(fs.getConfigureName());
        }
        return names.toArray(new String[0]);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }
}

