/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.EnumeratedPropertyPrompt;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.IncrementProperty;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySetter;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class ChangePropertyButton
extends AbstractToolbarItem
implements PropertyChangerConfigurer.Constraints {
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_TOOLTIP = "tooltip";
    public static final String BUTTON_ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String DESCRIPTION = "desc";
    public static final String PROPERTY_CHANGER = "propChanger";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String OLD_VALUE_FORMAT = "oldValue";
    public static final String NEW_VALUE_FORMAT = "newValue";
    public static final String DESCRIPTION_FORMAT = "description";
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    protected FormattedString report = new FormattedString();
    protected GlobalProperty property;
    protected PropertyChangerConfigurer propChangeConfig = new PropertyChangerConfigurer(null, null, this);
    protected FormattedString format = new FormattedString();
    protected String desc = "";

    public ChangePropertyButton() {
        this.setNameKey("");
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Editor.ChangePropertyButton.change"), Resources.getString("Editor.ChangePropertyButton.change"), "", e -> this.launch()));
        this.launch = this.getLaunchButton();
        this.propChangeConfig.setContext(this.getAncestor());
    }

    public void launch() {
        String oldValue = this.property.getPropertyValue();
        String newValue = this.getNewValue();
        if (newValue != null && !newValue.equals(oldValue)) {
            Command c = this.property.setPropertyValue(newValue);
            if (this.report.getFormat().length() > 0) {
                this.report.setProperty(OLD_VALUE_FORMAT, oldValue);
                this.report.setProperty(NEW_VALUE_FORMAT, this.property.getPropertyValue());
                this.report.setProperty(DESCRIPTION_FORMAT, this.property.getDescription());
                String reportText = this.report.getLocalizedText(this, "Editor.report_format");
                if (!reportText.isEmpty()) {
                    Chatter.DisplayText chatCommand = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + reportText);
                    chatCommand.execute();
                    c.append(chatCommand);
                }
            }
            GameModule.getGameModule().sendAndLog(c);
        }
    }

    protected String getNewValue() {
        String newValue = this.getPropertyChanger().getNewValue(this.property.getPropertyValue());
        if (newValue == null) {
            newValue = this.property.getPropertyValue();
        }
        this.format.setFormat(newValue);
        newValue = this.format.getText((PropertySource)this.property, (Auditable)this, "Editor.PropertyChangeConfigurer.new_value");
        return newValue;
    }

    public PropertyChanger getPropertyChanger() {
        return this.propChangeConfig.getPropertyChanger();
    }

    @Override
    public String[] getAttributeDescriptions() {
        Stream.Builder<String> b = Stream.builder().add(Resources.getString("Editor.description_label"));
        Arrays.stream(super.getAttributeDescriptions()).forEach(b::add);
        b.add(Resources.getString("Editor.report_format")).add(Resources.getString("Editor.ChangePropertyButton.options"));
        return (String[])b.build().toArray(String[]::new);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Stream.Builder<Class<String>> b = Stream.builder().add(String.class);
        Arrays.stream(super.getAttributeTypes()).forEach(b::add);
        b.add(ReportFormatConfig.class).add(PropChangerOptions.class);
        return (Class[])b.build().toArray(Class[]::new);
    }

    @Override
    public String[] getAttributeNames() {
        Stream.Builder<String> b = Stream.builder().add(DESCRIPTION);
        Arrays.stream(super.getAttributeNames()).forEach(b::add);
        b.add(REPORT_FORMAT).add(PROPERTY_CHANGER);
        return (String[])b.build().toArray(String[]::new);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String key) {
        return super.getAttributeVisibility(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (DESCRIPTION.equals(key)) {
            this.desc = (String)value;
        } else if (PROPERTY_CHANGER.equals(key)) {
            if (value instanceof String) {
                this.propChangeConfig.setValue((String)value);
            } else {
                this.propChangeConfig.setValue(value);
            }
        } else if (REPORT_FORMAT.equals(key)) {
            this.report.setFormat((String)value);
        } else {
            if (BUTTON_TEXT.equals(key)) {
                this.setConfigureName((String)value);
            }
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (DESCRIPTION.equals(key)) {
            return this.desc;
        }
        if (PROPERTY_CHANGER.equals(key)) {
            return this.propChangeConfig.getValueString();
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.report.getFormat();
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.property.getToolBar().remove(this.getLaunchButton());
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalProperties.html", "ChangePropertyToolbarButton");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable parent) {
        this.property = (GlobalProperty)parent;
        this.property.getToolBar().add(this.getLaunchButton());
        this.propChangeConfig.setName(this.property.getConfigureName());
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ChangePropertyButton.component_type");
    }

    @Override
    public Component getComponent() {
        return this.getLaunchButton().getTopLevelAncestor();
    }

    @Override
    public int getMaximumValue() {
        return this.property.getMaxValue();
    }

    @Override
    public int getMinimumValue() {
        return this.property.getMinValue();
    }

    @Override
    public boolean isNumeric() {
        return this.property.isNumeric();
    }

    @Override
    public boolean isWrap() {
        return this.property.isWrap();
    }

    @Override
    public Object getProperty(Object key) {
        return this.property.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        return this.property.getLocalizedProperty(key);
    }

    @Override
    public PropertySource getPropertySource() {
        return this.property;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.report.getFormat());
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>();
        PropertyChanger propChanger = this.getPropertyChanger();
        if (propChanger != null) {
            if (propChanger instanceof IncrementProperty) {
                l.add(((IncrementProperty)propChanger).getIncrement());
            } else if (propChanger instanceof PropertySetter) {
                l.add(((PropertySetter)propChanger).getRawValue());
            } else if (propChanger instanceof PropertyPrompt) {
                PropertyPrompt pp = (PropertyPrompt)propChanger;
                l.add(pp.getPrompt());
                if (pp instanceof EnumeratedPropertyPrompt) {
                    Expression[] ve;
                    for (Expression e : ve = ((EnumeratedPropertyPrompt)pp).getValueExpressions()) {
                        if (e == null) continue;
                        l.add(e.getExpression());
                    }
                }
            }
        }
        return l;
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[]{ChangePropertyButton.OLD_VALUE_FORMAT, ChangePropertyButton.NEW_VALUE_FORMAT, ChangePropertyButton.DESCRIPTION_FORMAT});
        }
    }

    public static class PropChangerOptions
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            PropertyChangerConfigurer cfg = ((ChangePropertyButton)c).propChangeConfig;
            cfg.setContext(c);
            return cfg;
        }
    }
}

