/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Configurable;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.Dialogs;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.ArrayUtils;

public class OpenContainedPiecesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Configurable target;
    protected HelpWindow helpWindow;
    protected Frame dialogOwner;
    protected ConfigureTree tree;

    public OpenContainedPiecesAction(Configurable target, HelpWindow helpWindow, Frame dialogOwner, ConfigureTree tree) {
        super(Resources.getString("Editor.OpenContainedPiecesAction.what_it_does"));
        this.target = target;
        this.helpWindow = helpWindow;
        this.dialogOwner = dialogOwner;
        this.tree = tree;
        this.setEnabled(Arrays.stream(target.getConfigureComponents()).anyMatch(c -> c instanceof PieceSlot));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object[] items = this.target.getConfigureComponents();
        if (items.length > 40) {
            String message = Resources.getString("Editor.OpenContainedPiecesAction.this_will_load", items.length);
            int result = Dialogs.showConfirmDialog(null, Resources.getString("Editor.OpenContainedPiecesAction.confirm_open"), Resources.getString("Editor.OpenContainedPiecesAction.confirm_open"), message, 2, 0);
            if (result != 0) {
                return;
            }
        }
        ArrayUtils.reverse((Object[])items);
        for (Object c : items) {
            if (!(c instanceof PieceSlot)) continue;
            new EditPropertiesAction((Configurable)c, this.helpWindow, this.dialogOwner, this.tree).actionPerformed(null);
        }
    }
}

