/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.i18n.Resources;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.AudioClip;
import VASSAL.tools.AudioSystemClip;
import VASSAL.tools.Mp3AudioClip;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.ZipArchive;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class DataArchive
extends SecureClassLoader
implements Closeable {
    protected FileArchive archive;
    protected List<DataArchive> extensions = new ArrayList<DataArchive>();
    private final Map<String, AudioClip> soundCache = new HashMap<String, AudioClip>();
    protected SortedSet<String> localImages = null;
    protected SortedSet<String>[] cachedLocalImages = new SortedSet[4];
    public static final String IMAGE_DIR = "images/";
    protected String imageDir = "images/";
    public static final String SOUND_DIR = "sounds/";
    protected String soundDir = "sounds/";
    public static final String ICON_DIR = "icons/";
    private static final CodeSource cs = new CodeSource(null, (Certificate[])null);

    protected DataArchive() {
        super(DataArchive.class.getClassLoader());
        this.resetLocalImages();
    }

    public DataArchive(String zipName, String imageDir) throws IOException {
        this();
        this.archive = new ZipArchive(zipName);
        this.imageDir = imageDir;
    }

    public DataArchive(String zipName) throws IOException {
        this(zipName, IMAGE_DIR);
    }

    @Override
    public String getName() {
        return this.archive == null ? "data archive" : this.archive.getName();
    }

    public FileArchive getArchive() {
        return this.archive;
    }

    public String getImagePrefix() {
        return this.imageDir;
    }

    public AudioClip getCachedAudioClip(String name) throws IOException {
        String path = this.soundDir + name;
        AudioClip clip = this.soundCache.get(path);
        if (clip == null) {
            if (name.toLowerCase().endsWith(".mp3")) {
                clip = new Mp3AudioClip(path);
            } else {
                try (InputStream stream = this.getInputStream(path);){
                    clip = new AudioSystemClip(stream);
                }
            }
            this.soundCache.put(path, clip);
        }
        return clip;
    }

    public InputStream getInputStream(String fileName) throws IOException, FileNotFoundException {
        if (fileName.startsWith("/")) {
            InputStream in = this.getClass().getResourceAsStream(fileName);
            if (in != null) {
                return in;
            }
            throw new FileNotFoundException("Resource not found: " + fileName);
        }
        InputStream in = this.getInputStreamImpl(fileName);
        if (in != null) {
            return in;
        }
        String nfd = Normalizer.normalize(fileName, Normalizer.Form.NFD);
        if (!fileName.equals(nfd) && (in = this.getInputStreamImpl(nfd)) != null) {
            return in;
        }
        in = this.getClass().getResourceAsStream("/" + fileName);
        if (in != null) {
            return in;
        }
        in = this.getInputStreamImpl(fileName + ".gif");
        if (in != null) {
            return in;
        }
        in = this.getClass().getResourceAsStream("/" + fileName + ".gif");
        if (in != null) {
            return in;
        }
        throw new FileNotFoundException("'" + fileName + "' not found in " + this.getName());
    }

    private InputStream getInputStreamImpl(String fileName) throws IOException {
        if (this.archive != null && this.archive.contains(fileName)) {
            return this.archive.getInputStream(fileName);
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getInputStream(fileName);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
        }
        return null;
    }

    public URL getURL() throws IOException {
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        return URLUtils.toJarURL(this.archive.getName());
    }

    public URL getURL(String fileName) throws IOException, FileNotFoundException {
        if (fileName.startsWith("/")) {
            return this.getClass().getResource(fileName);
        }
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        if (this.archive.contains(fileName)) {
            return new URL(this.getURL(), fileName);
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getURL(fileName);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
        }
        throw new FileNotFoundException("'" + fileName + "' not found in " + this.getName());
    }

    public boolean contains(String fileName) throws IOException {
        if (this.archive == null) {
            return false;
        }
        return this.archive.contains(fileName);
    }

    @Override
    public void close() throws IOException {
        if (this.archive != null) {
            this.archive.revert();
            this.archive.close();
        }
    }

    public String[] getImageNames() {
        SortedSet<String> s = this.getImageNameSet();
        return s.toArray(new String[0]);
    }

    public SortedSet<String> getImageNameSet() {
        return this.getImageNameSet(false, false);
    }

    public SortedSet<String> getImageNameSet(boolean localized, boolean fullPath) {
        TreeSet<String> s = new TreeSet<String>();
        this.getImageNamesRecursively(s, localized, fullPath);
        return s;
    }

    private int getLocalImagesCacheIndex(boolean localized, boolean fullPath) {
        int i = 0;
        if (localized) {
            i = 1;
        }
        if (fullPath) {
            i += 2;
        }
        return i;
    }

    protected void getImageNamesRecursively(SortedSet<String> s, boolean localized, boolean fullPath) {
        int index = this.getLocalImagesCacheIndex(localized, fullPath);
        if (this.cachedLocalImages[index] == null) {
            this.cachedLocalImages[index] = this.getAllLocalImageNames(localized, fullPath);
            if (!localized && !fullPath) {
                this.localImages = this.cachedLocalImages[index];
            }
        }
        s.addAll(this.cachedLocalImages[index]);
        for (DataArchive ext : this.extensions) {
            ext.getImageNamesRecursively(s, localized, fullPath);
        }
    }

    protected void getImageNamesRecursively(SortedSet<String> s) {
        this.getImageNamesRecursively(s, false, false);
    }

    protected SortedSet<String> getLocalImageNames() {
        return this.getAllLocalImageNames(false, true);
    }

    protected void buildLocalizedDirectoryList(List<String> list) {
        List<String> files;
        try {
            files = this.archive.getFiles("");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        HashSet<String> dirs = new HashSet<String>();
        String base = this.imageDir.substring(0, this.imageDir.length() - 1) + "_";
        for (String fname : files) {
            int sep;
            if (!fname.startsWith(base) || (sep = fname.indexOf(47, base.length())) == -1) continue;
            dirs.add(fname.substring(0, sep + 1));
        }
        list.addAll(dirs);
    }

    protected void getAllLocalImageNamesForDirectory(SortedSet<String> s, String directory, boolean fullPath) {
        int trimlen = directory.length();
        String root = directory.substring(0, trimlen - 1);
        try {
            for (String filename : this.archive.getFiles(root)) {
                String trimmedFileName = filename.substring(trimlen);
                if (trimmedFileName.isEmpty()) continue;
                String fn = fullPath ? root + "/" + trimmedFileName : trimmedFileName;
                s.add(fn);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected SortedSet<String> getAllLocalImageNames(boolean localized, boolean fullPath) {
        TreeSet<String> s = new TreeSet<String>();
        if (this.archive != null) {
            ArrayList<String> directories = new ArrayList<String>();
            directories.add(this.imageDir);
            if (localized) {
                this.buildLocalizedDirectoryList(directories);
            }
            for (String directory : directories) {
                this.getAllLocalImageNamesForDirectory(s, directory, fullPath);
            }
        }
        return s;
    }

    public void addExtension(DataArchive ext) {
        this.extensions.add(ext);
    }

    public ArchiveWriter getWriter() {
        if (this instanceof ArchiveWriter) {
            return (ArchiveWriter)this;
        }
        for (DataArchive ext : this.extensions) {
            ArchiveWriter writer = ext.getWriter();
            if (writer == null) continue;
            return writer;
        }
        return null;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            c = this.findLoadedClass(name);
        }
        if (c == null) {
            return this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection p = super.getPermissions(codesource);
        p.add(new AllPermission());
        return p;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] data;
        String slashname = name.replace('.', '/');
        try (InputStream stream = this.getInputStream(slashname + ".class");){
            data = stream.readAllBytes();
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Unable to load class " + name, e);
        }
        int minor = data[4] << 8 | data[5];
        int major = data[6] << 8 | data[7];
        if (major > 55 || major == 55 && minor != 0) {
            ProblemDialog.showDisableable(2, null, null, (Object)cs, Resources.getString("Dialogs.incompatible.title"), Resources.getString("Dialogs.incompatible.heading"), Resources.getString("Dialogs.incompatible.message", name) + "\n\n" + Resources.getString("Dialogs.check_for_updated_module"));
        }
        return this.defineClass(name, data, 0, data.length, cs);
    }

    private void resetLocalImages() {
        for (int i = 0; i < this.cachedLocalImages.length; ++i) {
            this.cachedLocalImages[i] = null;
        }
        this.localImages = null;
    }
}

