/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import org.apache.commons.lang3.StringUtils;

public class QuickColors {
    public static final String QUICK_COLOR_CODES = "|!?~`";
    public static final int QUICK_COLOR_NONE = -1;
    public static final String[] QUICK_COLOR_REGEX = new String[]{"\\|", "!", "\\?", "~", "`"};

    public static int getQuickColor(char c) {
        return QUICK_COLOR_CODES.indexOf(c);
    }

    public static int getQuickColor(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return -1;
        }
        String s2 = s.trim();
        if (s2.isEmpty()) {
            return -1;
        }
        return QuickColors.getQuickColor(s2.charAt(0));
    }

    public static int getQuickColor(String s, String prefix) {
        if (StringUtils.isEmpty((CharSequence)s) || s.isBlank()) {
            return -1;
        }
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return QuickColors.getQuickColor(s);
        }
        if (!s.startsWith(prefix)) {
            return -1;
        }
        String s2 = s.substring(prefix.length()).trim();
        if (s2.isEmpty()) {
            return -1;
        }
        return QuickColors.getQuickColor(s2.charAt(0));
    }

    public static String stripQuickColorTag(String s) {
        return QuickColors.stripQuickColorTag(s, "");
    }

    public static String stripQuickColorTag(String s, String prefix) {
        int quickIndex = QuickColors.getQuickColor(s, prefix);
        if (quickIndex < 0) {
            return s;
        }
        return s.replaceFirst(QUICK_COLOR_REGEX[quickIndex], "");
    }

    public static String getQuickColorHTMLStyle(String s) {
        return QuickColors.getQuickColorHTMLStyle(s, "");
    }

    public static String getQuickColorHTMLStyle(String s, String prefix) {
        int quickIndex = QuickColors.getQuickColor(s, prefix);
        return "msg" + String.valueOf(quickIndex <= 0 ? "" : Integer.valueOf(quickIndex + 1));
    }
}

