/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ComponentDescription;
import VASSAL.i18n.Localization;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class Widget
extends AbstractConfigurable
implements ComponentDescription {
    public static final String DESCRIPTION = "description";
    public static final String NAME = "entryName";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    protected Element buildElement;
    protected Widget parent;
    protected String description;

    protected Widget() {
    }

    public boolean hasScale() {
        return false;
    }

    public boolean hasScalablePieces() {
        Widget w = this;
        while ((w = w.getParent()) != null) {
            if (!(w instanceof ChartWindow)) continue;
            return false;
        }
        return true;
    }

    public double getScale() {
        return 1.0;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void build(Element el) {
        this.buildElement = el;
        if (el != null) {
            NamedNodeMap n = el.getAttributes();
            for (int i = 0; i < n.getLength(); ++i) {
                Attr att = (Attr)n.item(i);
                this.setAttribute(att.getName(), att.getValue());
                Localization.getInstance().saveTranslatableAttribute(this, att.getName(), att.getValue());
            }
        }
    }

    protected void rebuild() {
        if (this.buildElement != null) {
            Builder.build(this.buildElement, this);
            this.buildElement = null;
        }
    }

    @Override
    public Element getBuildElement(Document doc) {
        this.rebuild();
        return super.getBuildElement(doc);
    }

    public Class<?>[] getChildAllowableConfigureComponents() {
        return this.parent.getChildAllowableConfigureComponents();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return this.parent.getChildAllowableConfigureComponents();
    }

    @Override
    public void addTo(Buildable b) {
        this.parent = (Widget)b;
    }

    @Override
    public void removeFrom(Buildable b) {
    }

    public Widget getParent() {
        return this.parent;
    }

    @Override
    public Configurable[] getConfigureComponents() {
        this.rebuild();
        return super.getConfigureComponents();
    }

    public abstract Component getComponent();

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public static class MyCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PieceSlot) {
                PieceSlot slot = (PieceSlot)value;
                String localizedName = slot.getLocalizedConfigureName();
                this.setText(localizedName == null || localizedName.isBlank() ? slot.getConfigureName() : localizedName);
            } else if (value instanceof AbstractConfigurable) {
                AbstractConfigurable c = (AbstractConfigurable)value;
                String localizedName = c.getLocalizedConfigureName();
                this.setText(localizedName == null || localizedName.isBlank() ? c.getConfigureName() : localizedName);
            }
            return this;
        }
    }
}

