/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractFolder;
import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;

public class ToolbarMenu
extends AbstractToolbarItem
implements ContainerListener,
PropertyChangeListener,
GameComponent {
    public static final String DESCRIPTION = "description";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_HOTKEY = "hotkey";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    public static final String MENU_ITEMS = "menuItems";
    public static final String MENU_PROPERTY = "ToolbarMenu.popup";
    public static final String MENU_ICON_PROPERTY = "ToolbarMenu.popupIcon";
    public static final String HIDDEN_BY_TOOLBAR = "hidden";
    protected List<String> menuItems = new ArrayList<String>();
    protected Map<AbstractButton, JMenuItem> buttonsToMenuMap = new HashMap<AbstractButton, JMenuItem>();
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    protected JToolBar toolbar;
    protected JPopupMenu menu;
    protected Runnable menuBuilder;

    public ToolbarMenu() {
        this.setNameKey(DESCRIPTION);
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Editor.ToolbarMenu.tooltip_text"), Resources.getString("General.menu"), "", e -> this.launch()));
        this.launch = this.getLaunchButton();
        this.menu = new JPopupMenu();
        this.getLaunchButton().putClientProperty(MENU_PROPERTY, this.menu);
        this.getLaunchButton().putClientProperty(MENU_ICON_PROPERTY, this.launch.getLaunchIcon());
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public void launch() {
        LaunchButton lb = this.getLaunchButton();
        if (lb.isShowing()) {
            this.menu.show(lb, 0, 0);
        }
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.ToolbarMenu.menu_entries")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{String[].class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{MENU_ITEMS});
    }

    @Override
    public String getAttributeValueString(String key) {
        if (MENU_ITEMS.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.menuItems.toArray(new String[0]));
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (MENU_ITEMS.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.menuItems = new ArrayList<String>(Arrays.asList(value));
            if (this.toolbar != null) {
                this.scheduleBuildMenu();
            }
        } else {
            super.setAttribute(key, value);
            if (this.getLaunchButton().getIconAttribute().equals(key)) {
                this.getLaunchButton().putClientProperty(MENU_ICON_PROPERTY, this.getLaunchButton().getLaunchIcon());
            }
        }
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        if (parent instanceof ToolBarComponent) {
            this.toolbar = ((ToolBarComponent)((Object)parent)).getToolBar();
        }
        if (this.toolbar != null) {
            this.toolbar.add(this.getLaunchButton());
            this.toolbar.addContainerListener(this);
            this.scheduleBuildMenu();
        }
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ToolbarMenu.html");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ToolbarMenu.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.toolbar.remove(this.getLaunchButton());
        this.toolbar.removeContainerListener(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    protected void buildMenu() {
        JButton b;
        for (AbstractButton b2 : this.buttonsToMenuMap.keySet()) {
            b2.removePropertyChangeListener(this);
            b2.setVisible(true);
            b2.putClientProperty(HIDDEN_BY_TOOLBAR, null);
        }
        this.buttonsToMenuMap.clear();
        this.menu.removeAll();
        HashMap<String, JButton> nameToButton = new HashMap<String, JButton>();
        if (this.toolbar != null) {
            int n = this.toolbar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!(this.toolbar.getComponentAtIndex(i) instanceof JButton)) continue;
                b = (JButton)this.toolbar.getComponentAtIndex(i);
                String text = (String)b.getClientProperty("unTranslatedText");
                if (text == null) {
                    text = b.getText();
                }
                nameToButton.put(text, b);
            }
        }
        for (String item : this.menuItems) {
            b = (JButton)nameToButton.get(item);
            if (b == null) continue;
            Object property = b.getClientProperty(MENU_PROPERTY);
            b.addPropertyChangeListener(this);
            b.setVisible(false);
            b.putClientProperty(HIDDEN_BY_TOOLBAR, Boolean.TRUE);
            if (property instanceof JPopupMenu) {
                Component[] items;
                JPopupMenu toolbarMenu = (JPopupMenu)property;
                toolbarMenu.addContainerListener(this);
                JMenu subMenu = new JMenu(b.getText());
                for (Component component : items = toolbarMenu.getComponents()) {
                    JMenuItem otherItem = (JMenuItem)component;
                    JMenuItem myItem = new JMenuItem(otherItem.getText(), otherItem.getIcon());
                    myItem.addActionListener(e -> otherItem.doClick());
                    myItem.setEnabled(otherItem.isEnabled());
                    subMenu.add(myItem);
                    this.buttonsToMenuMap.put(otherItem, myItem);
                }
                this.buttonsToMenuMap.put(b, subMenu);
                Object icon = b.getClientProperty(MENU_ICON_PROPERTY);
                if (icon instanceof Icon) {
                    subMenu.setIcon((Icon)icon);
                }
                this.menu.add(subMenu);
                continue;
            }
            JMenuItem mi = new JMenuItem(b.getText(), b.getIcon());
            mi.setEnabled(b.isEnabled());
            mi.addActionListener(e -> b.doClick());
            this.buttonsToMenuMap.put(b, mi);
            this.menu.add(mi);
        }
    }

    protected void scheduleBuildMenu() {
        if (this.menuBuilder == null) {
            this.menuBuilder = () -> {
                this.buildMenu();
                this.menuBuilder = null;
            };
            SwingUtilities.invokeLater(this.menuBuilder);
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.scheduleBuildMenu();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.scheduleBuildMenu();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JButton b;
        JMenuItem mi;
        super.propertyChange(evt);
        if (evt.getSource() instanceof JButton && (mi = this.buttonsToMenuMap.get(b = (JButton)evt.getSource())) != null) {
            if (BUTTON_TEXT.equals(evt.getPropertyName())) {
                this.scheduleBuildMenu();
            } else if ("enabled".equals(evt.getPropertyName())) {
                mi.setEnabled(b.isEnabled());
            } else if (BUTTON_ICON.equals(evt.getPropertyName())) {
                mi.setIcon(b.getIcon());
            }
        }
    }

    @Override
    public void setup(boolean gameStarting) {
        super.setup(gameStarting);
        this.scheduleBuildMenu();
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public List<String> getMenuTextList() {
        ArrayList<String> l = new ArrayList<String>(super.getMenuTextList());
        l.addAll(this.menuItems);
        return l;
    }
}

